/*
 * Decompiled with CFR 0.152.
 */
package com.heinrichreimersoftware.materialintro.app;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ArgbEvaluator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.databinding.DataBindingUtil;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.ColorRes;
import android.support.annotation.IntRange;
import android.support.annotation.InterpolatorRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.ColorUtils;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.util.Pair;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.widget.Button;
import com.heinrichreimersoftware.materialintro.R;
import com.heinrichreimersoftware.materialintro.app.IntroNavigation;
import com.heinrichreimersoftware.materialintro.app.NavigationPolicy;
import com.heinrichreimersoftware.materialintro.app.OnNavigationBlockedListener;
import com.heinrichreimersoftware.materialintro.databinding.MiActivityIntroBinding;
import com.heinrichreimersoftware.materialintro.slide.ButtonCtaSlide;
import com.heinrichreimersoftware.materialintro.slide.Slide;
import com.heinrichreimersoftware.materialintro.slide.SlideAdapter;
import com.heinrichreimersoftware.materialintro.util.AnimUtils;
import com.heinrichreimersoftware.materialintro.util.CheatSheet;
import com.heinrichreimersoftware.materialintro.view.FadeableViewPager;
import com.heinrichreimersoftware.materialintro.view.parallax.Parallaxable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@SuppressLint(value={"Registered"})
public class IntroActivity
extends AppCompatActivity
implements IntroNavigation {
    private static final String KEY_CURRENT_ITEM = "com.heinrichreimersoftware.materialintro.app.IntroActivity.KEY_CURRENT_ITEM";
    private static final String KEY_FULLSCREEN = "com.heinrichreimersoftware.materialintro.app.IntroActivity.KEY_FULLSCREEN";
    private static final String KEY_BUTTON_CTA_VISIBLE = "com.heinrichreimersoftware.materialintro.app.IntroActivity.KEY_BUTTON_CTA_VISIBLE";
    private boolean activityCreated = false;
    public static final int BUTTON_NEXT_FUNCTION_NEXT = 1;
    public static final int BUTTON_NEXT_FUNCTION_NEXT_FINISH = 2;
    public static final int BUTTON_BACK_FUNCTION_BACK = 1;
    public static final int BUTTON_BACK_FUNCTION_SKIP = 2;
    public static final int BUTTON_CTA_TINT_MODE_BACKGROUND = 1;
    public static final int BUTTON_CTA_TINT_MODE_TEXT = 2;
    public static final int DEFAULT_AUTOPLAY_DELAY = 1500;
    public static final int INFINITE = -1;
    public static final int DEFAULT_AUTOPLAY_REPEAT_COUNT = -1;
    public static final Interpolator ACCELERATE_DECELERATE_INTERPOLATOR = new AccelerateDecelerateInterpolator();
    private final ArgbEvaluator evaluator = new ArgbEvaluator();
    private MiActivityIntroBinding binding;
    private SlideAdapter adapter;
    private IntroPageChangeListener listener = new IntroPageChangeListener();
    private int position = 0;
    private float positionOffset = 0.0f;
    private boolean fullscreen = false;
    private boolean buttonCtaVisible = false;
    private int buttonNextFunction = 2;
    private int buttonBackFunction = 2;
    private int buttonCtaTintMode = 1;
    private NavigationPolicy navigationPolicy = null;
    private List<OnNavigationBlockedListener> navigationBlockedListeners = new ArrayList<OnNavigationBlockedListener>();
    private CharSequence buttonCtaLabel = null;
    @StringRes
    private int buttonCtaLabelRes = 0;
    private View.OnClickListener buttonCtaClickListener = null;
    private Handler autoplayHandler = new Handler();
    private Runnable autoplayCallback = null;
    private int autoplayCounter;
    private long autoplayDelay;
    private Interpolator pageScrollInterpolator;
    private long pageScrollDuration;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.pageScrollInterpolator = AnimationUtils.loadInterpolator((Context)this, (int)17563654);
        this.pageScrollDuration = this.getResources().getInteger(0x10E0000);
        if (savedInstanceState != null) {
            if (savedInstanceState.containsKey(KEY_CURRENT_ITEM)) {
                this.position = savedInstanceState.getInt(KEY_CURRENT_ITEM, this.position);
            }
            if (savedInstanceState.containsKey(KEY_FULLSCREEN)) {
                this.fullscreen = savedInstanceState.getBoolean(KEY_FULLSCREEN, this.fullscreen);
            }
            if (savedInstanceState.containsKey(KEY_BUTTON_CTA_VISIBLE)) {
                this.buttonCtaVisible = savedInstanceState.getBoolean(KEY_BUTTON_CTA_VISIBLE, this.buttonCtaVisible);
            }
        }
        if (this.fullscreen) {
            if (Build.VERSION.SDK_INT >= 16) {
                this.setSystemUiFlags(1280, true);
                this.updateFullscreen();
            } else {
                this.getWindow().setFlags(1024, 1024);
            }
        }
        this.getWindow().setSoftInputMode(16);
        this.binding = (MiActivityIntroBinding)DataBindingUtil.setContentView((Activity)this, (int)R.layout.mi_activity_intro);
        this.initViews();
    }

    protected void onPostCreate(Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        this.activityCreated = true;
        this.updateTaskDescription();
        this.updateButtonNextDrawable();
        this.updateButtonBackDrawable();
        this.updateScrollPositions();
        this.binding.miFrame.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                IntroActivity.this.updateScrollPositions();
                v.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
            }
        });
    }

    protected void onResume() {
        super.onResume();
        this.updateFullscreen();
    }

    public void onUserInteraction() {
        if (this.isAutoplaying()) {
            this.cancelAutoplay();
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        this.updateButtonCta();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(KEY_CURRENT_ITEM, this.binding.miPager.getCurrentItem());
        outState.putBoolean(KEY_FULLSCREEN, this.fullscreen);
        outState.putBoolean(KEY_BUTTON_CTA_VISIBLE, this.buttonCtaVisible);
    }

    public void onBackPressed() {
        if (this.position > 0) {
            this.previousSlide();
            return;
        }
        Intent returnIntent = this.onSendActivityResult(0);
        if (returnIntent != null) {
            this.setResult(0, returnIntent);
        } else {
            this.setResult(0);
        }
        super.onBackPressed();
    }

    public Intent onSendActivityResult(int result) {
        return null;
    }

    protected void onDestroy() {
        if (this.isAutoplaying()) {
            this.cancelAutoplay();
        }
        this.activityCreated = false;
        super.onDestroy();
    }

    private void setSystemUiFlags(int flags, boolean value) {
        int systemUiVisibility = this.getWindow().getDecorView().getSystemUiVisibility();
        systemUiVisibility = value ? (systemUiVisibility |= flags) : (systemUiVisibility &= ~flags);
        this.getWindow().getDecorView().setSystemUiVisibility(systemUiVisibility);
    }

    @TargetApi(value=16)
    private void setFullscreenFlags(boolean fullscreen) {
        int fullscreenFlags = 4;
        if (Build.VERSION.SDK_INT >= 19) {
            fullscreenFlags |= 0x1000;
        }
        this.setSystemUiFlags(fullscreenFlags, fullscreen);
    }

    private void initViews() {
        if (this.binding.miButtonCta != null) {
            this.binding.miButtonCta.setInAnimation((Context)this, R.anim.mi_fade_in);
            this.binding.miButtonCta.setOutAnimation((Context)this, R.anim.mi_fade_out);
        }
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        this.adapter = new SlideAdapter(fragmentManager);
        this.binding.miPager.setAdapter((PagerAdapter)this.adapter);
        this.binding.miPager.addOnPageChangeListener(this.listener);
        this.binding.miPager.setCurrentItem(this.position, false);
        this.binding.miPagerIndicator.setViewPager(this.binding.miPager);
        this.binding.miButtonNext.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                IntroActivity.this.nextSlide();
            }
        });
        this.binding.miButtonBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                IntroActivity.this.performButtonBackPress();
            }
        });
        CheatSheet.setup((View)this.binding.miButtonNext);
        CheatSheet.setup((View)this.binding.miButtonBack);
    }

    private void smoothScrollPagerTo(final int position) {
        if (this.binding.miPager.isFakeDragging()) {
            return;
        }
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{this.binding.miPager.getCurrentItem(), position});
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (((IntroActivity)IntroActivity.this).binding.miPager.isFakeDragging()) {
                    ((IntroActivity)IntroActivity.this).binding.miPager.endFakeDrag();
                }
                ((IntroActivity)IntroActivity.this).binding.miPager.setCurrentItem(position);
            }

            public void onAnimationCancel(Animator animation) {
                if (((IntroActivity)IntroActivity.this).binding.miPager.isFakeDragging()) {
                    ((IntroActivity)IntroActivity.this).binding.miPager.endFakeDrag();
                }
            }
        });
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float position = ((Float)animation.getAnimatedValue()).floatValue();
                this.fakeDragToPosition(position);
            }

            private boolean fakeDragToPosition(float position) {
                float scrollX = ((IntroActivity)IntroActivity.this).binding.miPager.getScrollX();
                int pagerWidth = ((IntroActivity)IntroActivity.this).binding.miPager.getWidth();
                int currentPosition = ((IntroActivity)IntroActivity.this).binding.miPager.getCurrentItem();
                if (position > (float)currentPosition && Math.floor(position) != (double)currentPosition && position % 1.0f != 0.0f) {
                    ((IntroActivity)IntroActivity.this).binding.miPager.setCurrentItem((int)Math.floor(position), false);
                } else if (position < (float)currentPosition && Math.ceil(position) != (double)currentPosition && position % 1.0f != 0.0f) {
                    ((IntroActivity)IntroActivity.this).binding.miPager.setCurrentItem((int)Math.ceil(position), false);
                }
                if (!((IntroActivity)IntroActivity.this).binding.miPager.isFakeDragging() && !((IntroActivity)IntroActivity.this).binding.miPager.beginFakeDrag()) {
                    return false;
                }
                ((IntroActivity)IntroActivity.this).binding.miPager.fakeDragBy(scrollX - (float)pagerWidth * position);
                return true;
            }
        });
        int distance = Math.abs(position - this.binding.miPager.getCurrentItem());
        animator.setInterpolator((TimeInterpolator)this.pageScrollInterpolator);
        animator.setDuration(this.calculateScrollDuration(distance));
        animator.start();
    }

    private long calculateScrollDuration(int distance) {
        return Math.round((double)this.pageScrollDuration * ((double)distance + Math.sqrt(distance)) / 2.0);
    }

    @Override
    public boolean goToSlide(int position) {
        int newPosition;
        int lastPosition = this.binding.miPager.getCurrentItem();
        if (lastPosition >= this.adapter.getCount()) {
            this.finishIfNeeded();
        }
        if ((position = Math.max(0, Math.min(position, this.getCount()))) > lastPosition) {
            for (newPosition = lastPosition; newPosition < position && this.canGoForward(newPosition, true); ++newPosition) {
            }
        } else if (position < lastPosition) {
            while (newPosition > position && this.canGoBackward(newPosition, true)) {
                --newPosition;
            }
        } else {
            return true;
        }
        boolean blocked = false;
        if (newPosition != position) {
            blocked = true;
            if (position > lastPosition) {
                AnimUtils.applyShakeAnimation((Context)this, (View)this.binding.miButtonNext);
            } else if (position < lastPosition) {
                AnimUtils.applyShakeAnimation((Context)this, (View)this.binding.miButtonBack);
            }
        }
        this.smoothScrollPagerTo(newPosition);
        return !blocked;
    }

    @Override
    public boolean nextSlide() {
        int currentItem = this.binding.miPager.getCurrentItem();
        return this.goToSlide(currentItem + 1);
    }

    private int nextSlideAuto() {
        int lastPosition;
        int count = this.getCount();
        if (count == 1) {
            return 0;
        }
        if (this.binding.miPager.getCurrentItem() >= count - 1) {
            for (lastPosition = this.binding.miPager.getCurrentItem(); lastPosition >= 0 && this.canGoBackward(lastPosition, true); --lastPosition) {
            }
            if (this.autoplayCounter > 0) {
                --this.autoplayCounter;
            }
        } else if (this.canGoForward(lastPosition, true)) {
            ++lastPosition;
        }
        int distance = Math.abs(lastPosition - this.binding.miPager.getCurrentItem());
        if (lastPosition == this.binding.miPager.getCurrentItem()) {
            return 0;
        }
        this.smoothScrollPagerTo(lastPosition);
        if (this.autoplayCounter == 0) {
            return 0;
        }
        return distance;
    }

    @Override
    public boolean previousSlide() {
        int currentItem = this.binding.miPager.getCurrentItem();
        return this.goToSlide(currentItem - 1);
    }

    @Override
    public boolean goToLastSlide() {
        return this.goToSlide(this.getCount() - 1);
    }

    @Override
    public boolean goToFirstSlide() {
        return this.goToSlide(0);
    }

    private void performButtonBackPress() {
        if (this.buttonBackFunction == 2) {
            this.goToSlide(this.getCount());
        } else if (this.buttonBackFunction == 1) {
            this.previousSlide();
        }
    }

    private boolean canGoForward(int position, boolean notifyListeners) {
        boolean canGoForward;
        if (position >= this.getCount()) {
            return false;
        }
        if (position <= 0) {
            return true;
        }
        if (this.buttonNextFunction == 1 && position >= this.getCount() - 1) {
            return false;
        }
        boolean bl = canGoForward = (this.navigationPolicy == null || this.navigationPolicy.canGoForward(position)) && this.getSlide(position).canGoForward();
        if (!canGoForward && notifyListeners) {
            for (OnNavigationBlockedListener listener : this.navigationBlockedListeners) {
                listener.onNavigationBlocked(position, 1);
            }
        }
        return canGoForward;
    }

    private boolean canGoBackward(int position, boolean notifyListeners) {
        boolean canGoBackward;
        if (position <= 0) {
            return false;
        }
        if (position >= this.getCount()) {
            return true;
        }
        boolean bl = canGoBackward = (this.navigationPolicy == null || this.navigationPolicy.canGoBackward(position)) && this.getSlide(position).canGoBackward();
        if (!canGoBackward && notifyListeners) {
            for (OnNavigationBlockedListener listener : this.navigationBlockedListeners) {
                listener.onNavigationBlocked(position, -1);
            }
        }
        return canGoBackward;
    }

    private boolean finishIfNeeded() {
        if (this.positionOffset == 0.0f && this.position == this.adapter.getCount()) {
            Intent returnIntent = this.onSendActivityResult(-1);
            if (returnIntent != null) {
                this.setResult(-1, returnIntent);
            } else {
                this.setResult(-1);
            }
            this.finish();
            this.overridePendingTransition(0, 0);
            return true;
        }
        return false;
    }

    @Nullable
    private Pair<CharSequence, ? extends View.OnClickListener> getButtonCta(int position) {
        ButtonCtaSlide slide;
        if (position < this.getCount() && this.getSlide(position) instanceof ButtonCtaSlide && (slide = (ButtonCtaSlide)this.getSlide(position)).getButtonCtaClickListener() != null && (slide.getButtonCtaLabel() != null || slide.getButtonCtaLabelRes() != 0)) {
            if (slide.getButtonCtaLabel() != null) {
                return Pair.create((Object)slide.getButtonCtaLabel(), (Object)slide.getButtonCtaClickListener());
            }
            return Pair.create((Object)this.getString(slide.getButtonCtaLabelRes()), (Object)slide.getButtonCtaClickListener());
        }
        if (this.buttonCtaVisible) {
            if (this.buttonCtaLabelRes != 0) {
                return Pair.create((Object)this.getString(this.buttonCtaLabelRes), (Object)new ButtonCtaClickListener());
            }
            if (!TextUtils.isEmpty((CharSequence)this.buttonCtaLabel)) {
                return Pair.create((Object)this.buttonCtaLabel, (Object)new ButtonCtaClickListener());
            }
            return Pair.create((Object)this.getString(R.string.mi_label_button_cta), (Object)new ButtonCtaClickListener());
        }
        return null;
    }

    private void updateTaskDescription() {
        if (Build.VERSION.SDK_INT >= 21) {
            int colorPrimary;
            Bitmap icon;
            String title = this.getTitle().toString();
            Drawable iconDrawable = this.getApplicationInfo().loadIcon(this.getPackageManager());
            Bitmap bitmap = icon = iconDrawable instanceof BitmapDrawable ? ((BitmapDrawable)iconDrawable).getBitmap() : null;
            if (this.position < this.getCount()) {
                try {
                    colorPrimary = ContextCompat.getColor((Context)this, (int)this.getBackgroundDark(this.position));
                }
                catch (Resources.NotFoundException e) {
                    colorPrimary = ContextCompat.getColor((Context)this, (int)this.getBackground(this.position));
                }
            } else {
                TypedValue typedValue = new TypedValue();
                TypedArray a = this.obtainStyledAttributes(typedValue.data, new int[]{R.attr.colorPrimary});
                colorPrimary = a.getColor(0, 0);
                a.recycle();
            }
            colorPrimary = ColorUtils.setAlphaComponent((int)colorPrimary, (int)255);
            this.setTaskDescription(new ActivityManager.TaskDescription(title, icon, colorPrimary));
        }
    }

    private void updateBackground() {
        int backgroundDarkNext;
        int backgroundDark;
        int backgroundNext;
        int background;
        if (this.position == this.getCount()) {
            background = 0;
            backgroundNext = 0;
            backgroundDark = 0;
            backgroundDarkNext = 0;
        } else {
            background = ContextCompat.getColor((Context)this, (int)this.getBackground(this.position));
            backgroundNext = ContextCompat.getColor((Context)this, (int)this.getBackground(Math.min(this.position + 1, this.getCount() - 1)));
            background = ColorUtils.setAlphaComponent((int)background, (int)255);
            backgroundNext = ColorUtils.setAlphaComponent((int)backgroundNext, (int)255);
            try {
                backgroundDark = ContextCompat.getColor((Context)this, (int)this.getBackgroundDark(this.position));
            }
            catch (Resources.NotFoundException e) {
                backgroundDark = ContextCompat.getColor((Context)this, (int)R.color.mi_status_bar_background);
            }
            try {
                backgroundDarkNext = ContextCompat.getColor((Context)this, (int)this.getBackgroundDark(Math.min(this.position + 1, this.getCount() - 1)));
            }
            catch (Resources.NotFoundException e) {
                backgroundDarkNext = ContextCompat.getColor((Context)this, (int)R.color.mi_status_bar_background);
            }
        }
        if ((float)this.position + this.positionOffset >= (float)(this.adapter.getCount() - 1)) {
            backgroundNext = ColorUtils.setAlphaComponent((int)background, (int)0);
            backgroundDarkNext = ColorUtils.setAlphaComponent((int)backgroundDark, (int)0);
        }
        background = (Integer)this.evaluator.evaluate(this.positionOffset, (Object)background, (Object)backgroundNext);
        backgroundDark = (Integer)this.evaluator.evaluate(this.positionOffset, (Object)backgroundDark, (Object)backgroundDarkNext);
        this.binding.miFrame.setBackgroundColor(background);
        float[] backgroundDarkHsv = new float[3];
        Color.colorToHSV((int)backgroundDark, (float[])backgroundDarkHsv);
        backgroundDarkHsv[2] = (float)((double)backgroundDarkHsv[2] * 0.95);
        int backgroundDarker = Color.HSVToColor((float[])backgroundDarkHsv);
        this.binding.miPagerIndicator.setPageIndicatorColor(backgroundDarker);
        ViewCompat.setBackgroundTintList((View)this.binding.miButtonNext, (ColorStateList)ColorStateList.valueOf((int)backgroundDarker));
        ViewCompat.setBackgroundTintList((View)this.binding.miButtonBack, (ColorStateList)ColorStateList.valueOf((int)backgroundDarker));
        int backgroundButtonCta = this.buttonCtaTintMode == 2 ? ContextCompat.getColor((Context)this, (int)17170443) : backgroundDarker;
        ViewCompat.setBackgroundTintList((View)this.binding.miButtonCta.getChildAt(0), (ColorStateList)ColorStateList.valueOf((int)backgroundButtonCta));
        ViewCompat.setBackgroundTintList((View)this.binding.miButtonCta.getChildAt(1), (ColorStateList)ColorStateList.valueOf((int)backgroundButtonCta));
        int iconColor = ColorUtils.calculateLuminance((int)backgroundDark) > 0.4 ? ContextCompat.getColor((Context)this, (int)R.color.mi_icon_color_light) : ContextCompat.getColor((Context)this, (int)R.color.mi_icon_color_dark);
        this.binding.miPagerIndicator.setCurrentPageIndicatorColor(iconColor);
        DrawableCompat.setTint((Drawable)this.binding.miButtonNext.getDrawable(), (int)iconColor);
        DrawableCompat.setTint((Drawable)this.binding.miButtonBack.getDrawable(), (int)iconColor);
        int textColorButtonCta = this.buttonCtaTintMode == 2 ? backgroundDarker : iconColor;
        ((Button)this.binding.miButtonCta.getChildAt(0)).setTextColor(textColorButtonCta);
        ((Button)this.binding.miButtonCta.getChildAt(1)).setTextColor(textColorButtonCta);
        if (Build.VERSION.SDK_INT >= 21) {
            this.getWindow().setStatusBarColor(backgroundDark);
            if (this.position == this.adapter.getCount()) {
                this.getWindow().setNavigationBarColor(0);
            } else if ((float)this.position + this.positionOffset >= (float)(this.adapter.getCount() - 1)) {
                TypedValue typedValue = new TypedValue();
                TypedArray a = this.obtainStyledAttributes(typedValue.data, new int[]{16843858});
                int defaultNavigationBarColor = a.getColor(0, -16777216);
                a.recycle();
                int navigationBarColor = (Integer)this.evaluator.evaluate(this.positionOffset, (Object)defaultNavigationBarColor, (Object)0);
                this.getWindow().setNavigationBarColor(navigationBarColor);
            }
            if (Build.VERSION.SDK_INT >= 23) {
                int systemUiVisibility = this.getWindow().getDecorView().getSystemUiVisibility();
                int flagLightStatusBar = 8192;
                systemUiVisibility = ColorUtils.calculateLuminance((int)backgroundDark) > 0.4 ? (systemUiVisibility |= flagLightStatusBar) : (systemUiVisibility &= ~flagLightStatusBar);
                this.getWindow().getDecorView().setSystemUiVisibility(systemUiVisibility);
            }
        }
    }

    private void updateButtonCta() {
        float realPosition = (float)this.position + this.positionOffset;
        float yOffset = this.getResources().getDimensionPixelSize(R.dimen.mi_y_offset);
        if (realPosition < (float)this.adapter.getCount()) {
            Pair<CharSequence, ? extends View.OnClickListener> buttonNext;
            Pair<CharSequence, ? extends View.OnClickListener> button = this.getButtonCta(this.position);
            Pair<CharSequence, ? extends View.OnClickListener> pair = buttonNext = this.positionOffset == 0.0f ? null : this.getButtonCta(this.position + 1);
            if (button == null) {
                if (buttonNext == null) {
                    this.binding.miButtonCta.setVisibility(8);
                } else {
                    this.binding.miButtonCta.setVisibility(0);
                    if (!((Button)this.binding.miButtonCta.getCurrentView()).getText().equals(buttonNext.first)) {
                        this.binding.miButtonCta.setText((CharSequence)buttonNext.first);
                    }
                    this.binding.miButtonCta.getChildAt(0).setOnClickListener((View.OnClickListener)buttonNext.second);
                    this.binding.miButtonCta.getChildAt(1).setOnClickListener((View.OnClickListener)buttonNext.second);
                    this.binding.miButtonCta.setAlpha(this.positionOffset);
                    this.binding.miButtonCta.setScaleX(this.positionOffset);
                    this.binding.miButtonCta.setScaleY(this.positionOffset);
                    ViewGroup.LayoutParams layoutParams = this.binding.miButtonCta.getLayoutParams();
                    layoutParams.height = Math.round((float)this.getResources().getDimensionPixelSize(R.dimen.mi_button_cta_height) * ACCELERATE_DECELERATE_INTERPOLATOR.getInterpolation(this.positionOffset));
                    this.binding.miButtonCta.setLayoutParams(layoutParams);
                }
            } else if (buttonNext == null) {
                this.binding.miButtonCta.setVisibility(0);
                if (!((Button)this.binding.miButtonCta.getCurrentView()).getText().equals(button.first)) {
                    this.binding.miButtonCta.setText((CharSequence)button.first);
                }
                this.binding.miButtonCta.getChildAt(0).setOnClickListener((View.OnClickListener)button.second);
                this.binding.miButtonCta.getChildAt(1).setOnClickListener((View.OnClickListener)button.second);
                this.binding.miButtonCta.setAlpha(1.0f - this.positionOffset);
                this.binding.miButtonCta.setScaleX(1.0f - this.positionOffset);
                this.binding.miButtonCta.setScaleY(1.0f - this.positionOffset);
                ViewGroup.LayoutParams layoutParams = this.binding.miButtonCta.getLayoutParams();
                layoutParams.height = Math.round((float)this.getResources().getDimensionPixelSize(R.dimen.mi_button_cta_height) * ACCELERATE_DECELERATE_INTERPOLATOR.getInterpolation(1.0f - this.positionOffset));
                this.binding.miButtonCta.setLayoutParams(layoutParams);
            } else {
                this.binding.miButtonCta.setVisibility(0);
                ViewGroup.LayoutParams layoutParams = this.binding.miButtonCta.getLayoutParams();
                layoutParams.height = this.getResources().getDimensionPixelSize(R.dimen.mi_button_cta_height);
                this.binding.miButtonCta.setLayoutParams(layoutParams);
                if (this.positionOffset >= 0.5f) {
                    if (!((Button)this.binding.miButtonCta.getCurrentView()).getText().equals(buttonNext.first)) {
                        this.binding.miButtonCta.setText((CharSequence)buttonNext.first);
                    }
                    this.binding.miButtonCta.getChildAt(0).setOnClickListener((View.OnClickListener)buttonNext.second);
                    this.binding.miButtonCta.getChildAt(1).setOnClickListener((View.OnClickListener)buttonNext.second);
                } else {
                    if (!((Button)this.binding.miButtonCta.getCurrentView()).getText().equals(button.first)) {
                        this.binding.miButtonCta.setText((CharSequence)button.first);
                    }
                    this.binding.miButtonCta.getChildAt(0).setOnClickListener((View.OnClickListener)button.second);
                    this.binding.miButtonCta.getChildAt(1).setOnClickListener((View.OnClickListener)button.second);
                }
            }
        }
        if (realPosition < (float)(this.adapter.getCount() - 1)) {
            this.binding.miButtonCta.setTranslationY(0.0f);
        } else {
            this.binding.miButtonCta.setTranslationY(this.positionOffset * yOffset);
        }
    }

    private void updateButtonBackPosition() {
        float realPosition = (float)this.position + this.positionOffset;
        float yOffset = this.getResources().getDimensionPixelSize(R.dimen.mi_y_offset);
        if (realPosition < 1.0f && this.buttonBackFunction == 1) {
            this.binding.miButtonBack.setTranslationY((1.0f - this.positionOffset) * yOffset);
        } else if (realPosition < (float)(this.adapter.getCount() - 2)) {
            this.binding.miButtonBack.setTranslationY(0.0f);
            this.binding.miButtonBack.setTranslationX(0.0f);
        } else if (realPosition < (float)(this.adapter.getCount() - 1)) {
            if (this.buttonBackFunction == 2) {
                boolean rtl = Build.VERSION.SDK_INT >= 17 && this.getResources().getConfiguration().getLayoutDirection() == 1;
                this.binding.miButtonBack.setTranslationX(this.positionOffset * (float)(rtl ? 1 : -1) * (float)this.binding.miPager.getWidth());
            } else {
                this.binding.miButtonBack.setTranslationX(0.0f);
            }
        } else if (this.buttonBackFunction == 2) {
            boolean rtl = Build.VERSION.SDK_INT >= 17 && this.getResources().getConfiguration().getLayoutDirection() == 1;
            this.binding.miButtonBack.setTranslationX((float)((rtl ? 1 : -1) * this.binding.miPager.getWidth()));
        } else {
            this.binding.miButtonBack.setTranslationY(this.positionOffset * yOffset);
        }
    }

    private void updateButtonNextPosition() {
        float realPosition = (float)this.position + this.positionOffset;
        float yOffset = this.getResources().getDimensionPixelSize(R.dimen.mi_y_offset);
        if (realPosition < (float)(this.adapter.getCount() - 2)) {
            this.binding.miButtonNext.setTranslationY(0.0f);
        } else if (realPosition < (float)(this.adapter.getCount() - 1)) {
            if (this.buttonNextFunction == 2) {
                this.binding.miButtonNext.setTranslationY(0.0f);
            } else {
                this.binding.miButtonNext.setTranslationY(this.positionOffset * yOffset);
            }
        } else if (realPosition >= (float)(this.adapter.getCount() - 1)) {
            if (this.buttonNextFunction == 2) {
                this.binding.miButtonNext.setTranslationY(this.positionOffset * yOffset);
            } else {
                this.binding.miButtonNext.setTranslationY(-yOffset);
            }
        }
    }

    private void updatePagerIndicatorPosition() {
        float realPosition = (float)this.position + this.positionOffset;
        float yOffset = this.getResources().getDimensionPixelSize(R.dimen.mi_y_offset);
        if (realPosition < (float)(this.adapter.getCount() - 1)) {
            this.binding.miPagerIndicator.setTranslationY(0.0f);
        } else {
            this.binding.miPagerIndicator.setTranslationY(this.positionOffset * yOffset);
        }
    }

    private void updateParallax() {
        Fragment fragmentNext;
        if (this.position == this.getCount()) {
            return;
        }
        Fragment fragment = this.getSlide(this.position).getFragment();
        Fragment fragment2 = fragmentNext = this.position < this.getCount() - 1 ? this.getSlide(this.position + 1).getFragment() : null;
        if (fragment instanceof Parallaxable) {
            ((Parallaxable)fragment).setOffset(this.positionOffset);
        }
        if (fragmentNext instanceof Parallaxable) {
            ((Parallaxable)fragmentNext).setOffset(-1.0f + this.positionOffset);
        }
    }

    private void updateFullscreen() {
        if (Build.VERSION.SDK_INT >= 16) {
            if (this.adapter != null && (float)this.position + this.positionOffset > (float)(this.adapter.getCount() - 1)) {
                this.setFullscreenFlags(false);
            } else {
                this.setFullscreenFlags(this.fullscreen);
            }
        }
    }

    private void updateBackgroundFade() {
        float realPosition = (float)this.position + this.positionOffset;
        if (realPosition < (float)(this.adapter.getCount() - 1)) {
            this.binding.miFrame.setAlpha(1.0f);
        } else {
            this.binding.miFrame.setAlpha(1.0f - this.positionOffset * 0.5f);
        }
    }

    private void updateScrollPositions() {
        this.updateBackground();
        this.updateButtonCta();
        this.updateButtonBackPosition();
        this.updateButtonNextPosition();
        this.updatePagerIndicatorPosition();
        this.updateParallax();
        this.updateFullscreen();
        this.updateBackgroundFade();
    }

    private void updateButtonNextDrawable() {
        float realPosition = (float)this.position + this.positionOffset;
        float offset = 0.0f;
        if (this.buttonNextFunction == 2) {
            if (realPosition >= (float)(this.adapter.getCount() - 1)) {
                offset = 1.0f;
            } else if (realPosition >= (float)(this.adapter.getCount() - 2)) {
                offset = this.positionOffset;
            }
        }
        if (offset <= 0.0f) {
            this.binding.miButtonNext.setImageResource(R.drawable.mi_ic_next);
            this.binding.miButtonNext.getDrawable().setAlpha(255);
        } else {
            this.binding.miButtonNext.setImageResource(R.drawable.mi_ic_next_finish);
            if (this.binding.miButtonNext.getDrawable() != null && this.binding.miButtonNext.getDrawable() instanceof LayerDrawable) {
                LayerDrawable drawable2 = (LayerDrawable)this.binding.miButtonNext.getDrawable();
                drawable2.getDrawable(0).setAlpha((int)(255.0f * (1.0f - offset)));
                drawable2.getDrawable(1).setAlpha((int)(255.0f * offset));
            } else {
                this.binding.miButtonNext.setImageResource(offset > 0.0f ? R.drawable.mi_ic_finish : R.drawable.mi_ic_next);
            }
        }
    }

    private void updateButtonBackDrawable() {
        if (this.buttonBackFunction == 2) {
            this.binding.miButtonBack.setImageResource(R.drawable.mi_ic_skip);
        } else {
            this.binding.miButtonBack.setImageResource(R.drawable.mi_ic_previous);
        }
    }

    public void autoplay(@IntRange(from=1L) long delay, @IntRange(from=-1L) int repeatCount) {
        this.autoplayCounter = repeatCount;
        this.autoplayDelay = delay;
        this.autoplayCallback = new Runnable(){

            @Override
            public void run() {
                if (IntroActivity.this.autoplayCounter == 0) {
                    IntroActivity.this.cancelAutoplay();
                    return;
                }
                int distance = IntroActivity.this.nextSlideAuto();
                if (distance != 0) {
                    IntroActivity.this.autoplayHandler.postDelayed(IntroActivity.this.autoplayCallback, IntroActivity.this.autoplayDelay + IntroActivity.this.calculateScrollDuration(distance));
                }
            }
        };
        this.autoplayHandler.postDelayed(this.autoplayCallback, this.autoplayDelay);
    }

    public void autoplay(@IntRange(from=1L) long delay) {
        this.autoplay(delay, -1);
    }

    public void autoplay(@IntRange(from=-1L) int repeatCount) {
        this.autoplay(1500L, repeatCount);
    }

    public void autoplay() {
        this.autoplay(1500L, -1);
    }

    public void cancelAutoplay() {
        this.autoplayHandler.removeCallbacks(this.autoplayCallback);
        this.autoplayCallback = null;
        this.autoplayCounter = 0;
        this.autoplayDelay = 0L;
    }

    public boolean isAutoplaying() {
        return this.autoplayCallback != null;
    }

    public long getPageScrollDuration() {
        return this.pageScrollDuration;
    }

    public void setPageScrollDuration(@IntRange(from=1L) long pageScrollDuration) {
        this.pageScrollDuration = pageScrollDuration;
    }

    public Interpolator getPageScrollInterpolator() {
        return this.pageScrollInterpolator;
    }

    public void setPageScrollInterpolator(Interpolator pageScrollInterpolator) {
        this.pageScrollInterpolator = pageScrollInterpolator;
    }

    public void setPageScrollInterpolator(@InterpolatorRes int interpolatorRes) {
        this.pageScrollInterpolator = AnimationUtils.loadInterpolator((Context)this, (int)interpolatorRes);
    }

    public boolean isFullscreen() {
        return this.fullscreen;
    }

    public void setFullscreen(boolean fullscreen) {
        this.fullscreen = fullscreen;
    }

    public boolean isButtonCtaVisible() {
        return this.buttonCtaVisible;
    }

    public void setButtonCtaVisible(boolean buttonCtaVisible) {
        this.buttonCtaVisible = buttonCtaVisible;
        this.updateButtonCta();
    }

    public int getButtonCtaTintMode() {
        return this.buttonCtaTintMode;
    }

    public void setButtonCtaTintMode(int buttonCtaTintMode) {
        this.buttonCtaTintMode = buttonCtaTintMode;
    }

    public int getButtonBackFunction() {
        return this.buttonBackFunction;
    }

    public void setButtonBackFunction(int buttonBackFunction) {
        this.buttonBackFunction = buttonBackFunction;
        switch (buttonBackFunction) {
            case 1: {
                CheatSheet.setup((View)this.binding.miButtonBack, R.string.mi_content_description_back);
                break;
            }
            case 2: {
                CheatSheet.setup((View)this.binding.miButtonBack, R.string.mi_content_description_skip);
            }
        }
        this.updateButtonBackDrawable();
        this.updateButtonBackPosition();
    }

    @Deprecated
    public boolean isSkipEnabled() {
        return this.buttonBackFunction == 2;
    }

    @Deprecated
    public void setSkipEnabled(boolean skipEnabled) {
        this.setButtonBackFunction(skipEnabled ? 2 : 1);
    }

    public int getButtonNextFunction() {
        return this.buttonNextFunction;
    }

    public void setButtonNextFunction(int buttonNextFunction) {
        this.buttonNextFunction = buttonNextFunction;
        switch (buttonNextFunction) {
            case 2: {
                CheatSheet.setup((View)this.binding.miButtonNext, R.string.mi_content_description_next_finish);
                break;
            }
            case 1: {
                CheatSheet.setup((View)this.binding.miButtonNext, R.string.mi_content_description_next);
            }
        }
        this.updateButtonNextDrawable();
        this.updateButtonNextPosition();
    }

    public View getContentView() {
        return this.findViewById(0x1020002);
    }

    @Deprecated
    public boolean isFinishEnabled() {
        return this.buttonNextFunction == 2;
    }

    @Deprecated
    public void setFinishEnabled(boolean finishEnabled) {
        this.setButtonNextFunction(finishEnabled ? 2 : 1);
    }

    public boolean isButtonBackVisible() {
        return this.binding.miButtonBack.getVisibility() == 0;
    }

    public void setButtonBackVisible(boolean visible) {
        this.binding.miButtonBack.setVisibility(visible ? 0 : 4);
    }

    public boolean isButtonNextVisible() {
        return this.binding.miButtonNext.getVisibility() == 0;
    }

    public void setButtonNextVisible(boolean visible) {
        this.binding.miButtonNext.setVisibility(visible ? 0 : 4);
    }

    public boolean isPagerIndicatorVisible() {
        return this.binding.miPagerIndicator.getVisibility() == 0;
    }

    public void setPagerIndicatorVisible(boolean visible) {
        this.binding.miPagerIndicator.setVisibility(visible ? 0 : 8);
    }

    @Deprecated
    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.binding.miPager.setOnPageChangeListener(listener);
        this.binding.miPager.addOnPageChangeListener(this.listener);
    }

    public void addOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.binding.miPager.addOnPageChangeListener(listener);
    }

    public void removeOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        if (listener != this.listener) {
            this.binding.miPager.removeOnPageChangeListener(listener);
        }
    }

    public View.OnClickListener getButtonCtaClickListener() {
        return this.buttonCtaClickListener;
    }

    public void setButtonCtaClickListener(View.OnClickListener buttonCtaClickListener) {
        this.buttonCtaClickListener = buttonCtaClickListener;
        this.updateButtonCta();
    }

    public CharSequence getButtonCtaLabel() {
        if (this.buttonCtaLabel != null) {
            return this.buttonCtaLabel;
        }
        return this.getString(this.buttonCtaLabelRes);
    }

    public void setButtonCtaLabel(@StringRes int buttonCtaLabelRes) {
        this.buttonCtaLabelRes = buttonCtaLabelRes;
        this.buttonCtaLabel = null;
        this.updateButtonCta();
    }

    public void setButtonCtaLabel(CharSequence buttonCtaLabel) {
        this.buttonCtaLabel = buttonCtaLabel;
        this.buttonCtaLabelRes = 0;
        this.updateButtonCta();
    }

    public void setNavigationPolicy(NavigationPolicy navigationPolicy) {
        this.navigationPolicy = navigationPolicy;
    }

    public void addOnNavigationBlockedListener(OnNavigationBlockedListener listener) {
        this.navigationBlockedListeners.add(listener);
    }

    public void removeOnNavigationBlockedListener(OnNavigationBlockedListener listener) {
        this.navigationBlockedListeners.remove(listener);
    }

    public void clearOnNavigationBlockedListeners() {
        this.navigationBlockedListeners.clear();
    }

    public void lockSwipeIfNeeded() {
        if (this.position < this.getCount()) {
            this.binding.miPager.setSwipeLeftEnabled(this.canGoForward(this.position, false));
            this.binding.miPager.setSwipeRightEnabled(this.canGoBackward(this.position, false));
        }
    }

    public void addSlide(int location, Slide object) {
        this.adapter.addSlide(location, object);
        this.notifyDataSetChanged();
    }

    public boolean addSlide(Slide object) {
        boolean modified = this.adapter.addSlide(object);
        if (modified) {
            this.notifyDataSetChanged();
        }
        return modified;
    }

    public boolean addSlides(int location, @NonNull Collection<? extends Slide> collection) {
        boolean modified = this.adapter.addSlides(location, collection);
        if (modified) {
            this.notifyDataSetChanged();
        }
        return modified;
    }

    public boolean addSlides(@NonNull Collection<? extends Slide> collection) {
        boolean modified = this.adapter.addSlides(collection);
        if (modified) {
            this.notifyDataSetChanged();
        }
        return modified;
    }

    public boolean clearSlides() {
        if (this.adapter.clearSlides()) {
            this.notifyDataSetChanged();
            return true;
        }
        return false;
    }

    public boolean containsSlide(Object object) {
        return this.adapter.containsSlide(object);
    }

    public boolean containsSlides(@NonNull Collection<?> collection) {
        return this.adapter.containsSlides(collection);
    }

    public Slide getSlide(int location) {
        return this.adapter.getSlide(location);
    }

    public int getSlidePosition(Slide slide) {
        return this.adapter.getItemPosition(slide);
    }

    public int getCurrentSlidePosition() {
        return this.binding.miPager.getCurrentItem();
    }

    public Fragment getItem(int position) {
        return this.adapter.getItem(position);
    }

    @ColorRes
    public int getBackground(int position) {
        return this.adapter.getBackground(position);
    }

    @ColorRes
    public int getBackgroundDark(int position) {
        return this.adapter.getBackgroundDark(position);
    }

    public List<Slide> getSlides() {
        return this.adapter.getSlides();
    }

    public int indexOfSlide(Object object) {
        return this.adapter.indexOfSlide(object);
    }

    public boolean isEmpty() {
        return this.adapter.isEmpty();
    }

    public int getCount() {
        return this.adapter == null ? 0 : this.adapter.getCount();
    }

    public int lastIndexOfSlide(Object object) {
        return this.adapter.lastIndexOfSlide(object);
    }

    public Slide removeSlide(int location) {
        Slide object = this.adapter.removeSlide(location);
        this.notifyDataSetChanged();
        return object;
    }

    public boolean removeSlide(Object object) {
        boolean modified = this.adapter.removeSlide(object);
        if (modified) {
            this.notifyDataSetChanged();
        }
        return modified;
    }

    public boolean removeSlides(@NonNull Collection<?> collection) {
        boolean modified = this.adapter.removeSlides(collection);
        if (modified) {
            this.notifyDataSetChanged();
        }
        return modified;
    }

    public boolean retainSlides(@NonNull Collection<?> collection) {
        boolean modified = this.adapter.retainSlides(collection);
        if (modified) {
            this.notifyDataSetChanged();
        }
        return modified;
    }

    public Slide setSlide(int location, Slide object) {
        Slide oldObject = this.adapter.setSlide(location, object);
        this.notifyDataSetChanged();
        return oldObject;
    }

    public List<Slide> setSlides(List<? extends Slide> list) {
        List<Slide> oldList = this.adapter.setSlides(list);
        this.notifyDataSetChanged();
        return oldList;
    }

    public void setPageTransformer(boolean reverseDrawingOrder, ViewPager.PageTransformer transformer) {
        this.binding.miPager.setPageTransformer(reverseDrawingOrder, transformer);
    }

    public void notifyDataSetChanged() {
        if (!this.activityCreated) {
            return;
        }
        int position = this.position;
        this.binding.miPager.setAdapter((PagerAdapter)this.adapter);
        this.binding.miPager.setCurrentItem(position);
        if (this.finishIfNeeded()) {
            return;
        }
        this.updateTaskDescription();
        this.updateButtonBackDrawable();
        this.updateButtonNextDrawable();
        this.updateScrollPositions();
        this.lockSwipeIfNeeded();
    }

    private class ButtonCtaClickListener
    implements View.OnClickListener {
        private ButtonCtaClickListener() {
        }

        public void onClick(View v) {
            IntroActivity.this.goToSlide(IntroActivity.this.getCount());
        }
    }

    private class IntroPageChangeListener
    extends FadeableViewPager.SimpleOnOverscrollPageChangeListener {
        private IntroPageChangeListener() {
        }

        @Override
        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            IntroActivity.this.position = (int)Math.floor((float)position + positionOffset);
            IntroActivity.this.positionOffset = (((float)position + positionOffset) % 1.0f + 1.0f) % 1.0f;
            if (IntroActivity.this.finishIfNeeded()) {
                return;
            }
            if (Math.abs(positionOffset) < 0.1f) {
                IntroActivity.this.lockSwipeIfNeeded();
            }
            IntroActivity.this.updateButtonNextDrawable();
            IntroActivity.this.updateScrollPositions();
        }

        @Override
        public void onPageSelected(int position) {
            IntroActivity.this.position = position;
            IntroActivity.this.updateTaskDescription();
            IntroActivity.this.lockSwipeIfNeeded();
        }
    }
}

