/*
 * Decompiled with CFR 0.152.
 */
package com.heinrichreimersoftware.materialintro.view;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;

public class SwipeBlockableViewPager
extends ViewPager {
    private static final int SWIPE_LOCK_THRESHOLD = 0;
    private static final int SWIPE_UNLOCK_THRESHOLD = 0;
    private static final String STATE_SUPER = "SUPER";
    private static final String STATE_SWIPE_RIGHT_ENABLED = "SWIPE_RIGHT_ENABLED";
    private static final String STATE_SWIPE_LEFT_ENABLED = "SWIPE_LEFT_ENABLED";
    private static final int INVALID_POINTER_ID = -1;
    private int activePointerId = -1;
    private float lastTouchX;
    private boolean swipeRightEnabled = true;
    private boolean swipeLeftEnabled = true;
    private boolean lockedLeft = false;
    private boolean lockedRight = false;

    public SwipeBlockableViewPager(Context context) {
        super(context);
    }

    public SwipeBlockableViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setSwipeRightEnabled(boolean swipeRightEnabled) {
        this.swipeRightEnabled = swipeRightEnabled;
    }

    public void setSwipeLeftEnabled(boolean swipeLeftEnabled) {
        this.swipeLeftEnabled = swipeLeftEnabled;
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.handleTouchEvent(event) && super.onTouchEvent(event);
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        return this.handleTouchEvent(event) && super.onInterceptTouchEvent(event);
    }

    private boolean handleTouchEvent(MotionEvent event) {
        boolean allowTouch = false;
        int action = event.getAction();
        switch (action & 0xFF) {
            case 0: {
                this.lastTouchX = event.getX();
                this.activePointerId = event.getPointerId(0);
                break;
            }
            case 2: {
                int pointerIndex = event.findPointerIndex(this.activePointerId);
                float x = event.getX(pointerIndex);
                float dx = x - this.lastTouchX;
                if (dx > 0.0f) {
                    if (!this.swipeRightEnabled && Math.abs(dx) > 0.0f) {
                        this.lockedRight = true;
                    }
                    if (!this.lockedRight) {
                        allowTouch = true;
                        if (Math.abs(dx) > 0.0f) {
                            this.lockedLeft = false;
                        }
                    }
                } else if (dx < 0.0f) {
                    if (!this.swipeLeftEnabled && Math.abs(dx) > 0.0f) {
                        this.lockedLeft = true;
                    }
                    if (!this.lockedLeft) {
                        allowTouch = true;
                        if (Math.abs(dx) > 0.0f) {
                            this.lockedRight = false;
                        }
                    }
                }
                this.lastTouchX = x;
                this.invalidate();
                break;
            }
            case 1: {
                this.activePointerId = -1;
                this.lockedLeft = false;
                this.lockedRight = false;
                break;
            }
            case 3: {
                this.activePointerId = -1;
                this.lockedLeft = false;
                this.lockedRight = false;
                break;
            }
            case 6: {
                int pointerIndex = (action & 0xFF00) >> 8;
                int pointerId = event.getPointerId(pointerIndex);
                if (pointerId != this.activePointerId) break;
                int newPointerIndex = pointerIndex == 0 ? 1 : 0;
                this.lastTouchX = event.getX(newPointerIndex);
                this.activePointerId = event.getPointerId(newPointerIndex);
                break;
            }
        }
        return !this.lockedLeft && !this.lockedRight || allowTouch;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.swipeRightEnabled = bundle.getBoolean(STATE_SWIPE_RIGHT_ENABLED, true);
            this.swipeLeftEnabled = bundle.getBoolean(STATE_SWIPE_LEFT_ENABLED, true);
            state = bundle.getParcelable(STATE_SUPER);
        }
        super.onRestoreInstanceState(state);
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle(4);
        bundle.putParcelable(STATE_SUPER, super.onSaveInstanceState());
        bundle.putBoolean(STATE_SWIPE_RIGHT_ENABLED, this.swipeRightEnabled);
        bundle.putBoolean(STATE_SWIPE_LEFT_ENABLED, this.swipeLeftEnabled);
        return bundle;
    }
}

