/*
 * Decompiled with CFR 0.152.
 */
package com.heinrichreimersoftware.materialintro.slide;

import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.view.ViewGroup;
import com.heinrichreimersoftware.materialintro.app.SlideFragment;
import com.heinrichreimersoftware.materialintro.slide.RestorableSlide;
import com.heinrichreimersoftware.materialintro.slide.Slide;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SlideAdapter
extends FragmentStatePagerAdapter {
    private List<Slide> data = new ArrayList<Slide>();

    public SlideAdapter(FragmentManager fragmentManager) {
        super(fragmentManager);
        this.data = new ArrayList<Slide>();
    }

    public SlideAdapter(FragmentManager fragmentManager, @NonNull Collection<? extends Slide> collection) {
        super(fragmentManager);
        this.data = new ArrayList<Slide>(collection);
    }

    public void addSlide(int location, Slide object) {
        this.data.add(location, object);
        this.notifyDataSetChanged();
    }

    public boolean addSlide(Slide object) {
        boolean modified = this.data.add(object);
        if (modified) {
            this.notifyDataSetChanged();
        }
        return modified;
    }

    public boolean addSlides(int location, @NonNull Collection<? extends Slide> collection) {
        boolean modified = this.data.addAll(location, collection);
        if (modified) {
            this.notifyDataSetChanged();
        }
        return modified;
    }

    public boolean addSlides(@NonNull Collection<? extends Slide> collection) {
        boolean modified = this.data.addAll(collection);
        if (modified) {
            this.notifyDataSetChanged();
        }
        return modified;
    }

    public void clearSlides() {
        if (!this.data.isEmpty()) {
            this.data.clear();
            this.notifyDataSetChanged();
        }
    }

    public boolean containsSlide(Object object) {
        return this.data.contains(object);
    }

    public boolean containsSlides(@NonNull Collection<?> collection) {
        return this.data.containsAll(collection);
    }

    public Slide getSlide(int location) {
        return this.data.get(location);
    }

    public Fragment getItem(int position) {
        return this.data.get(position).getFragment();
    }

    public Object instantiateItem(ViewGroup container, int position) {
        Fragment instantiatedFragment = (Fragment)super.instantiateItem(container, position);
        Slide slide = this.data.get(position);
        if (slide instanceof RestorableSlide) {
            ((RestorableSlide)slide).setFragment(instantiatedFragment);
            this.data.set(position, slide);
            if (instantiatedFragment instanceof SlideFragment) {
                ((SlideFragment)instantiatedFragment).updateNavigation();
            }
        }
        return instantiatedFragment;
    }

    @ColorRes
    public int getBackground(int position) {
        return this.data.get(position).getBackground();
    }

    @ColorRes
    public int getBackgroundDark(int position) {
        return this.data.get(position).getBackgroundDark();
    }

    public List<Slide> getSlides() {
        return this.data;
    }

    public int indexOfSlide(Object object) {
        return this.data.indexOf(object);
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public int getCount() {
        return this.data.size();
    }

    public int lastIndexOfSlide(Object object) {
        return this.data.lastIndexOf(object);
    }

    public Slide removeSlide(int location) {
        Slide object = this.data.remove(location);
        this.notifyDataSetChanged();
        return object;
    }

    public boolean removeSlide(Object object) {
        int locationToRemove = this.data.indexOf(object);
        if (locationToRemove >= 0) {
            this.data.remove(locationToRemove);
            this.notifyDataSetChanged();
            return true;
        }
        return false;
    }

    public boolean removeSlides(@NonNull Collection<?> collection) {
        boolean modified = false;
        for (Object object : collection) {
            int locationToRemove = this.data.indexOf(object);
            if (locationToRemove < 0) continue;
            this.data.remove(locationToRemove);
            modified = true;
        }
        if (modified) {
            this.notifyDataSetChanged();
        }
        return modified;
    }

    public boolean retainSlides(@NonNull Collection<?> collection) {
        boolean modified = false;
        for (int i = this.data.size() - 1; i >= 0; --i) {
            if (collection.contains(this.data.get(i))) continue;
            this.data.remove(i);
            modified = true;
            --i;
        }
        if (modified) {
            this.notifyDataSetChanged();
        }
        return modified;
    }

    public Slide setSlide(int location, Slide object) {
        Slide oldObject = this.data.set(location, object);
        this.notifyDataSetChanged();
        return oldObject;
    }

    public List<Slide> setSlides(List<? extends Slide> list) {
        ArrayList<Slide> oldList = new ArrayList<Slide>(this.data);
        this.data = new ArrayList<Slide>(list);
        this.notifyDataSetChanged();
        return oldList;
    }
}

