/*
 * Decompiled with CFR 0.152.
 */
package com.heinrichreimersoftware.materialintro.app;

import android.animation.ArgbEvaluator;
import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.ColorUtils;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.util.Pair;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AppCompatActivity;
import android.util.TypedValue;
import android.view.View;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import com.heinrichreimersoftware.materialintro.R;
import com.heinrichreimersoftware.materialintro.app.NavigationPolicy;
import com.heinrichreimersoftware.materialintro.app.OnNavigationBlockedListener;
import com.heinrichreimersoftware.materialintro.slide.ButtonCtaSlide;
import com.heinrichreimersoftware.materialintro.slide.Slide;
import com.heinrichreimersoftware.materialintro.slide.SlideAdapter;
import com.heinrichreimersoftware.materialintro.util.AnimUtils;
import com.heinrichreimersoftware.materialintro.util.CheatSheet;
import com.heinrichreimersoftware.materialintro.view.FadeableViewPager;
import com.heinrichreimersoftware.materialintro.view.InkPageIndicator;
import com.heinrichreimersoftware.materialintro.view.parallax.Parallaxable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@SuppressLint(value={"Registered"})
public class IntroActivity
extends AppCompatActivity {
    private static final String KEY_CURRENT_ITEM = "com.heinrichreimersoftware.materialintro.app.IntroActivity.KEY_CURRENT_ITEM";
    public static final int BUTTON_NEXT_FUNCTION_NEXT = 1;
    public static final int BUTTON_NEXT_FUNCTION_NEXT_FINISH = 2;
    public static final int BUTTON_BACK_FUNCTION_BACK = 1;
    public static final int BUTTON_BACK_FUNCTION_SKIP = 2;
    public static final int BUTTON_CTA_TINT_MODE_BACKGROUND = 1;
    public static final int BUTTON_CTA_TINT_MODE_TEXT = 2;
    private final ArgbEvaluator evaluator = new ArgbEvaluator();
    private LinearLayout frame;
    private FadeableViewPager pager;
    private Button buttonCta;
    private InkPageIndicator pagerIndicator;
    private ImageButton buttonNext;
    private ImageButton buttonBack;
    private SlideAdapter adapter;
    private IntroPageChangeListener listener = new IntroPageChangeListener();
    private boolean fullscreen = false;
    private boolean buttonCtaVisible = false;
    private int buttonNextFunction = 2;
    private int buttonBackFunction = 2;
    private int buttonCtaTintMode = 1;
    private int position = 0;
    private float positionOffset = 0.0f;
    private NavigationPolicy navigationPolicy = null;
    private List<OnNavigationBlockedListener> navigationBlockedListeners = new ArrayList<OnNavigationBlockedListener>();

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.fullscreen && Build.VERSION.SDK_INT >= 19) {
            this.setSystemUiFlags(1280, true);
            this.setFullscreenFlags(this.fullscreen);
        }
        if (savedInstanceState != null && savedInstanceState.containsKey(KEY_CURRENT_ITEM)) {
            this.position = savedInstanceState.getInt(KEY_CURRENT_ITEM, this.position);
        }
        this.setContentView(R.layout.activity_intro);
        this.findViews();
    }

    protected void onPostCreate(Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        this.updateTaskDescription();
        this.updateBackground();
        this.updateTaskDescription();
        this.updateButtonNextDrawable();
        this.updateButtonBackDrawable();
        this.frame.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                IntroActivity.this.updateViewPositions();
                v.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
            }
        });
    }

    protected void onResume() {
        super.onResume();
        this.setFullscreenFlags(this.fullscreen);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(KEY_CURRENT_ITEM, this.pager.getCurrentItem());
    }

    public void onBackPressed() {
        if (this.position > 0) {
            this.previousSlide();
            return;
        }
        this.setResult(0);
        super.onBackPressed();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        for (Fragment fragment : fragmentManager.getFragments()) {
            if (fragment == null) continue;
            fragment.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    private void setSystemUiFlags(int flags, boolean value) {
        int systemUiVisibility = this.getWindow().getDecorView().getSystemUiVisibility();
        systemUiVisibility = value ? (systemUiVisibility |= flags) : (systemUiVisibility &= ~flags);
        this.getWindow().getDecorView().setSystemUiVisibility(systemUiVisibility);
    }

    private void setFullscreenFlags(boolean fullscreen) {
        if (Build.VERSION.SDK_INT >= 19) {
            int fullscreenFlags = 4100;
            this.setSystemUiFlags(fullscreenFlags, fullscreen);
        }
    }

    private void findViews() {
        this.frame = (LinearLayout)this.findViewById(R.id.mi_frame);
        this.pager = (FadeableViewPager)this.findViewById(R.id.mi_pager);
        this.buttonCta = (Button)this.findViewById(R.id.mi_button_cta);
        this.pagerIndicator = (InkPageIndicator)this.findViewById(R.id.mi_pager_indicator);
        this.buttonNext = (ImageButton)this.findViewById(R.id.mi_button_next);
        this.buttonBack = (ImageButton)this.findViewById(R.id.mi_button_skip);
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        this.adapter = new SlideAdapter(fragmentManager);
        this.pager.setAdapter((PagerAdapter)this.adapter);
        this.pager.addOnPageChangeListener(this.listener);
        this.pager.setCurrentItem(this.position);
        this.pagerIndicator.setViewPager(this.pager);
        this.buttonNext.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                IntroActivity.this.nextSlide();
            }
        });
        this.buttonBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                IntroActivity.this.performButtonBackPress();
            }
        });
        CheatSheet.setup((View)this.buttonNext);
        CheatSheet.setup((View)this.buttonBack);
    }

    public void nextSlide() {
        int currentItem = this.pager.getCurrentItem();
        if (currentItem >= this.adapter.getCount() - 1) {
            return;
        }
        if (this.canGoForward(currentItem, true)) {
            this.pager.setCurrentItem(++currentItem, true);
        } else {
            AnimUtils.applyShakeAnimation((Context)this, (View)this.buttonNext);
        }
    }

    public void previousSlide() {
        int currentItem = this.pager.getCurrentItem();
        if (currentItem <= 0) {
            return;
        }
        if (this.canGoBackward(currentItem, true)) {
            this.pager.setCurrentItem(--currentItem, true);
        } else {
            AnimUtils.applyShakeAnimation((Context)this, (View)this.buttonBack);
        }
    }

    private void performButtonBackPress() {
        if (this.buttonBackFunction == 2) {
            int endPosition;
            int count = this.getCount();
            for (endPosition = this.pager.getCurrentItem(); endPosition < count && this.canGoForward(endPosition, true); ++endPosition) {
            }
            this.pager.setCurrentItem(endPosition);
        } else if (this.buttonBackFunction == 1) {
            this.previousSlide();
        }
    }

    private boolean canGoForward(int position, boolean notifyListeners) {
        boolean canGoForward;
        if (this.buttonNextFunction == 1 && position >= this.getCount() - 1) {
            return false;
        }
        boolean bl = canGoForward = (this.navigationPolicy == null || this.navigationPolicy.canGoForward(position)) && this.getSlide(position).canGoForward();
        if (!canGoForward && notifyListeners) {
            for (OnNavigationBlockedListener listener : this.navigationBlockedListeners) {
                listener.onNavigationBlocked(position, 1);
            }
        }
        return canGoForward;
    }

    private boolean canGoBackward(int position, boolean notifyListeners) {
        boolean canGoBackward;
        boolean bl = canGoBackward = (this.navigationPolicy == null || this.navigationPolicy.canGoBackward(position)) && this.getSlide(position).canGoBackward();
        if (!canGoBackward && notifyListeners) {
            for (OnNavigationBlockedListener listener : this.navigationBlockedListeners) {
                listener.onNavigationBlocked(position, -1);
            }
        }
        return canGoBackward;
    }

    private void finishIfNeeded() {
        if (this.positionOffset == 0.0f && this.position == this.adapter.getCount()) {
            this.setResult(-1);
            this.finish();
            this.overridePendingTransition(0, 0);
        }
    }

    private Pair<String, ? extends View.OnClickListener> getButtonCta(int position) {
        ButtonCtaSlide slide;
        if (this.getSlide(position) instanceof ButtonCtaSlide && (slide = (ButtonCtaSlide)this.getSlide(position)).getButtonCtaClickListener() != null && (slide.getButtonCtaLabel() != null || slide.getButtonCtaLabelRes() != 0)) {
            if (slide.getButtonCtaLabel() != null) {
                return Pair.create((Object)slide.getButtonCtaLabel(), (Object)slide.getButtonCtaClickListener());
            }
            return Pair.create((Object)this.getString(slide.getButtonCtaLabelRes()), (Object)slide.getButtonCtaClickListener());
        }
        if (this.buttonCtaVisible) {
            return Pair.create((Object)this.getString(R.string.mi_label_button_cta), (Object)new ButtonCtaClickListener());
        }
        return null;
    }

    private void updateFullscreen() {
        if ((float)this.position + this.positionOffset > (float)(this.adapter.getCount() - 1)) {
            this.setFullscreenFlags(false);
        } else {
            this.setFullscreenFlags(this.fullscreen);
        }
    }

    private void updateTaskDescription() {
        if (Build.VERSION.SDK_INT >= 21) {
            int colorPrimary;
            Bitmap icon;
            String title = this.getTitle().toString();
            Drawable iconDrawable = this.getApplicationInfo().loadIcon(this.getPackageManager());
            Bitmap bitmap = icon = iconDrawable instanceof BitmapDrawable ? ((BitmapDrawable)iconDrawable).getBitmap() : null;
            if (this.position < this.getCount()) {
                try {
                    colorPrimary = ContextCompat.getColor((Context)this, (int)this.getBackgroundDark(this.position));
                }
                catch (Resources.NotFoundException e) {
                    colorPrimary = ContextCompat.getColor((Context)this, (int)this.getBackground(this.position));
                }
            } else {
                TypedValue typedValue = new TypedValue();
                TypedArray a = this.obtainStyledAttributes(typedValue.data, new int[]{R.attr.colorPrimary});
                colorPrimary = a.getColor(0, 0);
                a.recycle();
            }
            colorPrimary = ColorUtils.setAlphaComponent((int)colorPrimary, (int)255);
            this.setTaskDescription(new ActivityManager.TaskDescription(title, icon, colorPrimary));
        }
    }

    private void updateBackground() {
        int backgroundDarkNext;
        int backgroundDark;
        int backgroundNext;
        int background;
        if (this.position == this.getCount()) {
            background = 0;
            backgroundNext = 0;
            backgroundDark = 0;
            backgroundDarkNext = 0;
        } else {
            background = ContextCompat.getColor((Context)this, (int)this.getBackground(this.position));
            backgroundNext = ContextCompat.getColor((Context)this, (int)this.getBackground(Math.min(this.position + 1, this.getCount() - 1)));
            background = ColorUtils.setAlphaComponent((int)background, (int)255);
            backgroundNext = ColorUtils.setAlphaComponent((int)backgroundNext, (int)255);
            try {
                backgroundDark = ContextCompat.getColor((Context)this, (int)this.getBackgroundDark(this.position));
            }
            catch (Resources.NotFoundException e) {
                backgroundDark = ContextCompat.getColor((Context)this, (int)R.color.mi_status_bar_background);
            }
            try {
                backgroundDarkNext = ContextCompat.getColor((Context)this, (int)this.getBackgroundDark(Math.min(this.position + 1, this.getCount() - 1)));
            }
            catch (Resources.NotFoundException e) {
                backgroundDarkNext = ContextCompat.getColor((Context)this, (int)R.color.mi_status_bar_background);
            }
        }
        if ((float)this.position + this.positionOffset >= (float)(this.adapter.getCount() - 1)) {
            backgroundNext = ColorUtils.setAlphaComponent((int)background, (int)0);
            backgroundDarkNext = ColorUtils.setAlphaComponent((int)backgroundDark, (int)0);
        }
        background = (Integer)this.evaluator.evaluate(this.positionOffset, (Object)background, (Object)backgroundNext);
        backgroundDark = (Integer)this.evaluator.evaluate(this.positionOffset, (Object)backgroundDark, (Object)backgroundDarkNext);
        this.frame.setBackgroundColor(background);
        float[] backgroundDarkHsv = new float[3];
        Color.colorToHSV((int)backgroundDark, (float[])backgroundDarkHsv);
        backgroundDarkHsv[2] = (float)((double)backgroundDarkHsv[2] * 0.95);
        int backgroundDarker = Color.HSVToColor((float[])backgroundDarkHsv);
        this.pagerIndicator.setPageIndicatorColor(backgroundDarker);
        ViewCompat.setBackgroundTintList((View)this.buttonNext, (ColorStateList)ColorStateList.valueOf((int)backgroundDarker));
        ViewCompat.setBackgroundTintList((View)this.buttonBack, (ColorStateList)ColorStateList.valueOf((int)backgroundDarker));
        int backgroundButtonCta = this.buttonCtaTintMode == 2 ? ContextCompat.getColor((Context)this, (int)17170443) : backgroundDarker;
        ViewCompat.setBackgroundTintList((View)this.buttonCta, (ColorStateList)ColorStateList.valueOf((int)backgroundButtonCta));
        int iconColor = ColorUtils.calculateLuminance((int)backgroundDark) > 0.4 ? ContextCompat.getColor((Context)this, (int)R.color.mi_icon_color_light) : ContextCompat.getColor((Context)this, (int)R.color.mi_icon_color_dark);
        this.pagerIndicator.setCurrentPageIndicatorColor(iconColor);
        DrawableCompat.setTint((Drawable)this.buttonNext.getDrawable(), (int)iconColor);
        DrawableCompat.setTint((Drawable)this.buttonBack.getDrawable(), (int)iconColor);
        int textColorButtonCta = this.buttonCtaTintMode == 2 ? backgroundDarker : iconColor;
        this.buttonCta.setTextColor(textColorButtonCta);
        if (Build.VERSION.SDK_INT >= 21) {
            this.getWindow().setStatusBarColor(backgroundDark);
            if (this.position == this.adapter.getCount()) {
                this.getWindow().setNavigationBarColor(0);
            } else if ((float)this.position + this.positionOffset >= (float)(this.adapter.getCount() - 1)) {
                TypedValue typedValue = new TypedValue();
                TypedArray a = this.obtainStyledAttributes(typedValue.data, new int[]{16843858});
                int defaultNavigationBarColor = a.getColor(0, -16777216);
                a.recycle();
                int navigationBarColor = (Integer)this.evaluator.evaluate(this.positionOffset, (Object)defaultNavigationBarColor, (Object)0);
                this.getWindow().setNavigationBarColor(navigationBarColor);
            }
            if (Build.VERSION.SDK_INT >= 23) {
                int systemUiVisibility = this.getWindow().getDecorView().getSystemUiVisibility();
                int flagLightStatusBar = 8192;
                systemUiVisibility = ColorUtils.calculateLuminance((int)backgroundDark) > 0.4 ? (systemUiVisibility |= flagLightStatusBar) : (systemUiVisibility &= ~flagLightStatusBar);
                this.getWindow().getDecorView().setSystemUiVisibility(systemUiVisibility);
            }
        }
    }

    private void updateViewPositions() {
        float offset;
        if ((float)this.position + this.positionOffset < 1.0f) {
            offset = (float)this.position + this.positionOffset;
            if (this.buttonBackFunction == 2) {
                this.buttonBack.setTranslationY(0.0f);
            } else {
                this.buttonBack.setTranslationY((1.0f - offset) * 2.0f * (float)this.buttonNext.getHeight());
            }
            this.updateButtonNextDrawable();
        } else if ((float)this.position + this.positionOffset >= 1.0f && (float)this.position + this.positionOffset < (float)(this.adapter.getCount() - 2)) {
            this.buttonBack.setTranslationY(0.0f);
            this.buttonBack.setTranslationX(0.0f);
            this.buttonNext.setTranslationY(0.0f);
            this.updateButtonNextDrawable();
        } else if ((float)this.position + this.positionOffset >= (float)(this.adapter.getCount() - 2) && (float)this.position + this.positionOffset < (float)(this.adapter.getCount() - 1)) {
            offset = (float)this.position + this.positionOffset - (float)this.adapter.getCount() + 2.0f;
            if (this.buttonBackFunction == 2) {
                boolean rtl = Build.VERSION.SDK_INT >= 17 && this.getResources().getConfiguration().getLayoutDirection() == 1;
                this.buttonBack.setTranslationX(offset * (float)(rtl ? 1 : -1) * (float)this.pager.getWidth());
            } else {
                this.buttonBack.setTranslationX(0.0f);
            }
            if (this.buttonNextFunction == 2) {
                this.buttonNext.setTranslationY(0.0f);
            } else {
                this.buttonNext.setTranslationY(offset * 2.0f * (float)this.buttonNext.getHeight());
            }
            this.updateButtonNextDrawable();
        } else if ((float)this.position + this.positionOffset >= (float)(this.adapter.getCount() - 1)) {
            offset = (float)this.position + this.positionOffset - (float)this.adapter.getCount() + 1.0f;
            float yOffset = this.getResources().getDimensionPixelSize(R.dimen.mi_y_offset);
            if (this.buttonBackFunction == 2) {
                boolean rtl = Build.VERSION.SDK_INT >= 17 && this.getResources().getConfiguration().getLayoutDirection() == 1;
                this.buttonBack.setTranslationX((float)((rtl ? 1 : -1) * this.pager.getWidth()));
            } else {
                this.buttonBack.setTranslationY(offset * yOffset);
            }
            if (this.buttonNextFunction == 2) {
                this.buttonNext.setTranslationY(offset * yOffset);
            } else {
                this.buttonNext.setTranslationY(-yOffset);
            }
            this.buttonCta.setTranslationY(offset * yOffset);
            this.pagerIndicator.setTranslationY(offset * yOffset);
            this.updateButtonNextDrawable();
        }
        if ((float)this.position + this.positionOffset < (float)(this.adapter.getCount() - 1)) {
            offset = (float)this.position + this.positionOffset - (float)this.adapter.getCount() + 2.0f;
            Pair<String, ? extends View.OnClickListener> button = this.getButtonCta(this.position);
            Pair<String, ? extends View.OnClickListener> buttonNext = this.getButtonCta(this.position + 1);
            if (button == null) {
                if (buttonNext == null) {
                    this.buttonCta.setVisibility(4);
                } else {
                    this.buttonCta.setVisibility(0);
                    if (!this.buttonCta.getText().equals(buttonNext.first)) {
                        this.buttonCta.setText((CharSequence)buttonNext.first);
                    }
                    this.buttonCta.setOnClickListener((View.OnClickListener)buttonNext.second);
                    this.buttonCta.setAlpha(offset);
                }
            } else if (buttonNext == null) {
                this.buttonCta.setVisibility(0);
                if (!this.buttonCta.getText().equals(button.first)) {
                    this.buttonCta.setText((CharSequence)button.first);
                }
                this.buttonCta.setOnClickListener((View.OnClickListener)button.second);
                this.buttonCta.setAlpha(1.0f - offset);
            } else {
                this.buttonCta.setVisibility(0);
                if (offset >= 0.5f) {
                    if (!this.buttonCta.getText().equals(buttonNext.first)) {
                        this.buttonCta.setText((CharSequence)buttonNext.first);
                    }
                    this.buttonCta.setOnClickListener((View.OnClickListener)buttonNext.second);
                } else {
                    if (!this.buttonCta.getText().equals(button.first)) {
                        this.buttonCta.setText((CharSequence)button.first);
                    }
                    this.buttonCta.setOnClickListener((View.OnClickListener)button.second);
                }
            }
        }
    }

    private void updateParallax() {
        Fragment fragmentNext;
        Fragment fragment = this.getSlide(this.position).getFragment();
        Fragment fragment2 = fragmentNext = this.position < this.getCount() - 1 ? this.getSlide(this.position + 1).getFragment() : null;
        if (fragment instanceof Parallaxable) {
            ((Parallaxable)fragment).setOffset(this.positionOffset);
        }
        if (fragmentNext instanceof Parallaxable) {
            ((Parallaxable)fragmentNext).setOffset(-1.0f + this.positionOffset);
        }
    }

    private void updateButtonNextDrawable() {
        float offset = 0.0f;
        if (this.buttonNextFunction == 2 && (float)this.position + this.positionOffset >= (float)(this.adapter.getCount() - 2)) {
            offset = Math.min((float)this.position + this.positionOffset - (float)this.adapter.getCount() + 2.0f, 1.0f);
        }
        if (offset <= 0.0f) {
            this.buttonNext.setImageResource(R.drawable.ic_next);
            this.buttonNext.getDrawable().setAlpha(255);
        } else {
            this.buttonNext.setImageResource(R.drawable.ic_next_finish);
            if (this.buttonNext.getDrawable() != null && this.buttonNext.getDrawable() instanceof LayerDrawable) {
                LayerDrawable drawable2 = (LayerDrawable)this.buttonNext.getDrawable();
                drawable2.getDrawable(0).setAlpha((int)(255.0f * (1.0f - offset)));
                drawable2.getDrawable(1).setAlpha((int)(255.0f * offset));
            } else {
                this.buttonNext.setImageResource(offset > 0.0f ? R.drawable.ic_finish : R.drawable.ic_next);
            }
        }
    }

    private void updateButtonBackDrawable() {
        if (this.buttonBackFunction == 2) {
            this.buttonBack.setImageResource(R.drawable.ic_skip);
        } else {
            this.buttonBack.setImageResource(R.drawable.ic_previous);
        }
    }

    public boolean isFullscreen() {
        return this.fullscreen;
    }

    public void setFullscreen(boolean fullscreen) {
        this.fullscreen = fullscreen;
    }

    public boolean isButtonCtaVisible() {
        return this.buttonCtaVisible;
    }

    public void setButtonCtaVisible(boolean buttonCtaVisible) {
        this.buttonCtaVisible = buttonCtaVisible;
        this.updateViewPositions();
    }

    public int getButtonCtaTintMode() {
        return this.buttonCtaTintMode;
    }

    public void setButtonCtaTintMode(int buttonCtaTintMode) {
        this.buttonCtaTintMode = buttonCtaTintMode;
    }

    public int getButtonBackFunction() {
        return this.buttonBackFunction;
    }

    public void setButtonBackFunction(int buttonBackFunction) {
        this.buttonBackFunction = buttonBackFunction;
        switch (buttonBackFunction) {
            case 1: {
                CheatSheet.setup((View)this.buttonBack, R.string.mi_content_description_back);
                break;
            }
            case 2: {
                CheatSheet.setup((View)this.buttonBack, R.string.mi_content_description_skip);
            }
        }
        this.updateButtonBackDrawable();
        this.updateViewPositions();
    }

    @Deprecated
    public boolean isSkipEnabled() {
        return this.buttonBackFunction == 2;
    }

    @Deprecated
    public void setSkipEnabled(boolean skipEnabled) {
        this.setButtonBackFunction(skipEnabled ? 2 : 1);
    }

    public int getButtonNextFunction() {
        return this.buttonNextFunction;
    }

    public void setButtonNextFunction(int buttonNextFunction) {
        this.buttonNextFunction = buttonNextFunction;
        switch (buttonNextFunction) {
            case 2: {
                CheatSheet.setup((View)this.buttonNext, R.string.mi_content_description_next_finish);
                break;
            }
            case 1: {
                CheatSheet.setup((View)this.buttonNext, R.string.mi_content_description_next);
            }
        }
        this.updateButtonNextDrawable();
        this.updateViewPositions();
    }

    @Deprecated
    public boolean isFinishEnabled() {
        return this.buttonNextFunction == 2;
    }

    @Deprecated
    public void setFinishEnabled(boolean finishEnabled) {
        this.setButtonNextFunction(finishEnabled ? 2 : 1);
    }

    public boolean isButtonBackVisible() {
        return this.buttonBack.getVisibility() == 0;
    }

    public void setButtonBackVisible(boolean visible) {
        this.buttonBack.setVisibility(visible ? 0 : 8);
    }

    public boolean isButtonNextVisible() {
        return this.buttonNext.getVisibility() == 0;
    }

    public void setButtonNextVisible(boolean visible) {
        this.buttonNext.setVisibility(visible ? 0 : 8);
    }

    @Deprecated
    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.pager.setOnPageChangeListener(listener);
        this.pager.addOnPageChangeListener(this.listener);
    }

    public void addOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.pager.addOnPageChangeListener(listener);
    }

    public void removeOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        if (listener != this.listener) {
            this.pager.removeOnPageChangeListener(listener);
        }
    }

    protected void addSlide(int location, Slide object) {
        this.adapter.addSlide(location, object);
    }

    protected boolean addSlide(Slide object) {
        return this.adapter.addSlide(object);
    }

    protected boolean addSlides(int location, @NonNull Collection<? extends Slide> collection) {
        return this.adapter.addSlides(location, collection);
    }

    protected boolean addSlides(@NonNull Collection<? extends Slide> collection) {
        return this.adapter.addSlides(collection);
    }

    protected void clearSlides() {
        this.adapter.clearSlides();
    }

    protected boolean containsSlide(Object object) {
        return this.adapter.containsSlide(object);
    }

    protected boolean containsSlides(@NonNull Collection<?> collection) {
        return this.adapter.containsSlides(collection);
    }

    protected Slide getSlide(int location) {
        return this.adapter.getSlide(location);
    }

    protected Fragment getItem(int position) {
        return this.adapter.getItem(position);
    }

    @ColorRes
    protected int getBackground(int position) {
        return this.adapter.getBackground(position);
    }

    @ColorRes
    protected int getBackgroundDark(int position) {
        return this.adapter.getBackgroundDark(position);
    }

    protected List<Slide> getSlides() {
        return this.adapter.getSlides();
    }

    protected int indexOfSlide(Object object) {
        return this.adapter.indexOfSlide(object);
    }

    protected boolean isEmpty() {
        return this.adapter.isEmpty();
    }

    protected int getCount() {
        return this.adapter == null ? 0 : this.adapter.getCount();
    }

    protected int lastIndexOfSlide(Object object) {
        return this.adapter.lastIndexOfSlide(object);
    }

    protected Slide removeSlide(int location) {
        return this.adapter.removeSlide(location);
    }

    protected boolean removeSlide(Object object) {
        return this.adapter.removeSlide(object);
    }

    protected boolean removeSlides(@NonNull Collection<?> collection) {
        return this.adapter.removeSlides(collection);
    }

    protected boolean retainSlides(@NonNull Collection<?> collection) {
        return this.adapter.retainSlides(collection);
    }

    protected Slide setSlide(int location, Slide object) {
        return this.adapter.setSlide(location, object);
    }

    protected List<Slide> setSlides(List<? extends Slide> list) {
        return this.adapter.setSlides(list);
    }

    public void setNavigationPolicy(NavigationPolicy navigationPolicy) {
        this.navigationPolicy = navigationPolicy;
    }

    public void addOnNavigationBlockedListener(OnNavigationBlockedListener listener) {
        this.navigationBlockedListeners.add(listener);
    }

    public void removeOnNavigationBlockedListener(OnNavigationBlockedListener listener) {
        this.navigationBlockedListeners.remove(listener);
    }

    public void clearOnNavigationBlockedListeners() {
        this.navigationBlockedListeners.clear();
    }

    public void lockSwipeIfNeeded() {
        if (this.position < this.getCount()) {
            this.pager.setSwipeLeftEnabled(this.canGoForward(this.position, false));
            this.pager.setSwipeRightEnabled(this.canGoBackward(this.position, false));
        }
    }

    private class ButtonCtaClickListener
    implements View.OnClickListener {
        private ButtonCtaClickListener() {
        }

        public void onClick(View v) {
            int endPosition;
            int count = IntroActivity.this.getCount();
            for (endPosition = IntroActivity.this.pager.getCurrentItem(); endPosition < count && IntroActivity.this.canGoForward(endPosition, true); ++endPosition) {
            }
            IntroActivity.this.pager.setCurrentItem(endPosition);
        }
    }

    private class IntroPageChangeListener
    extends FadeableViewPager.SimpleOnOverscrollPageChangeListener {
        private IntroPageChangeListener() {
        }

        @Override
        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            IntroActivity.this.position = position;
            IntroActivity.this.positionOffset = positionOffset;
            if (Math.abs(positionOffset) < 0.1f) {
                IntroActivity.this.lockSwipeIfNeeded();
            }
            IntroActivity.this.updateBackground();
            IntroActivity.this.updateViewPositions();
            IntroActivity.this.updateParallax();
            IntroActivity.this.updateFullscreen();
            IntroActivity.this.finishIfNeeded();
        }

        @Override
        public void onPageSelected(int position) {
            IntroActivity.this.position = position;
            IntroActivity.this.updateTaskDescription();
            IntroActivity.this.lockSwipeIfNeeded();
        }
    }
}

