/*
 * Decompiled with CFR 0.152.
 */
package com.heinrichreimersoftware.materialintro.slide;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.ColorRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.StyleRes;
import android.support.v4.app.Fragment;
import android.support.v7.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.heinrichreimersoftware.materialintro.app.SlideFragment;
import com.heinrichreimersoftware.materialintro.slide.RestorableSlide;

public class FragmentSlide
extends RestorableSlide {
    private Fragment fragment;
    @ColorRes
    private final int background;
    @ColorRes
    private final int backgroundDark;
    private final boolean canGoForward;
    private final boolean canGoBackward;

    private FragmentSlide(Builder builder) {
        this.fragment = builder.fragment;
        this.background = builder.background;
        this.backgroundDark = builder.backgroundDark;
        this.canGoForward = builder.canGoForward;
        this.canGoBackward = builder.canGoBackward;
    }

    @Override
    public Fragment getFragment() {
        return this.fragment;
    }

    @Override
    public void setFragment(Fragment fragment) {
        this.fragment = fragment;
    }

    @Override
    public int getBackground() {
        return this.background;
    }

    @Override
    public int getBackgroundDark() {
        return this.backgroundDark;
    }

    @Override
    public boolean canGoForward() {
        if (this.getFragment() instanceof SlideFragment) {
            return ((SlideFragment)this.getFragment()).canGoForward();
        }
        return this.canGoForward;
    }

    @Override
    public boolean canGoBackward() {
        if (this.getFragment() instanceof SlideFragment) {
            return ((SlideFragment)this.getFragment()).canGoBackward();
        }
        return this.canGoBackward;
    }

    public static class FragmentSlideFragment
    extends Fragment {
        private static final String ARGUMENT_LAYOUT_RES = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_LAYOUT_RES";
        private static final String ARGUMENT_THEME_RES = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_THEME_RES";

        public static FragmentSlideFragment newInstance(@LayoutRes int layoutRes, @StyleRes int themeRes) {
            FragmentSlideFragment fragment = new FragmentSlideFragment();
            Bundle arguments = new Bundle();
            arguments.putInt(ARGUMENT_LAYOUT_RES, layoutRes);
            arguments.putInt(ARGUMENT_THEME_RES, themeRes);
            fragment.setArguments(arguments);
            return fragment;
        }

        public static FragmentSlideFragment newInstance(@LayoutRes int layoutRes) {
            return FragmentSlideFragment.newInstance(layoutRes, 0);
        }

        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            int themeRes = this.getArguments().getInt(ARGUMENT_THEME_RES);
            Object contextThemeWrapper = themeRes != 0 ? new ContextThemeWrapper((Context)this.getActivity(), themeRes) : this.getActivity();
            LayoutInflater localInflater = inflater.cloneInContext((Context)contextThemeWrapper);
            return localInflater.inflate(this.getArguments().getInt(ARGUMENT_LAYOUT_RES), container, false);
        }
    }

    public static class Builder {
        private Fragment fragment;
        @ColorRes
        private int background;
        @ColorRes
        private int backgroundDark = 0;
        private boolean canGoForward = true;
        private boolean canGoBackward = true;

        public Builder fragment(Fragment fragment) {
            this.fragment = fragment;
            return this;
        }

        public Builder fragment(@LayoutRes int layoutRes, @StyleRes int themeRes) {
            this.fragment = FragmentSlideFragment.newInstance(layoutRes, themeRes);
            return this;
        }

        public Builder fragment(@LayoutRes int layoutRes) {
            this.fragment = FragmentSlideFragment.newInstance(layoutRes);
            return this;
        }

        public Builder background(@ColorRes int background) {
            this.background = background;
            return this;
        }

        public Builder backgroundDark(@ColorRes int backgroundDark) {
            this.backgroundDark = backgroundDark;
            return this;
        }

        public Builder canGoForward(boolean canGoForward) {
            this.canGoForward = canGoForward;
            return this;
        }

        public Builder canGoBackward(boolean canGoBackward) {
            this.canGoBackward = canGoBackward;
            return this;
        }

        public FragmentSlide build() {
            if (this.background == 0 || this.fragment == null) {
                throw new IllegalArgumentException("You must set at least a fragment and background.");
            }
            return new FragmentSlide(this);
        }
    }
}

