/*
 * Decompiled with CFR 0.152.
 */
package com.heinrichreimersoftware.materialintro.view;

import android.content.Context;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;

public class SwipeBlockableViewPager
extends ViewPager {
    private static final int SWIPE_DIRECTION_LEFT = 1;
    private static final int SWIPE_DIRECTION_NONE = 0;
    private static final int SWIPE_DIRECTION_RIGHT = -1;
    private static final int SWIPE_THRESHOLD = 10;
    private float initialX;
    private boolean swipeRightEnabled = false;
    private boolean swipeLeftEnabled = false;

    public SwipeBlockableViewPager(Context context) {
        super(context);
    }

    public SwipeBlockableViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public boolean isSwipeRightEnabled() {
        return this.swipeRightEnabled;
    }

    public void setSwipeRightEnabled(boolean swipeRightEnabled) {
        this.swipeRightEnabled = swipeRightEnabled;
    }

    public boolean isSwipeLeftEnabled() {
        return this.swipeLeftEnabled;
    }

    public void setSwipeLeftEnabled(boolean swipeLeftEnabled) {
        this.swipeLeftEnabled = swipeLeftEnabled;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.getSwipeDirection(event) == -1 && !this.swipeRightEnabled) {
            return false;
        }
        if (this.getSwipeDirection(event) == 1 && !this.swipeLeftEnabled) {
            return false;
        }
        return super.onTouchEvent(event);
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (this.getSwipeDirection(event) == -1 && !this.swipeRightEnabled) {
            return false;
        }
        if (this.getSwipeDirection(event) == 1 && !this.swipeLeftEnabled) {
            return false;
        }
        return super.onInterceptTouchEvent(event);
    }

    public int getSwipeDirection(MotionEvent event) {
        if (event.getAction() == 0) {
            this.initialX = event.getX();
            return 0;
        }
        if (event.getAction() == 2 || event.getAction() == 1) {
            float distanceX = event.getX() - this.initialX;
            if (10.0f > Math.abs(distanceX)) {
                return 0;
            }
            if (distanceX > 0.0f) {
                return -1;
            }
            return 1;
        }
        return 0;
    }
}

