/*
 * Decompiled with CFR 0.152.
 */
package com.heinrichreimersoftware.materialintro.slide;

import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.os.Bundle;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.ColorUtils;
import android.support.v4.view.ViewCompat;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import com.heinrichreimersoftware.materialintro.R;
import com.heinrichreimersoftware.materialintro.app.SlideFragment;
import com.heinrichreimersoftware.materialintro.slide.Slide;
import java.util.ArrayList;

public class SimpleSlide
extends Slide {
    private static final int PERMISSIONS_REQUEST_CODE = 34;
    private final Fragment fragment;
    @ColorRes
    private final int background;
    @ColorRes
    private final int backgroundDark;
    private final boolean canGoForward;
    private final boolean canGoBackward;

    private SimpleSlide(Builder builder) {
        this.fragment = Fragment.newInstance(builder.title, builder.description, builder.image, builder.background, builder.backgroundDark, builder.layout, builder.permissions);
        this.background = builder.background;
        this.backgroundDark = builder.backgroundDark;
        this.canGoForward = builder.canGoForward;
        this.canGoBackward = builder.canGoBackward;
    }

    @Override
    public Fragment getFragment() {
        return this.fragment;
    }

    @Override
    public int getBackground() {
        return this.background;
    }

    @Override
    public int getBackgroundDark() {
        return this.backgroundDark;
    }

    @Override
    public boolean canGoForward() {
        if (this.fragment != null) {
            return this.canGoForward && this.fragment.canGoForward();
        }
        return this.canGoForward;
    }

    @Override
    public boolean canGoBackward() {
        return this.canGoBackward;
    }

    public static class Fragment
    extends SlideFragment {
        private static final String ARGUMENT_TITLE_RES = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_TITLE_RES";
        private static final String ARGUMENT_DESCRIPTION_RES = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_DESCRIPTION_RES";
        private static final String ARGUMENT_IMAGE_RES = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_IMAGE_RES";
        private static final String ARGUMENT_BACKGROUND_RES = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_BACKGROUND_RES";
        private static final String ARGUMENT_BACKGROUND_DARK_RES = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_BACKGROUND_DARK_RES";
        private static final String ARGUMENT_LAYOUT_RES = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_LAYOUT_RES";
        private static final String ARGUMENT_PERMISSIONS = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_PERMISSIONS";
        private Button buttonGrantPermissions;
        private boolean permissionsGranted = false;

        public static Fragment newInstance(@StringRes int title, @StringRes int description, @DrawableRes int image, @ColorRes int background, @ColorRes int backgroundDark, @LayoutRes int layout2, String[] permissions) {
            Fragment fragment = new Fragment();
            Bundle arguments = new Bundle();
            arguments.putInt(ARGUMENT_TITLE_RES, title);
            arguments.putInt(ARGUMENT_DESCRIPTION_RES, description);
            arguments.putInt(ARGUMENT_IMAGE_RES, image);
            arguments.putInt(ARGUMENT_BACKGROUND_RES, background);
            arguments.putInt(ARGUMENT_BACKGROUND_DARK_RES, backgroundDark);
            arguments.putInt(ARGUMENT_LAYOUT_RES, layout2);
            arguments.putStringArray(ARGUMENT_PERMISSIONS, permissions);
            fragment.setArguments(arguments);
            return fragment;
        }

        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            Bundle arguments = this.getArguments();
            View fragment = inflater.inflate(arguments.getInt(ARGUMENT_LAYOUT_RES, R.layout.fragment_simple_slide), container, false);
            TextView title = (TextView)fragment.findViewById(R.id.mi_title);
            TextView description = (TextView)fragment.findViewById(R.id.mi_description);
            this.buttonGrantPermissions = (Button)fragment.findViewById(R.id.mi_button_grant_permissions);
            ImageView image = (ImageView)fragment.findViewById(R.id.mi_image);
            int titleRes = arguments.getInt(ARGUMENT_TITLE_RES);
            int descRes = arguments.getInt(ARGUMENT_DESCRIPTION_RES);
            int imgRes = arguments.getInt(ARGUMENT_IMAGE_RES);
            int backgroundRes = arguments.getInt(ARGUMENT_BACKGROUND_RES);
            int backgroundDarkRes = arguments.getInt(ARGUMENT_BACKGROUND_DARK_RES);
            String[] permissions = arguments.getStringArray(ARGUMENT_PERMISSIONS);
            if (titleRes != 0) {
                title.setText(titleRes);
            }
            if (descRes != 0) {
                description.setText(descRes);
            }
            if (imgRes != 0) {
                image.setImageResource(imgRes);
            }
            if (backgroundDarkRes != 0) {
                ViewCompat.setBackgroundTintList((View)this.buttonGrantPermissions, (ColorStateList)ColorStateList.valueOf((int)ContextCompat.getColor((Context)this.getContext(), (int)backgroundDarkRes)));
            }
            if (backgroundRes != 0) {
                if (ColorUtils.calculateLuminance((int)ContextCompat.getColor((Context)this.getContext(), (int)backgroundRes)) > 0.6) {
                    title.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.mi_text_color_primary_light));
                    description.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.mi_text_color_secondary_light));
                    this.buttonGrantPermissions.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.mi_text_color_primary_light));
                } else {
                    title.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.mi_text_color_primary_dark));
                    description.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.mi_text_color_secondary_dark));
                    this.buttonGrantPermissions.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.mi_text_color_primary_dark));
                }
            }
            this.updatePermissions(permissions);
            return fragment;
        }

        private void updatePermissions(String[] permissions) {
            Log.d((String)"SimpleSlide", (String)"Updating permissions...");
            if (permissions != null) {
                final ArrayList<String> permissionsNotGranted = new ArrayList<String>();
                for (String permission : permissions) {
                    if (ContextCompat.checkSelfPermission((Context)this.getActivity(), (String)permission) == 0) continue;
                    permissionsNotGranted.add(permission);
                }
                if (permissionsNotGranted.size() > 0) {
                    this.buttonGrantPermissions.setVisibility(0);
                    this.buttonGrantPermissions.setText(this.getResources().getQuantityText(R.plurals.mi_label_grant_permission, permissionsNotGranted.size()));
                    this.buttonGrantPermissions.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            ActivityCompat.requestPermissions((Activity)Fragment.this.getActivity(), (String[])permissionsNotGranted.toArray(new String[permissionsNotGranted.size()]), (int)34);
                        }
                    });
                } else {
                    this.buttonGrantPermissions.setVisibility(8);
                    this.permissionsGranted = true;
                    this.updateNavigation();
                }
            } else {
                this.buttonGrantPermissions.setVisibility(8);
                this.permissionsGranted = true;
                this.updateNavigation();
            }
        }

        public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
            if (requestCode == 34) {
                this.updatePermissions(permissions);
            }
        }

        @Override
        public boolean canGoForward() {
            return this.permissionsGranted;
        }
    }

    public static class Builder {
        @ColorRes
        private int background = 0;
        @ColorRes
        private int backgroundDark = 0;
        @StringRes
        private int title = 0;
        @StringRes
        private int description = 0;
        @DrawableRes
        private int image = 0;
        @LayoutRes
        private int layout = R.layout.fragment_simple_slide;
        private boolean canGoForward = true;
        private boolean canGoBackward = true;
        private String[] permissions = null;

        public Builder background(@ColorRes int background) {
            this.background = background;
            return this;
        }

        public Builder backgroundDark(@ColorRes int backgroundDark) {
            this.backgroundDark = backgroundDark;
            return this;
        }

        public Builder title(@StringRes int title) {
            this.title = title;
            return this;
        }

        public Builder description(@StringRes int description) {
            this.description = description;
            return this;
        }

        public Builder image(@DrawableRes int image) {
            this.image = image;
            return this;
        }

        public Builder layout(@LayoutRes int layout2) {
            this.layout = layout2;
            return this;
        }

        public Builder scrollable(boolean scrollable) {
            this.layout = scrollable ? R.layout.fragment_simple_slide_scrollable : R.layout.fragment_simple_slide;
            return this;
        }

        public Builder canGoForward(boolean canGoForward) {
            this.canGoForward = canGoForward;
            return this;
        }

        public Builder canGoBackward(boolean canGoBackward) {
            this.canGoBackward = canGoBackward;
            return this;
        }

        public Builder permissions(String[] permissions) {
            this.permissions = permissions;
            return this;
        }

        public Builder permission(String permission) {
            this.permissions = new String[]{permission};
            return this;
        }

        public SimpleSlide build() {
            return new SimpleSlide(this);
        }
    }
}

