/*
 * Decompiled with CFR 0.152.
 */
package com.heinrichreimersoftware.materialintro.slide;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.ColorRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.StyleRes;
import android.support.v7.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.heinrichreimersoftware.materialintro.slide.Slide;

public class FragmentSlide
extends Slide {
    private final android.support.v4.app.Fragment fragment;
    @ColorRes
    private final int background;
    @ColorRes
    private final int backgroundDark;

    private FragmentSlide(Builder builder) {
        this.fragment = builder.fragment;
        this.background = builder.background;
        this.backgroundDark = builder.backgroundDark;
    }

    @Override
    public android.support.v4.app.Fragment getFragment() {
        return this.fragment;
    }

    @Override
    public int getBackground() {
        return this.background;
    }

    @Override
    public int getBackgroundDark() {
        return this.backgroundDark;
    }

    public static class Fragment
    extends android.support.v4.app.Fragment {
        private static final String ARGUMENT_LAYOUT_RES = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_LAYOUT_RES";
        private static final String ARGUMENT_THEME_RES = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_THEME_RES";

        public static Fragment newInstance(@LayoutRes int layoutRes, @StyleRes int themeRes) {
            Fragment fragment = new Fragment();
            Bundle arguments = new Bundle();
            arguments.putInt(ARGUMENT_LAYOUT_RES, layoutRes);
            arguments.putInt(ARGUMENT_THEME_RES, themeRes);
            fragment.setArguments(arguments);
            return fragment;
        }

        public static Fragment newInstance(@LayoutRes int layoutRes) {
            return Fragment.newInstance(layoutRes, -1);
        }

        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper((Context)this.getActivity(), this.getArguments().getInt(ARGUMENT_THEME_RES));
            LayoutInflater localInflater = inflater.cloneInContext((Context)contextThemeWrapper);
            return localInflater.inflate(this.getArguments().getInt(ARGUMENT_LAYOUT_RES), container, false);
        }
    }

    public static class Builder {
        private android.support.v4.app.Fragment fragment;
        @ColorRes
        private int background;
        @ColorRes
        private int backgroundDark = 0;

        public Builder fragment(android.support.v4.app.Fragment fragment) {
            this.fragment = fragment;
            return this;
        }

        public Builder fragment(@LayoutRes int layoutRes, @StyleRes int themeRes) {
            this.fragment = Fragment.newInstance(layoutRes, themeRes);
            return this;
        }

        public Builder fragment(@LayoutRes int layoutRes) {
            this.fragment = Fragment.newInstance(layoutRes);
            return this;
        }

        public Builder background(@ColorRes int background) {
            this.background = background;
            return this;
        }

        public Builder backgroundDark(@ColorRes int backgroundDark) {
            this.backgroundDark = backgroundDark;
            return this;
        }

        public FragmentSlide build() {
            if (this.background == 0 || this.fragment == null) {
                throw new IllegalArgumentException("You must set at least a fragment and background.");
            }
            return new FragmentSlide(this);
        }
    }
}

