/*
 * Decompiled with CFR 0.152.
 */
package com.heinrichreimersoftware.materialintro.slide;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.ColorUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.heinrichreimersoftware.materialintro.R;
import com.heinrichreimersoftware.materialintro.slide.Slide;

public class SimpleSlide
extends Slide {
    private final Fragment fragment;
    @ColorRes
    private final int background;
    @ColorRes
    private final int backgroundDark;

    private SimpleSlide(Builder builder) {
        this.fragment = Fragment.newInstance(builder.title, builder.description, builder.image, builder.background);
        this.background = builder.background;
        this.backgroundDark = builder.backgroundDark;
    }

    @Override
    public Fragment getFragment() {
        return this.fragment;
    }

    @Override
    public int getBackground() {
        return this.background;
    }

    @Override
    public int getBackgroundDark() {
        return this.backgroundDark;
    }

    public static class Fragment
    extends android.support.v4.app.Fragment {
        private static final String ARGUMENT_TITLE_RES = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_TITLE_RES";
        private static final String ARGUMENT_DESCRIPTION_RES = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_DESCRIPTION_RES";
        private static final String ARGUMENT_IMAGE_RES = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_IMAGE_RES";
        private static final String ARGUMENT_BACKGROUND_RES = "com.heinrichreimersoftware.materialintro.SimpleFragment.ARGUMENT_BACKGROUND_RES";

        public static Fragment newInstance(@StringRes int title, @StringRes int description, @DrawableRes int image, @ColorRes int background) {
            Fragment fragment = new Fragment();
            Bundle arguments = new Bundle();
            arguments.putInt(ARGUMENT_TITLE_RES, title);
            arguments.putInt(ARGUMENT_DESCRIPTION_RES, description);
            arguments.putInt(ARGUMENT_IMAGE_RES, image);
            arguments.putInt(ARGUMENT_BACKGROUND_RES, background);
            fragment.setArguments(arguments);
            return fragment;
        }

        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            View fragment = inflater.inflate(R.layout.fragment_simple_slide, container, false);
            TextView title = (TextView)fragment.findViewById(R.id.mi_title);
            TextView description = (TextView)fragment.findViewById(R.id.mi_description);
            ImageView image = (ImageView)fragment.findViewById(R.id.mi_image);
            Bundle arguments = this.getArguments();
            title.setText(arguments.getInt(ARGUMENT_TITLE_RES));
            description.setText(arguments.getInt(ARGUMENT_DESCRIPTION_RES));
            image.setImageResource(arguments.getInt(ARGUMENT_IMAGE_RES));
            int background = ContextCompat.getColor((Context)this.getContext(), (int)arguments.getInt(ARGUMENT_BACKGROUND_RES));
            if (ColorUtils.calculateLuminance((int)background) > 0.6) {
                title.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.mi_text_color_primary_light));
                description.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.mi_text_color_secondary_light));
            } else {
                title.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.mi_text_color_primary_dark));
                description.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.mi_text_color_secondary_dark));
            }
            return fragment;
        }
    }

    public static class Builder {
        @ColorRes
        private int background = 0;
        @ColorRes
        private int backgroundDark = 0;
        @StringRes
        private int title = 0;
        @StringRes
        private int description = 0;
        @DrawableRes
        private int image = 0;

        public Builder background(int background) {
            this.background = background;
            return this;
        }

        public Builder backgroundDark(int backgroundDark) {
            this.backgroundDark = backgroundDark;
            return this;
        }

        public Builder title(int title) {
            this.title = title;
            return this;
        }

        public Builder description(int description) {
            this.description = description;
            return this;
        }

        public Builder image(int image) {
            this.image = image;
            return this;
        }

        public SimpleSlide build() {
            if (this.background == 0 || this.title == 0) {
                throw new IllegalArgumentException("You must set at least a title and background.");
            }
            return new SimpleSlide(this);
        }
    }
}

