/*
 * Decompiled with CFR 0.152.
 */
package com.heinrichreimersoftware.materialdrawer.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import com.heinrichreimersoftware.materialdrawer.R;
import com.heinrichreimersoftware.materialdrawer.widget.IcsLinearLayout;

public class LinearListView
extends IcsLinearLayout {
    private static final int[] R_styleable_LinearListView = new int[]{16842930, R.attr.dividerThickness};
    private static final int LinearListView_entries = 0;
    private static final int LinearListView_dividerThickness = 1;
    private View mEmptyView;
    private ListAdapter mAdapter;
    private boolean mAreAllItemsSelectable;
    private final DataSetObserver mDataObserver = new DataSetObserver(){

        public void onChanged() {
            LinearListView.this.setupChildren();
        }

        public void onInvalidated() {
            LinearListView.this.setupChildren();
        }
    };
    private OnItemClickListener mOnItemClickListener;

    public LinearListView(Context context) {
        this(context, null);
    }

    public LinearListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        Object[] entries;
        TypedArray a = context.obtainStyledAttributes(attrs, R_styleable_LinearListView);
        int thickness = a.getDimensionPixelSize(1, 0);
        if (thickness != 0) {
            this.setDividerThickness(thickness);
        }
        if ((entries = a.getTextArray(0)) != null) {
            this.setAdapter((ListAdapter)new ArrayAdapter(context, 17367043, entries));
        }
        a.recycle();
    }

    public void setOrientation(int orientation) {
        if (orientation != this.getOrientation()) {
            int tmp = this.mDividerHeight;
            this.mDividerHeight = this.mDividerWidth;
            this.mDividerWidth = tmp;
        }
        super.setOrientation(orientation);
    }

    public void setDividerThickness(int thickness) {
        if (this.getOrientation() == 1) {
            this.mDividerHeight = thickness;
        } else {
            this.mDividerWidth = thickness;
        }
        this.requestLayout();
    }

    public ListAdapter getAdapter() {
        return this.mAdapter;
    }

    public void setAdapter(ListAdapter adapter) {
        if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver(this.mDataObserver);
        }
        this.mAdapter = adapter;
        if (this.mAdapter != null) {
            this.mAdapter.registerDataSetObserver(this.mDataObserver);
            this.mAreAllItemsSelectable = this.mAdapter.areAllItemsEnabled();
        }
        this.setupChildren();
    }

    public final OnItemClickListener getOnItemClickListener() {
        return this.mOnItemClickListener;
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.mOnItemClickListener = listener;
    }

    public boolean performItemClick(View view, int position, long id2) {
        if (this.mOnItemClickListener != null) {
            this.playSoundEffect(0);
            this.mOnItemClickListener.onItemClick(this, view, position, id2);
            return true;
        }
        return false;
    }

    public View getEmptyView() {
        return this.mEmptyView;
    }

    public void setEmptyView(View emptyView) {
        this.mEmptyView = emptyView;
        ListAdapter adapter = this.getAdapter();
        boolean empty = adapter == null || adapter.isEmpty();
        this.updateEmptyStatus(empty);
    }

    private void updateEmptyStatus(boolean empty) {
        if (empty) {
            if (this.mEmptyView != null) {
                this.mEmptyView.setVisibility(0);
                this.setVisibility(8);
            } else {
                this.setVisibility(0);
            }
        } else {
            if (this.mEmptyView != null) {
                this.mEmptyView.setVisibility(8);
            }
            this.setVisibility(0);
        }
    }

    private void setupChildren() {
        this.removeAllViews();
        this.updateEmptyStatus(this.mAdapter == null || this.mAdapter.isEmpty());
        if (this.mAdapter == null) {
            return;
        }
        for (int i = 0; i < this.mAdapter.getCount(); ++i) {
            View child = this.mAdapter.getView(i, null, (ViewGroup)this);
            if (this.mAreAllItemsSelectable || this.mAdapter.isEnabled(i)) {
                child.setOnClickListener((View.OnClickListener)new InternalOnClickListener(i));
            }
            this.addViewInLayout(child, -1, child.getLayoutParams(), true);
        }
    }

    private class InternalOnClickListener
    implements View.OnClickListener {
        private final int mPosition;

        public InternalOnClickListener(int position) {
            this.mPosition = position;
        }

        public void onClick(View v) {
            if (LinearListView.this.mOnItemClickListener != null && LinearListView.this.mAdapter != null) {
                LinearListView.this.mOnItemClickListener.onItemClick(LinearListView.this, v, this.mPosition, LinearListView.this.mAdapter.getItemId(this.mPosition));
            }
        }
    }

    public static interface OnItemClickListener {
        public void onItemClick(LinearListView var1, View var2, int var3, long var4);
    }
}

