/*
 * Decompiled with CFR 0.152.
 */
package com.heinrichreimersoftware.materialdrawer.structure;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import com.heinrichreimersoftware.materialdrawer.DrawerView;
import com.heinrichreimersoftware.materialdrawer.drawable.RoundedAvatarDrawable;
import com.heinrichreimersoftware.materialdrawer.theme.DrawerTheme;

public class DrawerProfile {
    private DrawerTheme mDrawerTheme;
    private long mId = -1L;
    private Drawable mAvatar = null;
    private Drawable mBackground = null;
    private String mName;
    private String mDescription;
    private OnProfileClickListener mOnClickListener;
    private DrawerView mDrawerView;

    public DrawerProfile setDrawerTheme(DrawerTheme theme) {
        this.mDrawerTheme = theme;
        this.notifyDataChanged();
        return this;
    }

    public DrawerProfile resetDrawerTheme(Context context) {
        this.mDrawerTheme = new DrawerTheme(context);
        this.notifyDataChanged();
        return this;
    }

    public DrawerTheme getDrawerTheme() {
        return this.mDrawerTheme;
    }

    public boolean hasDrawerTheme() {
        return this.mDrawerTheme != null;
    }

    public DrawerProfile setId(long id2) {
        this.mId = id2;
        return this;
    }

    public long getId() {
        return this.mId;
    }

    public DrawerProfile setAvatar(Drawable avatar) {
        this.mAvatar = avatar;
        this.notifyDataChanged();
        return this;
    }

    public DrawerProfile setAvatar(Context context, Bitmap avatar) {
        this.mAvatar = new BitmapDrawable(context.getResources(), avatar);
        this.notifyDataChanged();
        return this;
    }

    public DrawerProfile setRoundedAvatar(BitmapDrawable image) {
        return this.setAvatar(new RoundedAvatarDrawable(image.getBitmap()));
    }

    public DrawerProfile setRoundedAvatar(Context context, Bitmap image) {
        return this.setAvatar(new RoundedAvatarDrawable(new BitmapDrawable(context.getResources(), image).getBitmap()));
    }

    public Drawable getAvatar() {
        return this.mAvatar;
    }

    public boolean hasAvatar() {
        return this.mAvatar != null;
    }

    public DrawerProfile removeAvatar() {
        this.mAvatar = null;
        this.notifyDataChanged();
        return this;
    }

    public DrawerProfile setBackground(Drawable background) {
        this.mBackground = background;
        this.notifyDataChanged();
        return this;
    }

    public DrawerProfile setBackground(Context context, Bitmap background) {
        this.mBackground = new BitmapDrawable(context.getResources(), background);
        this.notifyDataChanged();
        return this;
    }

    public Drawable getBackground() {
        return this.mBackground;
    }

    public boolean hasBackground() {
        return this.mBackground != null;
    }

    public DrawerProfile removeBackground() {
        this.mBackground = null;
        this.notifyDataChanged();
        return this;
    }

    public DrawerProfile setName(String name) {
        this.mName = name;
        this.notifyDataChanged();
        return this;
    }

    public String getName() {
        return this.mName;
    }

    public boolean hasName() {
        return this.mName != null && !this.mName.equals("");
    }

    public DrawerProfile removeName() {
        this.mName = null;
        this.notifyDataChanged();
        return this;
    }

    public DrawerProfile setDescription(String description) {
        this.mDescription = description;
        this.notifyDataChanged();
        return this;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public boolean hasDescription() {
        return this.mDescription != null && !this.mDescription.equals("");
    }

    public DrawerProfile removeDescription() {
        this.mDescription = null;
        this.notifyDataChanged();
        return this;
    }

    public DrawerProfile setOnProfileClickListener(OnProfileClickListener listener) {
        this.mOnClickListener = listener;
        this.notifyDataChanged();
        return this;
    }

    public OnProfileClickListener getOnProfileClickListener() {
        return this.mOnClickListener;
    }

    public boolean hasOnProfileClickListener() {
        return this.mOnClickListener != null;
    }

    public DrawerProfile removeOnProfileClickListener() {
        this.mOnClickListener = null;
        this.notifyDataChanged();
        return this;
    }

    public DrawerProfile attachTo(DrawerView drawerView) {
        this.mDrawerView = drawerView;
        return this;
    }

    public DrawerProfile detach() {
        this.mDrawerView = null;
        return this;
    }

    protected void notifyDataChanged() {
        if (this.mDrawerView != null) {
            this.mDrawerView.selectProfile(this);
        }
    }

    public static interface OnProfileSwitchListener {
        public void onSwitch(DrawerProfile var1, long var2, DrawerProfile var4, long var5);
    }

    public static interface OnProfileClickListener {
        public void onClick(DrawerProfile var1, long var2);
    }
}

