/*
 * Decompiled with CFR 0.152.
 */
package com.heinrichreimersoftware.materialdrawer.animation;

import android.animation.TypeEvaluator;
import android.graphics.ColorMatrix;

public class AlphaSatColorMatrixEvaluator
implements TypeEvaluator {
    private static final int MAX_BLACKER = 50;
    private final ColorMatrix colorMatrix;
    private final float[] elements = new float[20];

    public AlphaSatColorMatrixEvaluator() {
        this.colorMatrix = new ColorMatrix();
    }

    public ColorMatrix getColorMatrix() {
        return this.colorMatrix;
    }

    public Object evaluate(float fraction, Object startValue, Object endValue) {
        float alpha;
        float phase = fraction * 3.0f;
        this.elements[18] = alpha = Math.min(phase, 2.0f) / 2.0f;
        float blackening = Math.round((1.0f - Math.min(phase, 2.5f) / 2.5f) * 50.0f);
        this.elements[9] = this.elements[14] = -blackening;
        this.elements[4] = this.elements[14];
        float invSat = 1.0f - Math.max(0.0f, fraction);
        float R2 = 0.213f * invSat;
        float G = 0.715f * invSat;
        float B = 0.072f * invSat;
        this.elements[0] = R2 + fraction;
        this.elements[1] = G;
        this.elements[2] = B;
        this.elements[5] = R2;
        this.elements[6] = G + fraction;
        this.elements[7] = B;
        this.elements[10] = R2;
        this.elements[11] = G;
        this.elements[12] = B + fraction;
        this.colorMatrix.set(this.elements);
        return this.colorMatrix;
    }
}

