/*
 * Decompiled with CFR 0.152.
 */
package com.heinrichreimersoftware.materialdrawer;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.content.ContextCompat;
import android.support.v4.text.TextUtilsCompat;
import android.support.v7.graphics.Palette;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Property;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import com.heinrichreimersoftware.materialdrawer.R;
import com.heinrichreimersoftware.materialdrawer.adapter.DrawerAdapter;
import com.heinrichreimersoftware.materialdrawer.adapter.DrawerProfileAdapter;
import com.heinrichreimersoftware.materialdrawer.animation.AlphaSatColorMatrixEvaluator;
import com.heinrichreimersoftware.materialdrawer.animation.AnimatableColorMatrixColorFilter;
import com.heinrichreimersoftware.materialdrawer.animation.StepInterpolator;
import com.heinrichreimersoftware.materialdrawer.structure.DrawerHeaderItem;
import com.heinrichreimersoftware.materialdrawer.structure.DrawerItem;
import com.heinrichreimersoftware.materialdrawer.structure.DrawerProfile;
import com.heinrichreimersoftware.materialdrawer.theme.DrawerTheme;
import com.heinrichreimersoftware.materialdrawer.widget.LinearListView;
import com.heinrichreimersoftware.materialdrawer.widget.ScrimInsetsFrameLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class DrawerView
extends ScrimInsetsFrameLayout
implements ScrimInsetsFrameLayout.OnInsetsCallback {
    public static final String STATE_PROFILE_LIST_OPEN = "mdProfileListOpen";
    public static final String STATE_LIST_SELECTION = "mdListSelection";
    public static final String STATE_FIXED_LIST_SELECTION = "mdFixedListSelection";
    private static final String TAG = "DrawerView";
    private static final Property<Drawable, Integer> PROPERTY_LEVEL = new Property<Drawable, Integer>(Integer.class, "level"){

        public Integer get(Drawable object) {
            return object.getLevel();
        }

        public void set(Drawable object, Integer value) {
            object.setLevel(value.intValue());
        }
    };
    private static final Property<ScrollView, Integer> PROPERTY_SCROLL_POSITION = new Property<ScrollView, Integer>(Integer.class, "scrollY"){

        public Integer get(ScrollView object) {
            return object.getScrollY();
        }

        public void set(ScrollView object, Integer value) {
            object.scrollTo(0, value.intValue());
        }
    };
    private DrawerProfileAdapter mProfileAdapter;
    private DrawerAdapter mAdapter;
    private DrawerAdapter mAdapterFixed;
    private DrawerProfile.OnProfileClickListener onProfileClickListener;
    private DrawerProfile.OnProfileSwitchListener onProfileSwitchListener;
    private DrawerItem.OnItemClickListener mOnItemClickListener;
    private DrawerItem.OnItemClickListener mOnFixedItemClickListener;
    private ScrollView scrollView;
    private LinearLayout layout;
    private FrameLayout frameLayoutProfile;
    private RelativeLayout relativeLayoutProfileContent;
    private ImageView imageViewProfileAvatar;
    private ImageView imageViewProfileAvatarSecondary;
    private TextView textViewProfileAvatarCount;
    private ImageView imageViewProfileBackground;
    private ImageView imageViewProfileBackgroundOverlay;
    private LinearLayout linearLayoutProfileTextContainer;
    private TextView textViewProfileName;
    private TextView textViewProfileDescription;
    private ImageView imageViewOpenProfileListIcon;
    private LinearListView linearListViewProfileList;
    private LinearListView linearListView;
    private View fixedShadow;
    private View fixedDivider;
    private LinearLayout fixedListContainer;
    private LinearListView linearListViewFixed;
    private DrawerTheme drawerTheme;
    private int statusBarHeight = 0;
    private int drawerMaxWidth = -1;
    private boolean profileListOpen = false;
    private boolean isInViewHierarchy = false;
    private boolean loggingEnabled = false;

    public DrawerView(Context context) {
        this(context, null);
    }

    public DrawerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DrawerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (this.loggingEnabled) {
            Log.d((String)TAG, (String)"DrawerView()");
        }
        this.init(context);
    }

    private void init(Context context) {
        if (this.loggingEnabled) {
            Log.d((String)TAG, (String)"init()");
        }
        DrawerView.inflate((Context)context, (int)R.layout.md_drawer_view, (ViewGroup)this);
        this.findViews();
        this.setClipToPadding(false);
        this.setInsetForeground((Drawable)new ColorDrawable(ContextCompat.getColor((Context)this.getContext(), (int)R.color.md_inset_foreground)));
        this.setOnInsetsCallback(this);
        this.mProfileAdapter = new DrawerProfileAdapter(context, new ArrayList<DrawerProfile>());
        this.linearListViewProfileList.setAdapter((ListAdapter)this.mProfileAdapter);
        this.linearListViewProfileList.setOnItemClickListener(new LinearListView.OnItemClickListener(){

            @Override
            public void onItemClick(LinearListView parent, View view, int position, long id2) {
                if (position != 0) {
                    DrawerView.this.selectProfile((DrawerProfile)DrawerView.this.mProfileAdapter.getItem(position));
                }
            }
        });
        this.mAdapter = new DrawerAdapter(context, new ArrayList<DrawerItem>());
        this.linearListView.setAdapter((ListAdapter)this.mAdapter);
        this.linearListView.setOnItemClickListener(new LinearListView.OnItemClickListener(){

            @Override
            public void onItemClick(LinearListView parent, View view, int position, long id2) {
                DrawerItem item = (DrawerItem)DrawerView.this.mAdapter.getItem(position);
                if (!item.isHeader()) {
                    if (item.hasOnItemClickListener()) {
                        item.getOnItemClickListener().onClick(item, item.getId(), position);
                    } else if (DrawerView.this.hasOnItemClickListener()) {
                        DrawerView.this.mOnItemClickListener.onClick(item, item.getId(), position);
                    }
                }
            }
        });
        this.mAdapterFixed = new DrawerAdapter(context, new ArrayList<DrawerItem>());
        this.linearListViewFixed.setAdapter((ListAdapter)this.mAdapterFixed);
        this.linearListViewFixed.setOnItemClickListener(new LinearListView.OnItemClickListener(){

            @Override
            public void onItemClick(LinearListView parent, View view, int position, long id2) {
                DrawerItem item = (DrawerItem)DrawerView.this.mAdapterFixed.getItem(position);
                if (!item.isHeader()) {
                    if (item.hasOnItemClickListener()) {
                        item.getOnItemClickListener().onClick(item, item.getId(), position);
                    } else if (DrawerView.this.hasOnFixedItemClickListener()) {
                        DrawerView.this.mOnFixedItemClickListener.onClick(item, item.getId(), position);
                    }
                }
            }
        });
        this.resetDrawerTheme();
        this.imageViewOpenProfileListIcon.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DrawerView.this.toggleProfileList();
            }
        });
        this.frameLayoutProfile.setVisibility(8);
        this.layout.setPadding(0, this.statusBarHeight, 0, 0);
        this.updateListVisibility();
    }

    private void findViews() {
        if (this.loggingEnabled) {
            Log.d((String)TAG, (String)"findViews()");
        }
        this.scrollView = (ScrollView)this.findViewById(R.id.mdScrollView);
        this.layout = (LinearLayout)this.findViewById(R.id.mdLayout);
        this.frameLayoutProfile = (FrameLayout)this.findViewById(R.id.mdLayoutProfile);
        this.relativeLayoutProfileContent = (RelativeLayout)this.findViewById(R.id.mdLayoutProfileContent);
        this.imageViewProfileAvatar = (ImageView)this.findViewById(R.id.mdAvatarProfile);
        this.imageViewProfileAvatarSecondary = (ImageView)this.findViewById(R.id.mdAvatarProfileSecondary);
        this.textViewProfileAvatarCount = (TextView)this.findViewById(R.id.mdAvatarProfileCount);
        this.imageViewProfileBackground = (ImageView)this.findViewById(R.id.mdProfileBackground);
        this.imageViewProfileBackgroundOverlay = (ImageView)this.findViewById(R.id.mdProfileBackgroundOverlay);
        this.linearLayoutProfileTextContainer = (LinearLayout)this.findViewById(R.id.mdProfileTextContainer);
        this.textViewProfileName = (TextView)this.findViewById(R.id.mdProfileName);
        this.textViewProfileDescription = (TextView)this.findViewById(R.id.mdProfileDescription);
        this.imageViewOpenProfileListIcon = (ImageView)this.findViewById(R.id.mdOpenProfileListIcon);
        this.linearListViewProfileList = (LinearListView)this.findViewById(R.id.mdProfileList);
        this.linearListView = (LinearListView)this.findViewById(R.id.mdList);
        this.fixedShadow = this.findViewById(R.id.mdFixedShadow);
        this.fixedDivider = this.findViewById(R.id.mdFixedDivider);
        this.fixedListContainer = (LinearLayout)this.findViewById(R.id.mdFixedListContainer);
        this.linearListViewFixed = (LinearListView)this.findViewById(R.id.mdLinearListViewFixed);
    }

    private void updateTheme() {
        this.setBackgroundColor(this.drawerTheme.getBackgroundColor());
        this.setInsetForeground((Drawable)new ColorDrawable(this.drawerTheme.getStatusBarBackgroundColor()));
        if (this.drawerTheme.isLightTheme()) {
            this.fixedDivider.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.md_divider_light));
        } else {
            this.fixedDivider.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.md_divider_dark));
        }
        this.linearListViewFixed.setBackgroundColor(this.drawerTheme.getBackgroundColor());
        this.mAdapter.setDrawerTheme(this.drawerTheme);
        this.mAdapterFixed.setDrawerTheme(this.drawerTheme);
        this.mProfileAdapter.setDrawerTheme(this.drawerTheme);
        this.updateProfileTheme();
    }

    private void updateProfileTheme() {
        DrawerTheme drawerTheme = this.drawerTheme;
        if (this.mProfileAdapter.getCount() > 0 && this.mProfileAdapter.getItem(0) != null && ((DrawerProfile)this.mProfileAdapter.getItem(0)).hasDrawerTheme()) {
            drawerTheme = ((DrawerProfile)this.mProfileAdapter.getItem(0)).getDrawerTheme();
        }
        this.textViewProfileName.setTextColor(drawerTheme.getTextColorPrimaryInverse());
        this.textViewProfileDescription.setTextColor(drawerTheme.getTextColorSecondaryInverse());
        this.imageViewOpenProfileListIcon.setColorFilter(drawerTheme.getTextColorPrimaryInverse(), PorterDuff.Mode.SRC_IN);
        if (drawerTheme.isLightTheme()) {
            this.imageViewOpenProfileListIcon.setBackgroundResource(R.drawable.md_selector_light);
        } else {
            this.imageViewOpenProfileListIcon.setBackgroundResource(R.drawable.md_selector_dark);
        }
    }

    private void updateDrawerWidth() {
        int navigationBarWidthResId;
        if (this.loggingEnabled) {
            Log.d((String)TAG, (String)"updateDrawerWidth()");
        }
        int viewportWidth = this.getContext().getResources().getDisplayMetrics().widthPixels;
        int viewportHeight = this.getContext().getResources().getDisplayMetrics().heightPixels;
        if (this.getResources().getConfiguration().orientation == 2 && (navigationBarWidthResId = this.getResources().getIdentifier("navigation_bar_width", "dimen", "android")) > 0) {
            viewportWidth -= this.getResources().getDimensionPixelSize(navigationBarWidthResId);
        }
        int viewportMin = Math.min(viewportWidth, viewportHeight);
        TypedValue typedValue = new TypedValue();
        this.getContext().getTheme().resolveAttribute(R.attr.actionBarSize, typedValue, true);
        int actionBarSize = TypedValue.complexToDimensionPixelSize((int)typedValue.data, (DisplayMetrics)this.getResources().getDisplayMetrics());
        int width = viewportMin - actionBarSize;
        this.getLayoutParams().width = Math.min(width, this.drawerMaxWidth);
        this.updateProfileSpacing();
    }

    private void updateProfileSpacing() {
        if (this.loggingEnabled) {
            Log.d((String)TAG, (String)"updateProfileSpacing()");
        }
        if (this.mProfileAdapter.getCount() > 0) {
            int aspectRatioHeight = Math.round(this.getLayoutParams().width / 16 * 9) - this.statusBarHeight;
            int minHeight = this.getResources().getDimensionPixelSize(R.dimen.md_baseline);
            if (this.mProfileAdapter.getItem(0) != null && ((DrawerProfile)this.mProfileAdapter.getItem(0)).hasAvatar()) {
                minHeight += this.getResources().getDimensionPixelSize(R.dimen.md_big_avatar_size);
            }
            if (this.mProfileAdapter.getItem(0) != null && ((DrawerProfile)this.mProfileAdapter.getItem(0)).hasName()) {
                minHeight += this.getResources().getDimensionPixelSize(R.dimen.md_list_item_height);
            }
            if (this.mProfileAdapter.getItem(0) != null && ((DrawerProfile)this.mProfileAdapter.getItem(0)).hasDescription()) {
                minHeight += this.getResources().getDimensionPixelSize(R.dimen.md_baseline);
            }
            this.frameLayoutProfile.getLayoutParams().height = Math.max(aspectRatioHeight, minHeight) + this.statusBarHeight;
            this.frameLayoutProfile.setVisibility(0);
            this.relativeLayoutProfileContent.getLayoutParams().height = Math.max(aspectRatioHeight, minHeight);
            this.layout.setPadding(0, 0, 0, 0);
        } else {
            this.frameLayoutProfile.setVisibility(8);
            this.layout.setPadding(0, this.statusBarHeight, 0, 0);
        }
    }

    private void updateProfile() {
        if (this.loggingEnabled) {
            Log.d((String)TAG, (String)"updateProfile()");
        }
        if (this.mProfileAdapter.getCount() > 0 && this.isInViewHierarchy) {
            if (this.mProfileAdapter.getCount() > 2) {
                this.textViewProfileAvatarCount.setText((CharSequence)this.getResources().getString(R.string.md_label_plus, new Object[]{this.mProfileAdapter.getCount() - 1}));
                this.textViewProfileAvatarCount.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        DrawerView.this.openProfileList();
                    }
                });
                if (((DrawerProfile)this.mProfileAdapter.getItem(0)).getBackground() instanceof BitmapDrawable) {
                    new Palette.Builder(((BitmapDrawable)((DrawerProfile)this.mProfileAdapter.getItem(0)).getBackground()).getBitmap()).resizeBitmapSize(500).generate(new Palette.PaletteAsyncListener(){

                        public void onGenerated(Palette palette) {
                            Palette.Swatch vibrantSwatch = palette.getVibrantSwatch();
                            if (vibrantSwatch != null) {
                                DrawerView.this.textViewProfileAvatarCount.setTextColor(vibrantSwatch.getTitleTextColor());
                                DrawerView.this.textViewProfileAvatarCount.getBackground().setColorFilter(vibrantSwatch.getRgb(), PorterDuff.Mode.SRC_IN);
                            }
                        }
                    });
                }
                this.imageViewProfileAvatarSecondary.setVisibility(4);
                this.textViewProfileAvatarCount.setVisibility(0);
                this.imageViewOpenProfileListIcon.setVisibility(0);
            } else if (this.mProfileAdapter.getCount() == 2) {
                if (((DrawerProfile)this.mProfileAdapter.getItem(1)).hasAvatar()) {
                    this.imageViewProfileAvatarSecondary.setImageDrawable(((DrawerProfile)this.mProfileAdapter.getItem(1)).getAvatar());
                    this.imageViewProfileAvatarSecondary.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            DrawerView.this.selectProfile((DrawerProfile)DrawerView.this.mProfileAdapter.getItem(1));
                        }
                    });
                    this.imageViewProfileAvatarSecondary.setVisibility(0);
                } else {
                    this.imageViewProfileAvatarSecondary.setVisibility(4);
                }
                this.textViewProfileAvatarCount.setVisibility(8);
                this.imageViewOpenProfileListIcon.setVisibility(0);
                this.closeProfileList();
            } else {
                this.imageViewProfileAvatarSecondary.setVisibility(4);
                this.textViewProfileAvatarCount.setVisibility(8);
                this.imageViewOpenProfileListIcon.setVisibility(8);
            }
            if (((DrawerProfile)this.mProfileAdapter.getItem(0)).getAvatar() != null) {
                this.imageViewProfileAvatar.setImageDrawable(((DrawerProfile)this.mProfileAdapter.getItem(0)).getAvatar());
            }
            if (((DrawerProfile)this.mProfileAdapter.getItem(0)).getName() != null && !((DrawerProfile)this.mProfileAdapter.getItem(0)).getName().equals("")) {
                this.textViewProfileName.setText((CharSequence)((DrawerProfile)this.mProfileAdapter.getItem(0)).getName());
            }
            if (((DrawerProfile)this.mProfileAdapter.getItem(0)).getBackground() != null) {
                this.imageViewProfileBackground.setImageDrawable(((DrawerProfile)this.mProfileAdapter.getItem(0)).getBackground());
            } else {
                this.imageViewProfileBackground.setImageDrawable((Drawable)new ColorDrawable(ContextCompat.getColor((Context)this.getContext(), (int)17170445)));
            }
            if (((DrawerProfile)this.mProfileAdapter.getItem(0)).getDescription() != null && !((DrawerProfile)this.mProfileAdapter.getItem(0)).getDescription().equals("")) {
                this.textViewProfileDescription.setVisibility(0);
                this.textViewProfileDescription.setText((CharSequence)((DrawerProfile)this.mProfileAdapter.getItem(0)).getDescription());
            } else {
                this.textViewProfileDescription.setVisibility(8);
            }
            if (((DrawerProfile)this.mProfileAdapter.getItem(0)).hasOnProfileClickListener()) {
                this.frameLayoutProfile.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        ((DrawerProfile)DrawerView.this.mProfileAdapter.getItem(0)).getOnProfileClickListener().onClick((DrawerProfile)DrawerView.this.mProfileAdapter.getItem(0), ((DrawerProfile)DrawerView.this.mProfileAdapter.getItem(0)).getId());
                    }
                });
                this.frameLayoutProfile.setEnabled(true);
            } else if (this.hasOnProfileClickListener()) {
                this.frameLayoutProfile.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        DrawerView.this.onProfileClickListener.onClick((DrawerProfile)DrawerView.this.mProfileAdapter.getItem(0), ((DrawerProfile)DrawerView.this.mProfileAdapter.getItem(0)).getId());
                    }
                });
                this.frameLayoutProfile.setEnabled(true);
            } else {
                this.frameLayoutProfile.setEnabled(false);
            }
            this.updateProfileTheme();
        } else {
            this.closeProfileList();
        }
    }

    private void updateList() {
        if (this.loggingEnabled) {
            Log.d((String)TAG, (String)"updateList()");
        }
        if (this.mAdapter.getCount() <= 1 && this.isInViewHierarchy) {
            this.updateListVisibility();
        }
    }

    private void updateFixedList() {
        if (this.loggingEnabled) {
            Log.d((String)TAG, (String)"updateFixedList()");
        }
        if (this.mAdapterFixed.getCount() <= 1 && this.isInViewHierarchy) {
            this.updateListVisibility();
        }
    }

    private void updateListVisibility() {
        if (this.loggingEnabled) {
            Log.d((String)TAG, (String)"updateListVisibility()");
        }
        if (this.profileListOpen && this.mProfileAdapter.getCount() > 0) {
            this.linearListViewProfileList.setVisibility(0);
        } else {
            this.linearListViewProfileList.setVisibility(8);
        }
        if (!this.profileListOpen && this.mAdapter.getCount() > 0) {
            this.linearListView.setVisibility(0);
        } else {
            this.linearListView.setVisibility(8);
        }
        if (this.mAdapterFixed.getCount() > 0) {
            this.fixedListContainer.setVisibility(0);
            if (this.profileListOpen && this.mProfileAdapter.getCount() > 0 || !this.profileListOpen && this.mAdapter.getCount() > 0) {
                this.fixedDivider.setVisibility(0);
                this.fixedShadow.setVisibility(0);
            } else {
                this.fixedDivider.setVisibility(8);
                this.fixedShadow.setVisibility(8);
            }
        } else {
            this.fixedListContainer.setVisibility(8);
        }
    }

    private void animateToProfile(DrawerProfile profile) {
        if (this.loggingEnabled) {
            Log.d((String)TAG, (String)("animateToProfile(*" + profile.getId() + ")"));
        }
        if (this.mProfileAdapter.getCount() > 1) {
            ArrayList<Object> animators = new ArrayList<Object>();
            ArrayList<Object> listeners = new ArrayList<Object>();
            final DrawerProfile oldProfile = (DrawerProfile)this.mProfileAdapter.getItem(0);
            final DrawerProfile newProfile = profile;
            boolean isRtl = Build.VERSION.SDK_INT >= 17 && TextUtilsCompat.getLayoutDirectionFromLocale((Locale)Locale.getDefault()) == 1;
            int rtlSign = isRtl ? -1 : 1;
            AlphaSatColorMatrixEvaluator evaluator = new AlphaSatColorMatrixEvaluator();
            final AnimatableColorMatrixColorFilter filter = new AnimatableColorMatrixColorFilter(evaluator.getColorMatrix());
            ObjectAnimator backgroundAnimator = ObjectAnimator.ofObject((Object)filter, (String)"colorMatrix", (TypeEvaluator)evaluator, (Object[])new Object[]{evaluator.getColorMatrix()});
            backgroundAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    DrawerView.this.imageViewProfileBackgroundOverlay.setColorFilter((ColorFilter)filter.getColorFilter());
                }
            });
            animators.add(backgroundAnimator);
            listeners.add(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                    DrawerView.this.imageViewProfileBackground.setImageDrawable(oldProfile.getBackground());
                    DrawerView.this.imageViewProfileBackgroundOverlay.setImageDrawable(newProfile.getBackground());
                    DrawerView.this.imageViewProfileBackgroundOverlay.setColorFilter((ColorFilter)filter.getColorFilter());
                    DrawerView.this.imageViewProfileBackgroundOverlay.setVisibility(0);
                    DrawerView.this.imageViewProfileAvatarSecondary.setClickable(false);
                }

                public void onAnimationEnd(Animator animation) {
                    DrawerView.this.imageViewProfileBackground.setImageDrawable(newProfile.getBackground());
                    if (newProfile.getBackground() instanceof BitmapDrawable) {
                        new Palette.Builder(((BitmapDrawable)newProfile.getBackground()).getBitmap()).resizeBitmapSize(500).generate(new Palette.PaletteAsyncListener(){

                            public void onGenerated(Palette palette) {
                                Palette.Swatch vibrantSwatch = palette.getVibrantSwatch();
                                if (vibrantSwatch != null) {
                                    DrawerView.this.textViewProfileAvatarCount.setTextColor(vibrantSwatch.getTitleTextColor());
                                    DrawerView.this.textViewProfileAvatarCount.getBackground().setColorFilter(vibrantSwatch.getRgb(), PorterDuff.Mode.SRC_IN);
                                }
                            }
                        });
                    }
                    DrawerView.this.imageViewProfileBackgroundOverlay.setVisibility(8);
                    if (DrawerView.this.hasOnProfileSwitchListener()) {
                        DrawerView.this.onProfileSwitchListener.onSwitch(oldProfile, oldProfile.getId(), newProfile, newProfile.getId());
                    }
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            AnimatorSet textSet = new AnimatorSet();
            AnimatorSet textOutSet = new AnimatorSet();
            textOutSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)this.linearLayoutProfileTextContainer, (String)"alpha", (float[])new float[]{1.0f, 0.0f}), ObjectAnimator.ofFloat((Object)this.linearLayoutProfileTextContainer, (String)"translationX", (float[])new float[]{0.0f, this.getWidth() / 4 * rtlSign})});
            textOutSet.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    DrawerView.this.updateProfileTheme();
                    if (newProfile.hasName()) {
                        DrawerView.this.textViewProfileName.setText((CharSequence)newProfile.getName());
                        DrawerView.this.textViewProfileName.setVisibility(0);
                    } else {
                        DrawerView.this.textViewProfileName.setVisibility(8);
                    }
                    if (newProfile.hasDescription()) {
                        DrawerView.this.textViewProfileDescription.setText((CharSequence)newProfile.getDescription());
                        DrawerView.this.textViewProfileDescription.setVisibility(0);
                    } else {
                        DrawerView.this.textViewProfileDescription.setVisibility(8);
                    }
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            AnimatorSet textInSet = new AnimatorSet();
            textInSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)this.linearLayoutProfileTextContainer, (String)"alpha", (float[])new float[]{0.0f, 1.0f}), ObjectAnimator.ofFloat((Object)this.linearLayoutProfileTextContainer, (String)"translationX", (float[])new float[]{-this.getWidth() / 4 * rtlSign, 0.0f})});
            textSet.playSequentially(new Animator[]{textOutSet, textInSet});
            animators.add(textSet);
            AnimatorSet profileSet = new AnimatorSet();
            if (this.mProfileAdapter.getCount() == 2) {
                int translation = isRtl ? this.relativeLayoutProfileContent.getWidth() - this.getResources().getDimensionPixelSize(R.dimen.md_big_avatar_size) - 2 * this.getResources().getDimensionPixelSize(R.dimen.md_baseline) : this.imageViewProfileAvatarSecondary.getLeft() - this.getResources().getDimensionPixelSize(R.dimen.md_baseline);
                float scale = this.getResources().getDimension(R.dimen.md_avatar_size) / this.getResources().getDimension(R.dimen.md_big_avatar_size);
                float f = (this.getResources().getDimension(R.dimen.md_avatar_size) - this.getResources().getDimension(R.dimen.md_big_avatar_size)) / 2.0f;
                listeners.add(new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animation) {
                        DrawerView.this.imageViewProfileAvatarSecondary.setPivotX(0.0f);
                        DrawerView.this.imageViewProfileAvatarSecondary.setPivotY(0.0f);
                    }

                    public void onAnimationEnd(Animator animation) {
                        DrawerView.this.imageViewProfileAvatar.setTranslationX(0.0f);
                        DrawerView.this.imageViewProfileAvatar.setTranslationY(0.0f);
                        DrawerView.this.imageViewProfileAvatar.setScaleX(1.0f);
                        DrawerView.this.imageViewProfileAvatar.setScaleY(1.0f);
                        DrawerView.this.imageViewProfileAvatarSecondary.setTranslationX(0.0f);
                        DrawerView.this.imageViewProfileAvatarSecondary.setScaleX(1.0f);
                        DrawerView.this.imageViewProfileAvatarSecondary.setScaleY(1.0f);
                        if (oldProfile.hasAvatar()) {
                            DrawerView.this.imageViewProfileAvatarSecondary.setImageDrawable(oldProfile.getAvatar());
                            DrawerView.this.imageViewProfileAvatarSecondary.setVisibility(0);
                        } else {
                            DrawerView.this.imageViewProfileAvatarSecondary.setVisibility(4);
                        }
                        if (newProfile.hasAvatar()) {
                            DrawerView.this.imageViewProfileAvatar.setImageDrawable(newProfile.getAvatar());
                            DrawerView.this.imageViewProfileAvatar.setVisibility(0);
                            DrawerView.this.imageViewProfileAvatarSecondary.setClickable(true);
                        } else {
                            DrawerView.this.imageViewProfileAvatar.setVisibility(4);
                            DrawerView.this.imageViewProfileAvatarSecondary.setClickable(false);
                        }
                    }

                    public void onAnimationCancel(Animator animation) {
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
                if (oldProfile.hasAvatar()) {
                    ObjectAnimator stepTranslateXAnimator = ObjectAnimator.ofFloat((Object)this.imageViewProfileAvatar, (String)"translationX", (float[])new float[]{0.0f, (float)(translation * rtlSign) + f});
                    stepTranslateXAnimator.setInterpolator((TimeInterpolator)new StepInterpolator());
                    animators.add(stepTranslateXAnimator);
                    ObjectAnimator stepTranslateYAnimator = ObjectAnimator.ofFloat((Object)this.imageViewProfileAvatar, (String)"translationY", (float[])new float[]{0.0f, f});
                    stepTranslateYAnimator.setInterpolator((TimeInterpolator)new StepInterpolator());
                    animators.add(stepTranslateYAnimator);
                    animators.add(ObjectAnimator.ofFloat((Object)this.imageViewProfileAvatar, (String)"alpha", (float[])new float[]{1.0f, 0.0f, 1.0f}));
                    animators.add(ObjectAnimator.ofFloat((Object)this.imageViewProfileAvatar, (String)"scaleX", (float[])new float[]{1.0f, 0.5f, scale}));
                    animators.add(ObjectAnimator.ofFloat((Object)this.imageViewProfileAvatar, (String)"scaleY", (float[])new float[]{1.0f, 0.5f, scale}));
                }
                if (newProfile.hasAvatar()) {
                    animators.add(ObjectAnimator.ofFloat((Object)this.imageViewProfileAvatarSecondary, (String)"translationX", (float[])new float[]{0.0f, -translation * rtlSign}));
                    animators.add(ObjectAnimator.ofFloat((Object)this.imageViewProfileAvatarSecondary, (String)"scaleX", (float[])new float[]{1.0f, 1.0f / scale}));
                    animators.add(ObjectAnimator.ofFloat((Object)this.imageViewProfileAvatarSecondary, (String)"scaleY", (float[])new float[]{1.0f, 1.0f / scale}));
                }
            } else {
                AnimatorSet profileOutSet = new AnimatorSet();
                profileOutSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)this.imageViewProfileAvatar, (String)"alpha", (float[])new float[]{1.0f, 0.0f}), ObjectAnimator.ofFloat((Object)this.imageViewProfileAvatar, (String)"scaleX", (float[])new float[]{1.0f, 0.5f}), ObjectAnimator.ofFloat((Object)this.imageViewProfileAvatar, (String)"scaleY", (float[])new float[]{1.0f, 0.5f})});
                profileOutSet.addListener(new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animation) {
                        DrawerView.this.linearListViewProfileList.setOnItemClickListener(new LinearListView.OnItemClickListener(){

                            @Override
                            public void onItemClick(LinearListView parent, View view, int position, long id2) {
                            }
                        });
                    }

                    public void onAnimationEnd(Animator animation) {
                        DrawerView.this.imageViewProfileAvatar.setImageDrawable(newProfile.getAvatar());
                        DrawerView.this.linearListViewProfileList.setOnItemClickListener(new LinearListView.OnItemClickListener(){

                            @Override
                            public void onItemClick(LinearListView parent, View view, int position, long id2) {
                                if (position != 0) {
                                    DrawerView.this.selectProfile((DrawerProfile)DrawerView.this.mProfileAdapter.getItem(position));
                                }
                            }
                        });
                    }

                    public void onAnimationCancel(Animator animation) {
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
                AnimatorSet profileInSet = new AnimatorSet();
                profileInSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)this.imageViewProfileAvatar, (String)"alpha", (float[])new float[]{0.0f, 1.0f}), ObjectAnimator.ofFloat((Object)this.imageViewProfileAvatar, (String)"scaleX", (float[])new float[]{0.5f, 1.0f}), ObjectAnimator.ofFloat((Object)this.imageViewProfileAvatar, (String)"scaleY", (float[])new float[]{0.5f, 1.0f})});
                profileSet.playSequentially(new Animator[]{profileOutSet, profileInSet});
                animators.add(profileSet);
            }
            if (animators.size() > 0) {
                AnimatorSet set = new AnimatorSet();
                set.playTogether(animators);
                set.setDuration((long)this.getResources().getInteger(R.integer.md_profile_switching_anim_time));
                textSet.setDuration((long)(this.getResources().getInteger(R.integer.md_profile_switching_anim_time) / 2));
                profileSet.setDuration((long)(this.getResources().getInteger(R.integer.md_profile_switching_anim_time) / 2));
                for (Animator.AnimatorListener animatorListener : listeners) {
                    set.addListener(animatorListener);
                }
                set.start();
            }
        }
    }

    private void toggleProfileList() {
        if (this.loggingEnabled) {
            Log.d((String)TAG, (String)"toggleProfileList()");
        }
        if (this.profileListOpen) {
            this.closeProfileList();
        } else {
            this.openProfileList();
        }
    }

    private void openProfileList() {
        if (this.loggingEnabled) {
            Log.d((String)TAG, (String)"openProfileList()");
        }
        if (!this.profileListOpen) {
            AnimatorSet set = new AnimatorSet();
            set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)((Object)this.linearListView), (String)"alpha", (float[])new float[]{1.0f, 0.0f, 0.0f, 0.0f}), ObjectAnimator.ofFloat((Object)((Object)this.linearListView), (String)"translationY", (float[])new float[]{0.0f, this.getResources().getDimensionPixelSize(R.dimen.md_list_item_height) / 4}), ObjectAnimator.ofFloat((Object)((Object)this.linearListViewProfileList), (String)"alpha", (float[])new float[]{0.0f, 1.0f}), ObjectAnimator.ofFloat((Object)((Object)this.linearListViewProfileList), (String)"translationY", (float[])new float[]{-this.getResources().getDimensionPixelSize(R.dimen.md_list_item_height) / 2, 0.0f}), ObjectAnimator.ofInt((Object)this.imageViewOpenProfileListIcon.getDrawable(), PROPERTY_LEVEL, (int[])new int[]{0, 10000}), ObjectAnimator.ofInt((Object)this.scrollView, PROPERTY_SCROLL_POSITION, (int[])new int[]{0})});
            set.setDuration((long)this.getResources().getInteger(R.integer.md_profile_list_open_anim_time));
            set.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                    DrawerView.this.linearListViewProfileList.setVisibility(0);
                    DrawerView.this.imageViewOpenProfileListIcon.setClickable(false);
                }

                public void onAnimationEnd(Animator animation) {
                    DrawerView.this.imageViewOpenProfileListIcon.setClickable(true);
                    DrawerView.this.profileListOpen = true;
                    DrawerView.this.updateListVisibility();
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            set.start();
        } else {
            this.updateListVisibility();
        }
    }

    private void closeProfileList() {
        if (this.loggingEnabled) {
            Log.d((String)TAG, (String)"closeProfileList()");
        }
        if (this.profileListOpen) {
            AnimatorSet set = new AnimatorSet();
            set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)((Object)this.linearListViewProfileList), (String)"alpha", (float[])new float[]{1.0f, 0.0f, 0.0f, 0.0f}), ObjectAnimator.ofFloat((Object)((Object)this.linearListViewProfileList), (String)"translationY", (float[])new float[]{0.0f, -this.getResources().getDimensionPixelSize(R.dimen.md_list_item_height) / 4}), ObjectAnimator.ofFloat((Object)((Object)this.linearListView), (String)"alpha", (float[])new float[]{0.0f, 1.0f}), ObjectAnimator.ofFloat((Object)((Object)this.linearListView), (String)"translationY", (float[])new float[]{this.getResources().getDimensionPixelSize(R.dimen.md_list_item_height) / 2, 0.0f}), ObjectAnimator.ofInt((Object)this.imageViewOpenProfileListIcon.getDrawable(), PROPERTY_LEVEL, (int[])new int[]{10000, 0}), ObjectAnimator.ofInt((Object)this.scrollView, PROPERTY_SCROLL_POSITION, (int[])new int[]{0})});
            set.setDuration((long)this.getResources().getInteger(R.integer.md_profile_list_open_anim_time));
            set.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                    DrawerView.this.linearListView.setVisibility(0);
                    DrawerView.this.imageViewOpenProfileListIcon.setClickable(false);
                }

                public void onAnimationEnd(Animator animation) {
                    DrawerView.this.imageViewOpenProfileListIcon.setClickable(true);
                    DrawerView.this.profileListOpen = false;
                    DrawerView.this.updateListVisibility();
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            set.start();
        } else {
            this.updateListVisibility();
        }
    }

    public boolean getLoggingEnabled() {
        return this.loggingEnabled;
    }

    public DrawerView setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
        return this;
    }

    public DrawerView resetDrawerTheme() {
        this.drawerTheme = new DrawerTheme(this.getContext());
        this.updateTheme();
        return this;
    }

    public DrawerTheme getDrawerTheme() {
        return this.drawerTheme;
    }

    public DrawerView setDrawerTheme(DrawerTheme theme) {
        this.drawerTheme = theme;
        this.updateTheme();
        return this;
    }

    public DrawerView setDrawerMaxWidthResource(int drawerMaxWidthResource) {
        this.drawerMaxWidth = this.getResources().getDimensionPixelSize(drawerMaxWidthResource);
        this.updateDrawerWidth();
        return this;
    }

    public DrawerView resetDrawerMaxWidth() {
        this.drawerMaxWidth = this.getResources().getDimensionPixelSize(R.dimen.md_drawer_max_width);
        this.updateDrawerWidth();
        return this;
    }

    public int getDrawerMaxWidth() {
        return this.drawerMaxWidth;
    }

    public DrawerView setDrawerMaxWidth(int drawerMaxWidth) {
        this.drawerMaxWidth = drawerMaxWidth;
        this.updateDrawerWidth();
        return this;
    }

    public DrawerView addProfile(DrawerProfile profile) {
        if (profile.getId() <= 0L) {
            profile.setId(System.nanoTime() * 100L + Math.round(Math.random() * 100.0));
        }
        for (DrawerProfile oldProfile : this.mProfileAdapter.getItems()) {
            if (oldProfile.getId() != profile.getId()) continue;
            this.mProfileAdapter.remove(oldProfile);
            break;
        }
        profile.attachTo(this);
        this.mProfileAdapter.add(profile);
        if (this.mProfileAdapter.getCount() == 1) {
            this.selectProfile(profile);
        }
        this.updateProfile();
        return this;
    }

    public List<DrawerProfile> getProfiles() {
        return this.mProfileAdapter.getItems();
    }

    public DrawerProfile findProfileById(long id2) {
        for (DrawerProfile profile : this.mProfileAdapter.getItems()) {
            if (profile.getId() != id2) continue;
            return profile;
        }
        return null;
    }

    public DrawerView selectProfile(DrawerProfile profile) {
        if (this.mProfileAdapter.getItems().contains(profile)) {
            DrawerProfile oldProfile = (DrawerProfile)this.mProfileAdapter.getItem(0);
            if (this.mProfileAdapter.getCount() > 1) {
                this.closeProfileList();
                this.animateToProfile(profile);
                this.mProfileAdapter.remove(profile);
                this.mProfileAdapter.insert(profile, 0);
            } else {
                this.mProfileAdapter.remove(profile);
                this.mProfileAdapter.insert(profile, 0);
                if (this.hasOnProfileSwitchListener()) {
                    this.onProfileSwitchListener.onSwitch(oldProfile, oldProfile.getId(), profile, profile.getId());
                }
            }
        }
        return this;
    }

    public DrawerView selectProfileById(long id2) {
        for (DrawerProfile profile : this.mProfileAdapter.getItems()) {
            if (profile.getId() != id2) continue;
            this.selectProfile(profile);
            return this;
        }
        return this;
    }

    public DrawerView removeProfile(DrawerProfile profile) {
        profile.detach();
        this.mProfileAdapter.remove(profile);
        this.updateProfile();
        return this;
    }

    public DrawerView removeProfileById(long id2) {
        for (DrawerProfile profile : this.mProfileAdapter.getItems()) {
            if (profile.getId() != id2) continue;
            profile.detach();
            this.mProfileAdapter.remove(profile);
            this.updateProfile();
            return this;
        }
        return this;
    }

    public DrawerView clearProfiles() {
        for (DrawerProfile profile : this.mProfileAdapter.getItems()) {
            profile.detach();
        }
        this.mProfileAdapter.clear();
        this.updateProfile();
        return this;
    }

    public DrawerProfile.OnProfileClickListener getOnProfileClickListener() {
        return this.onProfileClickListener;
    }

    public DrawerView setOnProfileClickListener(DrawerProfile.OnProfileClickListener listener) {
        this.onProfileClickListener = listener;
        return this;
    }

    public boolean hasOnProfileClickListener() {
        return this.onProfileClickListener != null;
    }

    public DrawerView removeOnProfileClickListener() {
        this.onProfileClickListener = null;
        return this;
    }

    public DrawerProfile.OnProfileSwitchListener getOnProfileSwitchListener() {
        return this.onProfileSwitchListener;
    }

    public DrawerView setOnProfileSwitchListener(DrawerProfile.OnProfileSwitchListener listener) {
        this.onProfileSwitchListener = listener;
        return this;
    }

    public boolean hasOnProfileSwitchListener() {
        return this.onProfileSwitchListener != null;
    }

    public DrawerView removeOnProfileSwitchListener() {
        this.onProfileSwitchListener = null;
        return this;
    }

    public DrawerView addItems(List<DrawerItem> items) {
        this.mAdapter.setNotifyOnChange(false);
        for (DrawerItem item : items) {
            if (item.getId() <= 0L) {
                item.setId(System.nanoTime() * 100L + Math.round(Math.random() * 100.0));
            }
            for (DrawerItem oldItem : this.mAdapter.getItems()) {
                if (oldItem.getId() != item.getId()) continue;
                this.mAdapter.remove(oldItem);
                break;
            }
            item.attachTo(this.mAdapter);
            this.mAdapter.add(item);
        }
        this.mAdapter.setNotifyOnChange(true);
        this.mAdapter.notifyDataSetChanged();
        this.updateList();
        return this;
    }

    public DrawerView addItems(DrawerItem ... items) {
        this.mAdapter.setNotifyOnChange(false);
        for (DrawerItem item : items) {
            if (item.getId() <= 0L) {
                item.setId(System.nanoTime() * 100L + Math.round(Math.random() * 100.0));
            }
            for (DrawerItem oldItem : this.mAdapter.getItems()) {
                if (oldItem.getId() != item.getId()) continue;
                this.mAdapter.remove(oldItem);
                break;
            }
            item.attachTo(this.mAdapter);
            this.mAdapter.add(item);
        }
        this.mAdapter.setNotifyOnChange(true);
        this.mAdapter.notifyDataSetChanged();
        this.updateList();
        return this;
    }

    public DrawerView addItem(DrawerItem item) {
        if (item.getId() <= 0L) {
            item.setId(System.nanoTime() * 100L + Math.round(Math.random() * 100.0));
        }
        for (DrawerItem oldItem : this.mAdapter.getItems()) {
            if (oldItem.getId() != item.getId()) continue;
            this.mAdapter.remove(oldItem);
            break;
        }
        item.attachTo(this.mAdapter);
        this.mAdapter.add(item);
        this.updateList();
        return this;
    }

    public DrawerView addDivider() {
        this.addItem(new DrawerHeaderItem());
        return this;
    }

    public List<DrawerItem> getItems() {
        return this.mAdapter.getItems();
    }

    public DrawerItem getItem(int position) {
        return (DrawerItem)this.mAdapter.getItem(position);
    }

    public DrawerItem findItemById(long id2) {
        for (DrawerItem item : this.mAdapter.getItems()) {
            if (item.getId() != id2) continue;
            return item;
        }
        return null;
    }

    public DrawerView selectItem(int position) {
        this.mAdapterFixed.clearSelection();
        this.mAdapter.select(position);
        return this;
    }

    public int getSelectedPosition() {
        return this.mAdapter.getSelectedPosition();
    }

    public DrawerView selectItemById(long id2) {
        this.mAdapterFixed.clearSelection();
        int count = this.mAdapter.getCount();
        for (int i = 0; i < count; ++i) {
            if (((DrawerItem)this.mAdapter.getItem(i)).getId() != id2) continue;
            this.mAdapter.select(i);
            return this;
        }
        return this;
    }

    public DrawerView removeItem(DrawerItem item) {
        item.detach();
        this.mAdapter.remove(item);
        this.updateList();
        return this;
    }

    public DrawerView removeItem(int position) {
        ((DrawerItem)this.mAdapter.getItem(position)).detach();
        this.mAdapter.remove(this.mAdapter.getItem(position));
        this.updateList();
        return this;
    }

    public DrawerView removeItemById(long id2) {
        for (DrawerItem item : this.mAdapter.getItems()) {
            if (item.getId() != id2) continue;
            this.mAdapter.remove(item);
            this.updateList();
            return this;
        }
        return this;
    }

    public DrawerView clearItems() {
        for (DrawerItem item : this.mAdapter.getItems()) {
            item.detach();
        }
        this.mAdapter.clear();
        this.updateList();
        return this;
    }

    public DrawerItem.OnItemClickListener getOnItemClickListener() {
        return this.mOnItemClickListener;
    }

    public DrawerView setOnItemClickListener(DrawerItem.OnItemClickListener listener) {
        this.mOnItemClickListener = listener;
        return this;
    }

    public boolean hasOnItemClickListener() {
        return this.mOnItemClickListener != null;
    }

    public DrawerView removeOnItemClickListener() {
        this.mOnItemClickListener = null;
        return this;
    }

    public DrawerView addFixedItems(List<DrawerItem> items) {
        this.mAdapterFixed.setNotifyOnChange(false);
        for (DrawerItem item : items) {
            if (item.getId() <= 0L) {
                item.setId(System.nanoTime() * 100L + Math.round(Math.random() * 100.0));
            }
            for (DrawerItem oldItem : this.mAdapterFixed.getItems()) {
                if (oldItem.getId() != item.getId()) continue;
                this.mAdapterFixed.remove(oldItem);
                break;
            }
            item.attachTo(this.mAdapterFixed);
            this.mAdapterFixed.add(item);
        }
        this.mAdapterFixed.setNotifyOnChange(true);
        this.mAdapterFixed.notifyDataSetChanged();
        this.updateFixedList();
        return this;
    }

    public DrawerView addFixedItems(DrawerItem ... items) {
        this.mAdapterFixed.setNotifyOnChange(false);
        for (DrawerItem item : items) {
            if (item.getId() <= 0L) {
                item.setId(System.nanoTime() * 100L + Math.round(Math.random() * 100.0));
            }
            for (DrawerItem oldItem : this.mAdapterFixed.getItems()) {
                if (oldItem.getId() != item.getId()) continue;
                this.mAdapterFixed.remove(oldItem);
                break;
            }
            item.attachTo(this.mAdapterFixed);
            this.mAdapterFixed.add(item);
        }
        this.mAdapterFixed.setNotifyOnChange(true);
        this.mAdapterFixed.notifyDataSetChanged();
        this.updateFixedList();
        return this;
    }

    public DrawerView addFixedItem(DrawerItem item) {
        if (item.getId() <= 0L) {
            item.setId(System.nanoTime() * 100L + Math.round(Math.random() * 100.0));
        }
        for (DrawerItem oldItem : this.mAdapterFixed.getItems()) {
            if (oldItem.getId() != item.getId()) continue;
            this.mAdapterFixed.remove(oldItem);
            break;
        }
        item.attachTo(this.mAdapterFixed);
        this.mAdapterFixed.add(item);
        this.updateFixedList();
        return this;
    }

    public DrawerView addFixedDivider() {
        this.addFixedItem(new DrawerHeaderItem());
        return this;
    }

    public List<DrawerItem> getFixedItems() {
        return this.mAdapterFixed.getItems();
    }

    public DrawerItem getFixedItem(int position) {
        return (DrawerItem)this.mAdapterFixed.getItem(position);
    }

    public DrawerItem findFixedItemById(long id2) {
        for (DrawerItem item : this.mAdapterFixed.getItems()) {
            if (item.getId() != id2) continue;
            return item;
        }
        return null;
    }

    public DrawerView selectFixedItem(int position) {
        this.mAdapter.clearSelection();
        this.mAdapterFixed.select(position);
        return this;
    }

    public int getSelectedFixedPosition() {
        return this.mAdapterFixed.getSelectedPosition();
    }

    public DrawerView selectFixedItemById(long id2) {
        this.mAdapter.clearSelection();
        int count = this.mAdapterFixed.getCount();
        for (int i = 0; i < count; ++i) {
            if (((DrawerItem)this.mAdapterFixed.getItem(i)).getId() != id2) continue;
            this.mAdapterFixed.select(i);
            return this;
        }
        return this;
    }

    public DrawerView removeFixedItem(DrawerItem item) {
        item.detach();
        this.mAdapterFixed.remove(item);
        this.updateFixedList();
        return this;
    }

    public DrawerView removeFixedItem(int position) {
        ((DrawerItem)this.mAdapterFixed.getItem(position)).detach();
        this.mAdapterFixed.remove(this.mAdapterFixed.getItem(position));
        this.updateFixedList();
        return this;
    }

    public DrawerView removeFixedItemById(long id2) {
        for (DrawerItem item : this.mAdapterFixed.getItems()) {
            if (item.getId() != id2) continue;
            this.mAdapterFixed.remove(item);
            this.updateFixedList();
            return this;
        }
        return this;
    }

    public DrawerView clearFixedItems() {
        for (DrawerItem item : this.mAdapterFixed.getItems()) {
            item.detach();
        }
        this.mAdapterFixed.clear();
        this.updateFixedList();
        return this;
    }

    public DrawerItem.OnItemClickListener getOnFixedItemClickListener() {
        return this.mOnFixedItemClickListener;
    }

    public DrawerView setOnFixedItemClickListener(DrawerItem.OnItemClickListener listener) {
        this.mOnFixedItemClickListener = listener;
        return this;
    }

    public boolean hasOnFixedItemClickListener() {
        return this.mOnFixedItemClickListener != null;
    }

    public DrawerView removeOnFixedItemClickListener() {
        this.mOnFixedItemClickListener = null;
        return this;
    }

    @Override
    public void onInsetsChanged(Rect insets) {
        if (this.loggingEnabled) {
            Log.d((String)TAG, (String)"onInsetsChanged()");
        }
        if (this.statusBarHeight != insets.top) {
            this.statusBarHeight = insets.top;
            this.updateProfileSpacing();
        }
    }

    protected void onSizeChanged(int w, int h, int oldW, int oldH) {
        if (this.loggingEnabled) {
            Log.d((String)TAG, (String)("onSizeChanged(" + w + ", " + h + ", " + oldW + ", " + oldH + ")"));
        }
        super.onSizeChanged(w, h, oldW, oldH);
        if (w != oldW) {
            if (oldW == 0) {
                this.isInViewHierarchy = true;
                this.updateListVisibility();
                this.updateProfile();
            }
            if (this.drawerMaxWidth <= 0) {
                if (this.getLayoutParams().width != -1 && this.getLayoutParams().width != -2) {
                    this.setDrawerMaxWidth(this.getLayoutParams().width);
                } else {
                    this.resetDrawerMaxWidth();
                }
            }
            this.updateDrawerWidth();
        }
    }

    public Parcelable onSaveInstanceState() {
        if (this.loggingEnabled) {
            Log.d((String)TAG, (String)"onSaveInstanceState()");
        }
        Bundle savedInstanceState = new Bundle();
        savedInstanceState.putParcelable("instanceState", super.onSaveInstanceState());
        savedInstanceState.putBoolean(STATE_PROFILE_LIST_OPEN, this.profileListOpen);
        savedInstanceState.putInt(STATE_LIST_SELECTION, this.mAdapter.getSelectedPosition());
        savedInstanceState.putInt(STATE_FIXED_LIST_SELECTION, this.mAdapterFixed.getSelectedPosition());
        return savedInstanceState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (this.loggingEnabled) {
            Log.d((String)TAG, (String)"onRestoreInstanceState()");
        }
        if (state instanceof Bundle) {
            Bundle savedInstanceState = (Bundle)state;
            if (savedInstanceState.containsKey(STATE_PROFILE_LIST_OPEN)) {
                if (savedInstanceState.getBoolean(STATE_PROFILE_LIST_OPEN, false)) {
                    this.openProfileList();
                } else {
                    this.closeProfileList();
                }
            } else {
                this.closeProfileList();
            }
            if (savedInstanceState.containsKey(STATE_LIST_SELECTION)) {
                int fixedListSelection;
                int listSelection = savedInstanceState.getInt(STATE_LIST_SELECTION, -1);
                if (listSelection >= 0 && listSelection < this.mAdapter.getCount()) {
                    this.selectItem(listSelection);
                } else if (savedInstanceState.containsKey(STATE_FIXED_LIST_SELECTION) && (fixedListSelection = savedInstanceState.getInt(STATE_FIXED_LIST_SELECTION, -1)) >= 0 && fixedListSelection < this.mAdapterFixed.getCount()) {
                    this.selectFixedItem(fixedListSelection);
                }
            }
            state = savedInstanceState.getParcelable("instanceState");
        }
        super.onRestoreInstanceState(state);
    }
}

