/*
 * Decompiled with CFR 0.152.
 */
package com.heinrichreimersoftware.materialdrawer;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.widget.DrawerLayout;
import android.support.v7.app.ActionBarDrawerToggle;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.heinrichreimersoftware.materialdrawer.DrawerFrameLayout;
import com.heinrichreimersoftware.materialdrawer.R;
import com.heinrichreimersoftware.materialdrawer.structure.DrawerFragmentItem;
import com.heinrichreimersoftware.materialdrawer.structure.DrawerItem;
import com.heinrichreimersoftware.materialdrawer.structure.DrawerProfile;
import com.heinrichreimersoftware.materialdrawer.theme.DrawerTheme;
import java.util.List;

@SuppressLint(value={"Registered"})
public class DrawerActivity
extends AppCompatActivity {
    private DrawerFrameLayout mDrawer;
    private Toolbar mDefaultToolbar;
    private FrameLayout mFrame;
    private ActionBarDrawerToggle mDrawerToggle;
    private DrawerItem.OnItemClickListener mOnItemClickListener;
    private DrawerItem.OnItemClickListener mOnFixedItemClickListener;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        super.setContentView(R.layout.md_drawer_activity);
        this.mDrawer = (DrawerFrameLayout)this.findViewById(R.id.mdDrawerLayout);
        this.mDefaultToolbar = (Toolbar)this.findViewById(R.id.mdToolbar);
        this.mFrame = (FrameLayout)this.findViewById(R.id.mdFrame);
        this.setSupportActionBar(this.mDefaultToolbar);
        this.mDrawer.closeDrawer();
    }

    public void setSupportActionBar(@Nullable Toolbar toolbar) {
        if (toolbar != null) {
            if (toolbar != this.mDefaultToolbar && this.mDefaultToolbar.getVisibility() != 8) {
                this.mDefaultToolbar.setVisibility(8);
            }
            super.setSupportActionBar(toolbar);
            this.mDrawerToggle = new ActionBarDrawerToggle((Activity)this, this.mDrawer, toolbar, R.string.md_content_description_drawer_open, R.string.md_content_description_drawer_close){

                public void onDrawerClosed(View view) {
                    DrawerActivity.this.invalidateOptionsMenu();
                }

                public void onDrawerOpened(View drawerView) {
                    DrawerActivity.this.invalidateOptionsMenu();
                }
            };
            this.mDrawerToggle.syncState();
            this.mDrawer.addDrawerListener((DrawerLayout.DrawerListener)this.mDrawerToggle);
            this.mDrawer.setOnItemClickListener(new DrawerItem.OnItemClickListener(){

                @Override
                public void onClick(DrawerItem item, long id2, int position) {
                    if (item instanceof DrawerFragmentItem && ((DrawerFragmentItem)item).hasFragment()) {
                        DrawerActivity.this.switchFragment(((DrawerFragmentItem)item).getFragment());
                    }
                    if (item.hasOnItemClickListener()) {
                        item.getOnItemClickListener().onClick(item, id2, position);
                    } else if (DrawerActivity.this.hasOnItemClickListener()) {
                        DrawerActivity.this.mOnItemClickListener.onClick(item, id2, position);
                    }
                }
            });
            this.mDrawer.setOnFixedItemClickListener(new DrawerItem.OnItemClickListener(){

                @Override
                public void onClick(DrawerItem item, long id2, int position) {
                    if (item instanceof DrawerFragmentItem && ((DrawerFragmentItem)item).hasFragment()) {
                        DrawerActivity.this.switchFragment(((DrawerFragmentItem)item).getFragment());
                    }
                    if (item.hasOnItemClickListener()) {
                        item.getOnItemClickListener().onClick(item, id2, position);
                    } else if (DrawerActivity.this.hasOnItemClickListener()) {
                        DrawerActivity.this.mOnFixedItemClickListener.onClick(item, id2, position);
                    }
                }
            });
        }
    }

    private void switchFragment(Fragment fragment) {
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        if (fragmentManager.findFragmentById(R.id.mdFrame) == fragment) {
            return;
        }
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        fragmentTransaction.setTransition(0);
        if (fragmentManager.findFragmentById(R.id.mdFrame) != null) {
            fragmentTransaction.replace(R.id.mdFrame, fragment);
        } else {
            ((ViewGroup)this.findViewById(R.id.mdFrame)).removeAllViews();
            fragmentTransaction.add(R.id.mdFrame, fragment);
        }
        fragmentTransaction.commit();
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        return this.mDrawerToggle.onOptionsItemSelected(item) || super.onOptionsItemSelected(item);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mDrawerToggle.onConfigurationChanged(newConfig);
    }

    protected void onPostCreate(Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        this.mDrawerToggle.syncState();
    }

    public void setContentView(int layoutResID) {
        this.mFrame.removeAllViews();
        View.inflate((Context)this, (int)layoutResID, (ViewGroup)this.mFrame);
    }

    public void setContentView(View view) {
        this.mFrame.removeAllViews();
        this.mFrame.addView(view);
    }

    public void setContentView(View view, ViewGroup.LayoutParams params) {
        this.mFrame.removeAllViews();
        this.mFrame.addView(view, params);
    }

    public void addContentView(View view, ViewGroup.LayoutParams params) {
        this.mFrame.addView(view, params);
    }

    public boolean isDrawerIndicatorEnabled() {
        return this.mDrawerToggle != null && this.mDrawerToggle.isDrawerIndicatorEnabled();
    }

    public DrawerActivity setDrawerIndicatorEnabled(boolean enabled) {
        if (this.mDrawerToggle != null) {
            this.mDrawerToggle.setDrawerIndicatorEnabled(enabled);
        }
        return this;
    }

    public void setHomeAsUpIndicator(Drawable indicator) {
        if (this.mDrawerToggle != null) {
            this.mDrawerToggle.setHomeAsUpIndicator(indicator);
        }
    }

    public void setHomeAsUpIndicator(int resId) {
        if (this.mDrawerToggle != null) {
            this.mDrawerToggle.setHomeAsUpIndicator(resId);
        }
    }

    public View.OnClickListener getToolbarNavigationClickListener() {
        if (this.mDrawerToggle != null) {
            return this.mDrawerToggle.getToolbarNavigationClickListener();
        }
        return null;
    }

    public void setToolbarNavigationClickListener(View.OnClickListener listener) {
        if (this.mDrawerToggle != null) {
            this.mDrawerToggle.setToolbarNavigationClickListener(listener);
        }
    }

    public boolean getLoggingEnabled() {
        return this.mDrawer.getLoggingEnabled();
    }

    public DrawerActivity setLoggingEnabled(boolean loggingEnabled) {
        this.mDrawer.setLoggingEnabled(loggingEnabled);
        return this;
    }

    public DrawerActivity resetDrawerTheme() {
        this.mDrawer.resetDrawerTheme();
        return this;
    }

    public DrawerTheme getDrawerTheme() {
        return this.mDrawer.getDrawerTheme();
    }

    public DrawerActivity setDrawerTheme(DrawerTheme theme) {
        this.mDrawer.setDrawerTheme(theme);
        return this;
    }

    public DrawerActivity setDrawerMaxWidthResource(int drawerMaxWidthResource) {
        this.mDrawer.setDrawerMaxWidthResource(drawerMaxWidthResource);
        return this;
    }

    public DrawerActivity resetDrawerMaxWidth() {
        this.mDrawer.resetDrawerMaxWidth();
        return this;
    }

    public int getDrawerMaxWidth() {
        return this.mDrawer.getDrawerMaxWidth();
    }

    public DrawerActivity setDrawerMaxWidth(int drawerMaxWidth) {
        this.mDrawer.setDrawerMaxWidth(drawerMaxWidth);
        return this;
    }

    public DrawerActivity addProfile(DrawerProfile profile) {
        this.mDrawer.addProfile(profile);
        return this;
    }

    public List<DrawerProfile> getProfiles() {
        return this.mDrawer.getProfiles();
    }

    public DrawerProfile findProfileById(long id2) {
        return this.mDrawer.findProfileById(id2);
    }

    public DrawerActivity selectProfile(DrawerProfile profile) {
        this.mDrawer.selectProfile(profile);
        return this;
    }

    public DrawerActivity selectProfileById(long id2) {
        this.mDrawer.selectProfileById(id2);
        return this;
    }

    public DrawerActivity removeProfile(DrawerProfile profile) {
        this.mDrawer.removeProfile(profile);
        return this;
    }

    public DrawerActivity removeProfileById(long id2) {
        this.mDrawer.removeProfileById(id2);
        return this;
    }

    public DrawerActivity clearProfiles() {
        this.mDrawer.clearProfiles();
        return this;
    }

    public DrawerProfile.OnProfileClickListener getOnProfileClickListener() {
        return this.mDrawer.getOnProfileClickListener();
    }

    public DrawerActivity setOnProfileClickListener(DrawerProfile.OnProfileClickListener listener) {
        this.mDrawer.setOnProfileClickListener(listener);
        return this;
    }

    public boolean hasOnProfileClickListener() {
        return this.mDrawer.hasOnProfileClickListener();
    }

    public DrawerActivity removeOnProfileClickListener() {
        this.mDrawer.removeOnProfileClickListener();
        return this;
    }

    public DrawerProfile.OnProfileSwitchListener getOnProfileSwitchListener() {
        return this.mDrawer.getOnProfileSwitchListener();
    }

    public DrawerActivity setOnProfileSwitchListener(DrawerProfile.OnProfileSwitchListener listener) {
        this.mDrawer.setOnProfileSwitchListener(listener);
        return this;
    }

    public boolean hasOnProfileSwitchListener() {
        return this.mDrawer.hasOnProfileSwitchListener();
    }

    public DrawerActivity removeOnProfileSwitchListener() {
        this.mDrawer.removeOnProfileSwitchListener();
        return this;
    }

    public DrawerActivity addItems(List<DrawerItem> items) {
        this.mDrawer.addItems(items);
        return this;
    }

    public DrawerActivity addItems(DrawerItem ... items) {
        this.mDrawer.addItems(items);
        return this;
    }

    public DrawerActivity addItem(DrawerItem item) {
        this.mDrawer.addItem(item);
        return this;
    }

    public DrawerActivity addDivider() {
        this.mDrawer.addDivider();
        return this;
    }

    public List<DrawerItem> getItems() {
        return this.mDrawer.getItems();
    }

    public DrawerItem getItem(int position) {
        return this.mDrawer.getItem(position);
    }

    public DrawerItem findItemById(long id2) {
        return this.mDrawer.findItemById(id2);
    }

    public void selectItem(int position) {
        this.mDrawer.selectItem(position);
    }

    public int getSelectedPosition() {
        return this.mDrawer.getSelectedPosition();
    }

    public void selectItemById(long id2) {
        this.mDrawer.selectItemById(id2);
    }

    public DrawerActivity removeItem(DrawerItem item) {
        this.mDrawer.removeItem(item);
        return this;
    }

    public DrawerActivity removeItem(int position) {
        this.mDrawer.removeItem(position);
        return this;
    }

    public DrawerActivity removeItemById(long id2) {
        this.mDrawer.removeItemById(id2);
        return this;
    }

    public DrawerActivity clearItems() {
        this.mDrawer.clearItems();
        return this;
    }

    public DrawerItem.OnItemClickListener getOnItemClickListener() {
        return this.mOnItemClickListener;
    }

    public DrawerActivity setOnItemClickListener(DrawerItem.OnItemClickListener listener) {
        this.mOnItemClickListener = listener;
        return this;
    }

    public boolean hasOnItemClickListener() {
        return this.mOnItemClickListener != null;
    }

    public DrawerActivity removeOnItemClickListener() {
        this.mOnItemClickListener = null;
        return this;
    }

    public DrawerActivity addFixedItems(List<DrawerItem> items) {
        this.mDrawer.addFixedItems(items);
        return this;
    }

    public DrawerActivity addFixedItems(DrawerItem ... items) {
        this.mDrawer.addFixedItems(items);
        return this;
    }

    public DrawerActivity addFixedItem(DrawerItem item) {
        this.mDrawer.addFixedItem(item);
        return this;
    }

    public DrawerActivity addFixedDivider() {
        this.mDrawer.addFixedDivider();
        return this;
    }

    public List<DrawerItem> getFixedItems() {
        return this.mDrawer.getFixedItems();
    }

    public DrawerItem getFixedItem(int position) {
        return this.mDrawer.getFixedItem(position);
    }

    public DrawerItem findFixedItemById(long id2) {
        return this.mDrawer.findFixedItemById(id2);
    }

    public void selectFixedItem(int position) {
        this.mDrawer.selectFixedItem(position);
    }

    public int getSelectedFixedPosition() {
        return this.mDrawer.getSelectedFixedPosition();
    }

    public void selectFixedItemById(long id2) {
        this.mDrawer.selectFixedItemById(id2);
    }

    public DrawerActivity removeFixedItem(DrawerItem item) {
        this.mDrawer.removeFixedItem(item);
        return this;
    }

    public DrawerActivity removeFixedItem(int position) {
        this.mDrawer.removeFixedItem(position);
        return this;
    }

    public DrawerActivity removeFixedItemById(long id2) {
        this.mDrawer.removeFixedItemById(id2);
        return this;
    }

    public DrawerActivity clearFixedItems() {
        this.mDrawer.clearFixedItems();
        return this;
    }

    public DrawerItem.OnItemClickListener getOnFixedItemClickListener() {
        return this.mOnFixedItemClickListener;
    }

    public DrawerActivity setOnFixedItemClickListener(DrawerItem.OnItemClickListener listener) {
        this.mOnFixedItemClickListener = listener;
        return this;
    }

    public boolean hasOnFixedItemClickListener() {
        return this.mOnFixedItemClickListener != null;
    }

    public DrawerActivity removeOnFixedItemClickListener() {
        this.mOnFixedItemClickListener = null;
        return this;
    }

    public void openDrawer() {
        this.mDrawer.openDrawer();
    }

    public void closeDrawer() {
        this.mDrawer.closeDrawer();
    }
}

