/*
 * Decompiled with CFR 0.152.
 */
package com.magnify.basea_dapter_library.recyclerview.support;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import com.magnify.basea_dapter_library.ViewHolder;
import com.magnify.basea_dapter_library.recyclerview.MultiItemCommonAdapter;
import com.magnify.basea_dapter_library.recyclerview.MultiItemTypeSupport;
import com.magnify.basea_dapter_library.recyclerview.support.SectionSupport;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class SectionAdapter<T>
extends MultiItemCommonAdapter<T> {
    private SectionSupport mSectionSupport;
    private static final int TYPE_SECTION = 0;
    private LinkedHashMap<String, Integer> mSections;
    private MultiItemTypeSupport<T> headerItemTypeSupport;
    final RecyclerView.AdapterDataObserver observer = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            super.onChanged();
            SectionAdapter.this.findSections();
        }
    };

    @Override
    public int getItemViewType(int position) {
        return this.mMultiItemTypeSupport.getItemViewType(position, null);
    }

    public SectionAdapter(Context context, int layoutId, List<T> datas, SectionSupport sectionSupport) {
        this(context, layoutId, null, datas, sectionSupport);
    }

    public SectionAdapter(Context context, MultiItemTypeSupport multiItemTypeSupport, List<T> datas, SectionSupport sectionSupport) {
        this(context, -1, multiItemTypeSupport, datas, sectionSupport);
    }

    public SectionAdapter(Context context, int layoutId, MultiItemTypeSupport multiItemTypeSupport, List<T> datas, SectionSupport sectionSupport) {
        super(context, datas, null);
        this.mLayoutId = layoutId;
        this.initMulitiItemTypeSupport(layoutId, multiItemTypeSupport);
        this.mMultiItemTypeSupport = this.headerItemTypeSupport;
        this.mSectionSupport = sectionSupport;
        this.mSections = new LinkedHashMap();
        this.findSections();
        this.registerAdapterDataObserver(this.observer);
    }

    private void initMulitiItemTypeSupport(int layoutId, final MultiItemTypeSupport multiItemTypeSupport) {
        if (layoutId != -1) {
            this.headerItemTypeSupport = new MultiItemTypeSupport<T>(){

                @Override
                public int getLayoutId(int itemType) {
                    if (itemType == 0) {
                        return SectionAdapter.this.mSectionSupport.sectionHeaderLayoutId();
                    }
                    return SectionAdapter.this.mLayoutId;
                }

                @Override
                public int getItemViewType(int position, T o) {
                    int positionVal = SectionAdapter.this.getIndexForPosition(position);
                    return SectionAdapter.this.mSections.values().contains(position) ? 0 : 1;
                }
            };
        } else if (multiItemTypeSupport != null) {
            this.headerItemTypeSupport = new MultiItemTypeSupport<T>(){

                @Override
                public int getLayoutId(int itemType) {
                    if (itemType == 0) {
                        return SectionAdapter.this.mSectionSupport.sectionHeaderLayoutId();
                    }
                    return multiItemTypeSupport.getLayoutId(itemType);
                }

                @Override
                public int getItemViewType(int position, T o) {
                    int positionVal = SectionAdapter.this.getIndexForPosition(position);
                    return SectionAdapter.this.mSections.values().contains(position) ? 0 : multiItemTypeSupport.getItemViewType(positionVal, o);
                }
            };
        } else {
            throw new RuntimeException("layoutId or MultiItemTypeSupport must set one.");
        }
    }

    @Override
    protected boolean isEnabled(int viewType) {
        if (viewType == 0) {
            return false;
        }
        return super.isEnabled(viewType);
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
        this.unregisterAdapterDataObserver(this.observer);
    }

    public void findSections() {
        int n = this.mDatas.size();
        int nSections = 0;
        this.mSections.clear();
        for (int i = 0; i < n; ++i) {
            String sectionName = this.mSectionSupport.getTitle(this.mDatas.get(i));
            if (this.mSections.containsKey(sectionName)) continue;
            this.mSections.put(sectionName, i + nSections);
            ++nSections;
        }
    }

    @Override
    public int getItemCount() {
        return super.getItemCount() + this.mSections.size();
    }

    public int getIndexForPosition(int position) {
        int nSections = 0;
        Set<Map.Entry<String, Integer>> entrySet = this.mSections.entrySet();
        for (Map.Entry<String, Integer> entry : entrySet) {
            if (entry.getValue() >= position) continue;
            ++nSections;
        }
        return position - nSections;
    }

    @Override
    protected int getPosition(RecyclerView.ViewHolder viewHolder) {
        return this.getIndexForPosition(viewHolder.getAdapterPosition());
    }

    @Override
    public void onBindViewHolder(ViewHolder holder, int position) {
        position = this.getIndexForPosition(position);
        if (holder.getItemViewType() == 0) {
            holder.setText(this.mSectionSupport.sectionTitleTextViewId(), this.mSectionSupport.getTitle(this.mDatas.get(position)));
            return;
        }
        super.onBindViewHolder(holder, position);
    }
}

