/*
 * Decompiled with CFR 0.152.
 */
package com.magnify.basea_dapter_library.recyclerview;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import com.magnify.basea_dapter_library.ViewHolder;
import java.util.List;

public abstract class CommonMultiAdapter<T>
extends RecyclerView.Adapter<ViewHolder> {
    protected Context mContext;
    protected int[] mLayoutId;
    protected List<T> mDatas;
    protected LayoutInflater mInflater;

    public CommonMultiAdapter(Context context, List<T> datas, int ... layoutId) {
        this.mContext = context;
        this.mInflater = LayoutInflater.from((Context)context);
        this.mLayoutId = layoutId;
        this.mDatas = datas;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        ViewHolder viewHolder = ViewHolder.get(this.mContext, null, parent, this.mLayoutId[viewType], -1);
        viewHolder.setType(viewType);
        this.onPreCreate(viewHolder, viewType);
        Log.v((String)"AActivity", (String)("create time" + viewType));
        return viewHolder;
    }

    public int getItemViewType(int position) {
        return this.getItemViewType(this.mDatas.get(position));
    }

    protected abstract int getItemViewType(T var1);

    protected int getPosition(RecyclerView.ViewHolder viewHolder) {
        return viewHolder.getAdapterPosition();
    }

    protected boolean isEnabled(int viewType) {
        return true;
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        holder.updatePosition(position);
        this.converData(holder, holder.getType(), this.mDatas.get(position), position);
    }

    protected abstract void converData(ViewHolder var1, int var2, T var3, int var4);

    protected void onPreCreate(ViewHolder viewHolder, int itemType) {
    }

    public int getItemCount() {
        return this.mDatas == null ? 0 : this.mDatas.size();
    }
}

