/*
 * Decompiled with CFR 0.152.
 */
package com.magnify.basea_dapter_library.abslistview;

import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.magnify.basea_dapter_library.ViewHolder;
import java.util.LinkedList;
import java.util.List;

public abstract class InfiniteViewPagerAdapter<T>
extends PagerAdapter {
    private List<T> datas = null;
    private LinkedList<View> mViewCache = null;
    private Context mContext;
    private LayoutInflater mLayoutInflater = null;
    private int layoutId;

    public InfiniteViewPagerAdapter(List<T> datas, Context context, int layoutID) {
        this.datas = datas;
        this.mContext = context;
        this.mLayoutInflater = LayoutInflater.from((Context)this.mContext);
        this.mViewCache = new LinkedList();
        this.layoutId = layoutID;
    }

    public int getCount() {
        return this.datas == null || this.datas.isEmpty() ? 0 : (this.datas.size() == 1 ? 1 : Integer.MAX_VALUE);
    }

    public int getItemPosition(Object object) {
        return -2;
    }

    public Object instantiateItem(ViewGroup container, int position) {
        position %= this.datas.size();
        ViewHolder viewHolder = null;
        View convertView = null;
        if (this.mViewCache.size() == 0) {
            convertView = this.mLayoutInflater.inflate(this.layoutId, null, false);
            viewHolder = new ViewHolder(this.mContext, convertView, container, position);
            this.onPreCreate(viewHolder);
        } else {
            convertView = this.mViewCache.removeFirst();
            viewHolder = (ViewHolder)((Object)convertView.getTag());
            viewHolder.updatePosition(position);
        }
        this.convert(viewHolder, position, this.datas.get(position));
        container.addView(convertView, -1, -1);
        return convertView;
    }

    protected void onPreCreate(ViewHolder viewHolder) {
    }

    protected abstract void convert(ViewHolder var1, int var2, T var3);

    public void destroyItem(ViewGroup container, int position, Object object) {
        View contentView = (View)object;
        container.removeView(contentView);
        this.mViewCache.add(contentView);
    }

    public boolean isViewFromObject(View view, Object o) {
        return view == o;
    }
}

