/*
 * Decompiled with CFR 0.152.
 */
package com.magnify.basea_dapter_library.abslistview;

import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.magnify.basea_dapter_library.ViewHolder;
import com.magnify.basea_dapter_library.abslistview.PositionInfo;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public abstract class CommonShowChildViewPagerAdapter<P, C>
extends PagerAdapter {
    private List<P> folders = null;
    private List<C> datas = new ArrayList<C>();
    private int counter;
    private ArrayList<PositionInfo> positionInfos = new ArrayList();
    private LinkedList<View> mViewCache = null;
    private Context mContext;
    private LayoutInflater mLayoutInflater = null;
    private int layoutId;
    private int travseCount = 0;
    private boolean hasGoTheDefineMethod = false;

    public CommonShowChildViewPagerAdapter(List<P> datas, Context context, int layoutID) {
        this.folders = datas;
        this.mContext = context;
        this.mLayoutInflater = LayoutInflater.from((Context)this.mContext);
        this.mViewCache = new LinkedList();
        this.layoutId = layoutID;
        this.traverseDatas();
    }

    private void traverseDatas() {
        if (this.travseCount == 0) {
            this.positionInfos.clear();
            this.counter = 0;
            this.datas.clear();
        }
        for (int i = this.travseCount; i < this.folders.size(); ++i) {
            List<C> mImages = this.getChild(this.folders.get(i));
            if (mImages == null || mImages.isEmpty()) continue;
            this.positionInfos.add(new PositionInfo(mImages.size(), this.counter, i));
            this.counter += mImages.size();
            this.datas.addAll(mImages);
        }
    }

    protected abstract List<C> getChild(P var1);

    public int getCount() {
        return this.datas == null ? 0 : this.datas.size();
    }

    public int getItemPosition(Object object) {
        return super.getItemPosition(object);
    }

    public Object instantiateItem(ViewGroup container, int position) {
        ViewHolder viewHolder = null;
        View convertView = null;
        if (this.mViewCache.size() == 0) {
            convertView = this.mLayoutInflater.inflate(this.layoutId, null, false);
            viewHolder = new ViewHolder(this.mContext, convertView, container, position);
            this.onPreCreate(viewHolder, convertView);
        } else {
            convertView = this.mViewCache.removeFirst();
            viewHolder = (ViewHolder)((Object)convertView.getTag());
            viewHolder.updatePosition(position);
        }
        this.convert(viewHolder, position, this.getParent(position), this.datas.get(position));
        container.addView(convertView, -1, -1);
        return convertView;
    }

    protected void onPreCreate(ViewHolder viewHolder, View convertView) {
    }

    protected abstract void convert(ViewHolder var1, int var2, P var3, C var4);

    public void destroyItem(ViewGroup container, int position, Object object) {
        View contentView = (View)object;
        container.removeView(contentView);
        this.mViewCache.add(contentView);
    }

    public boolean isViewFromObject(View view, Object o) {
        return view == o;
    }

    private P getParent(int i) {
        P p = null;
        for (int i1 = 0; i1 < this.positionInfos.size(); ++i1) {
            PositionInfo positionInfo = this.positionInfos.get(i1);
            if (!positionInfo.isRange(i)) continue;
            p = this.folders.get(i1);
            break;
        }
        return p;
    }

    public void setDatas(List<P> mFolders) {
        this.folders = mFolders;
        this.travseCount = 0;
        this.hasGoTheDefineMethod = true;
        this.notifyDataSetChanged();
    }

    public void setDatas(P mFolder) {
        this.folders = new ArrayList<P>();
        this.folders.add(mFolder);
        this.travseCount = 0;
        this.hasGoTheDefineMethod = true;
        this.notifyDataSetChanged();
    }

    public void addDatas(List<P> mFolders) {
        this.travseCount = this.folders.size() - 1;
        if (mFolders != null && !mFolders.isEmpty()) {
            this.folders.addAll(mFolders);
        }
        this.hasGoTheDefineMethod = true;
        this.notifyDataSetChanged();
    }

    public void notifyDataSetChanged() {
        if (!this.hasGoTheDefineMethod) {
            this.travseCount = 0;
        }
        this.traverseDatas();
        super.notifyDataSetChanged();
    }
}

