/*
 * Decompiled with CFR 0.152.
 */
package com.magnify.basea_dapter_library.abslistview;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import android.widget.ExpandableListView;
import com.magnify.basea_dapter_library.ViewHolder;
import java.util.ArrayList;
import java.util.List;

public abstract class CommonExpandListViewAdapter<P, C>
extends BaseExpandableListAdapter {
    private List<P> parents;
    private Context mContext;
    private ExpandableListView expandableListView;
    private int parentLayoutId;
    private int childLayout;
    private boolean isExpandAll = false;

    public CommonExpandListViewAdapter(ExpandableListView expandableListView, ArrayList<P> parents, int groupLayout, int childLayout) {
        this.parents = parents;
        this.mContext = expandableListView.getContext();
        this.expandableListView = expandableListView;
        expandableListView.setGroupIndicator(null);
        this.parentLayoutId = groupLayout;
        this.childLayout = childLayout;
    }

    public int getGroupCount() {
        return this.parents == null ? 0 : this.parents.size();
    }

    public P getGroup(int groupPosition) {
        return this.parents.get(groupPosition);
    }

    public C getChild(int groupPosition, int childPosition) {
        P p = this.parents.get(groupPosition);
        return this.getChild(p, childPosition);
    }

    public long getGroupId(int groupPosition) {
        return groupPosition;
    }

    public long getChildId(int groupPosition, int childPosition) {
        return childPosition;
    }

    public boolean hasStableIds() {
        return false;
    }

    public View getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
        ViewHolder viewHolder = null;
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)this.mContext).inflate(this.parentLayoutId, null);
            viewHolder = new ViewHolder(this.mContext, convertView, parent, groupPosition);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)((Object)convertView.getTag());
        }
        this.convertGroup(viewHolder, groupPosition, isExpanded, this.getGroup(groupPosition));
        return convertView;
    }

    public View getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
        ViewHolder viewHolder = null;
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)this.mContext).inflate(this.childLayout, null);
            viewHolder = new ViewHolder(this.mContext, convertView, parent, groupPosition);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)((Object)convertView.getTag());
        }
        this.convertChild(viewHolder, childPosition, isLastChild, this.getChild((P)groupPosition, childPosition));
        return convertView;
    }

    public boolean isChildSelectable(int groupPosition, int childPosition) {
        return false;
    }

    protected abstract C getChild(P var1, int var2);

    public abstract int getChildrenCount(int var1);

    protected abstract void convertGroup(ViewHolder var1, int var2, boolean var3, P var4);

    protected abstract void convertChild(ViewHolder var1, int var2, boolean var3, C var4);

    public void addData(ArrayList<P> datas) {
        this.parents.addAll(datas);
        this.expandAll();
        this.notifyDataSetChanged();
    }

    private void expandAll() {
        if (this.isExpandAll) {
            for (int i = 0; i < this.parents.size(); ++i) {
                if (this.expandableListView.isGroupExpanded(i)) continue;
                this.expandableListView.expandGroup(i);
            }
        }
    }

    public void setExpandAll(boolean expandAll) {
        this.isExpandAll = expandAll;
        this.expandAll();
    }
}

