/*
 * Decompiled with CFR 0.152.
 */
package com.magnify.basea_dapter_library.abslistview;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.magnify.basea_dapter_library.ViewHolder;
import com.magnify.basea_dapter_library.abslistview.PositionInfo;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseShowChildAdapter<P, C>
extends BaseAdapter {
    private List<P> folders;
    private Context mContext;
    private List<C> datas = new ArrayList<C>();
    private ArrayList<PositionInfo> positionInfos = new ArrayList();
    private int counter;
    private int layoutID;
    private int travseCount = 0;
    private boolean hasGoTheDefineMethod = false;

    public BaseShowChildAdapter(List<P> folders, Context mContext, int layoutId) {
        this.folders = folders;
        this.mContext = mContext;
        this.layoutID = layoutId;
        this.positionInfos = new ArrayList();
        this.traverseDatas();
    }

    public List<P> getParentData() {
        return this.folders;
    }

    private void traverseDatas() {
        if (this.travseCount == 0) {
            this.positionInfos.clear();
            this.counter = 0;
            this.datas.clear();
        }
        for (int i = this.travseCount; i < this.folders.size(); ++i) {
            List<C> mImages = this.getChild(this.folders.get(i));
            if (mImages == null || mImages.isEmpty()) continue;
            this.positionInfos.add(new PositionInfo(mImages.size(), this.counter, i));
            this.counter += mImages.size();
            this.datas.addAll(mImages);
        }
    }

    protected abstract List<C> getChild(P var1);

    public int getCount() {
        return this.datas == null ? 0 : this.datas.size();
    }

    public C getItem(int i) {
        return this.datas.get(i);
    }

    public long getItemId(int i) {
        return i;
    }

    public View getView(int i, View view, ViewGroup viewGroup) {
        ViewHolder viewHolder = null;
        if (view == null) {
            view = LayoutInflater.from((Context)this.mContext).inflate(this.layoutID, null);
            viewHolder = new ViewHolder(this.mContext, view, viewGroup, i);
            view = viewHolder.getConvertView();
            this.onPreCreate(viewHolder, view);
        } else {
            viewHolder = (ViewHolder)((Object)view.getTag());
            viewHolder.updatePosition(i);
        }
        this.convert(viewHolder, view, i, this.getParent(i), this.getItem(i));
        return viewHolder.getConvertView();
    }

    protected void onPreCreate(ViewHolder viewHolder, View convertView) {
    }

    protected abstract void convert(ViewHolder var1, View var2, int var3, P var4, C var5);

    private P getParent(int i) {
        P p = null;
        for (int i1 = 0; i1 < this.positionInfos.size(); ++i1) {
            PositionInfo positionInfo = this.positionInfos.get(i1);
            if (!positionInfo.isRange(i)) continue;
            p = this.folders.get(i1);
            break;
        }
        return p;
    }

    private P getP(int i) {
        P p = null;
        PositionInfo positionInfo = this.positionInfos.get(i);
        if (positionInfo.isRange(i)) {
            p = this.folders.get(i);
        }
        return p;
    }

    public Context getContext() {
        return this.mContext;
    }

    public void setDatas(List<P> mFolders) {
        this.folders = mFolders;
        this.travseCount = 0;
        this.hasGoTheDefineMethod = true;
        this.notifyDataSetChanged();
    }

    public void setDatas(P mFolder) {
        this.folders = new ArrayList<P>();
        this.folders.add(mFolder);
        this.travseCount = 0;
        this.hasGoTheDefineMethod = true;
        this.notifyDataSetChanged();
    }

    public void addDatas(List<P> mFolders) {
        this.travseCount = this.folders.size() - 1;
        if (mFolders != null && !mFolders.isEmpty()) {
            this.folders.addAll(mFolders);
        }
        this.hasGoTheDefineMethod = true;
        this.notifyDataSetChanged();
    }

    public void notifyDataSetChanged() {
        if (!this.hasGoTheDefineMethod) {
            this.travseCount = 0;
        }
        this.traverseDatas();
        super.notifyDataSetChanged();
    }
}

