/*
 * Decompiled with CFR 0.152.
 */
package com.magnify.basea_dapter_library.abslistview;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.magnify.basea_dapter_library.ViewHolder;
import java.util.ArrayList;

public abstract class BaseMultiTypeAdapter<T>
extends BaseAdapter {
    private ArrayList<T> datas;
    private Context mContext;
    private int[] layoutids;
    private LayoutInflater inflater;
    private ViewHolder[] viewHolder;

    public BaseMultiTypeAdapter(Context context, ArrayList<T> datas, int ... layoutids) {
        this.datas = datas;
        this.mContext = context;
        this.layoutids = layoutids;
        this.viewHolder = new ViewHolder[layoutids.length];
        this.inflater = LayoutInflater.from((Context)context);
    }

    public int getViewTypeCount() {
        return this.layoutids == null ? 0 : this.layoutids.length;
    }

    public int getItemViewType(int position) {
        return this.getItemViewType(this.datas.get(position));
    }

    protected abstract int getItemViewType(T var1);

    public int getCount() {
        return this.datas == null ? 0 : this.datas.size();
    }

    public T getItem(int position) {
        return this.datas.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        int itemType = this.getItemViewType(position);
        if (convertView == null) {
            convertView = this.inflater.inflate(this.layoutids[itemType], null);
            this.viewHolder[itemType] = new ViewHolder(this.mContext, convertView, parent, position);
            this.onPreCreate(this.viewHolder[itemType], itemType);
            convertView.setTag(this.layoutids[itemType], (Object)this.viewHolder[itemType]);
        } else {
            this.viewHolder[itemType] = (ViewHolder)((Object)convertView.getTag(this.layoutids[itemType]));
        }
        this.converData(this.viewHolder[itemType], itemType, this.datas.get(position), position);
        return convertView;
    }

    protected void onPreCreate(ViewHolder viewHolder, int itemType) {
    }

    protected abstract void converData(ViewHolder var1, int var2, T var3, int var4);
}

