/*
 * Decompiled with CFR 0.152.
 */
package com.magnify.basea_dapter_library.abslistview;

import android.content.Context;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.magnify.basea_dapter_library.ViewHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class BaseHeaderChildFooterAdapter<HF, C>
extends BaseAdapter {
    private ArrayList<HF> groupDatas;
    private Context mContext;
    private int headerLayout = -1;
    private int childLayout;
    private int footerLayout = -1;
    private SparseArray<PositionInfo> positions = new SparseArray();
    private int positionCounter;
    private static final int TYPE_HEADER = 0;
    private static final int TYPE_CHILD = 1;
    private static final int TYPE_FOOTER = 2;
    private static final int TYPE_COUNT = 3;
    private LayoutInflater infalter;
    private int lastDataSize;
    private int traveseIndex = 0;
    private HashMap<String, Integer> groupPositions = new HashMap();

    public BaseHeaderChildFooterAdapter(Context mContext, ArrayList<HF> groupDatas, int headerLayout, int childLayout, int footerLayout) {
        this.groupDatas = groupDatas;
        this.mContext = mContext;
        this.headerLayout = headerLayout;
        this.childLayout = childLayout;
        this.footerLayout = footerLayout;
        this.infalter = LayoutInflater.from((Context)mContext);
        this.lastDataSize = groupDatas == null ? 0 : groupDatas.size();
        this.caculateTypePosition();
    }

    public BaseHeaderChildFooterAdapter(Context mContext, ArrayList<HF> groupDatas, int headerLayout, int childLayout) {
        this.groupDatas = groupDatas;
        this.mContext = mContext;
        this.headerLayout = headerLayout;
        this.childLayout = childLayout;
        this.infalter = LayoutInflater.from((Context)mContext);
        this.lastDataSize = groupDatas == null ? 0 : groupDatas.size();
        this.caculateTypePosition();
    }

    public BaseHeaderChildFooterAdapter(int footerLayout, Context mContext, ArrayList<HF> groupDatas, int childLayout) {
        this.groupDatas = groupDatas;
        this.mContext = mContext;
        this.footerLayout = footerLayout;
        this.childLayout = childLayout;
        this.infalter = LayoutInflater.from((Context)mContext);
        this.lastDataSize = groupDatas == null ? 0 : groupDatas.size();
        this.caculateTypePosition();
    }

    private void caculateTypePosition() {
        if (this.groupDatas != null && !this.groupDatas.isEmpty()) {
            for (int i = this.traveseIndex; i < this.groupDatas.size(); ++i) {
                if (this.headerLayout > 0) {
                    this.positions.put(this.positionCounter, (Object)new PositionInfo(i, 0));
                    String sortKey = this.getGroupSortKey(i, this.groupDatas.get(i));
                    if (!TextUtils.isEmpty((CharSequence)sortKey)) {
                        this.groupPositions.put(sortKey, this.positionCounter);
                    }
                    for (int j = 0; j < this.getChildCount(this.groupDatas.get(i), i); ++j) {
                        ++this.positionCounter;
                        this.positions.put(this.positionCounter, (Object)new PositionInfo(i, 1, j));
                    }
                    ++this.positionCounter;
                    if (this.footerLayout <= 0) continue;
                    this.positions.put(this.positionCounter, (Object)new PositionInfo(i, 2));
                    ++this.positionCounter;
                    continue;
                }
                for (int j = 0; j < this.getChildCount(this.groupDatas.get(i), i); ++j) {
                    this.positions.put(this.positionCounter, (Object)new PositionInfo(i, 1, j));
                    ++this.positionCounter;
                }
                this.positions.put(this.positionCounter, (Object)new PositionInfo(i, 2));
                ++this.positionCounter;
            }
        }
    }

    protected String getGroupSortKey(int groupPosition, HF hf) {
        return "";
    }

    protected String getChildName(int position, C c) {
        return "";
    }

    public void forceNotifyDataSetChanged() {
        this.lastDataSize = 0;
        this.traveseIndex = 0;
        this.positionCounter = 0;
        this.positions.clear();
        this.groupPositions.clear();
        this.caculateTypePosition();
        super.notifyDataSetChanged();
    }

    public void notifyDataSetChanged() {
        if (this.groupDatas == null) {
            return;
        }
        if (this.lastDataSize >= this.groupDatas.size()) {
            this.traveseIndex = 0;
            this.positionCounter = 0;
            this.positions.clear();
            this.groupPositions.clear();
        } else {
            this.traveseIndex = this.lastDataSize;
        }
        this.caculateTypePosition();
        super.notifyDataSetChanged();
    }

    public int getItemViewType(int position) {
        return ((PositionInfo)this.positions.get(position)).getType();
    }

    public int getViewTypeCount() {
        return 3;
    }

    public int getCount() {
        return this.positions.size();
    }

    public int getHeaderPositionAtListView(String sortKey) {
        if (this.groupPositions.containsKey(sortKey)) {
            return this.groupPositions.get(sortKey);
        }
        return -1;
    }

    public Object getItem(int position) {
        PositionInfo positionInfo = (PositionInfo)this.positions.get(position);
        int type = positionInfo.getType();
        if (type == 0 || type == 2) {
            return this.groupDatas.get(positionInfo.getGroupPosition());
        }
        return this.getChild(this.groupDatas.get(positionInfo.getGroupPosition()), positionInfo.getChildPosition());
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        int type = 0;
        ViewHolder headerHolder = null;
        ViewHolder childHolder = null;
        ViewHolder footerHolder = null;
        PositionInfo positionInfo = (PositionInfo)this.positions.get(position);
        int groupPosition = positionInfo.getGroupPosition();
        int childPosition = positionInfo.getChildPosition();
        type = positionInfo.getType();
        if (convertView == null) {
            switch (type) {
                case 0: {
                    convertView = this.infalter.inflate(this.headerLayout, null);
                    headerHolder = new ViewHolder(this.mContext, convertView, parent, groupPosition);
                    convertView.setTag(this.headerLayout, (Object)headerHolder);
                    break;
                }
                case 1: {
                    convertView = this.infalter.inflate(this.childLayout, null);
                    childHolder = new ViewHolder(this.mContext, convertView, parent, childPosition);
                    convertView.setTag(this.childLayout, (Object)childHolder);
                    this.onPreCreateChild(childHolder, convertView, position);
                    break;
                }
                case 2: {
                    convertView = this.infalter.inflate(this.footerLayout, null);
                    footerHolder = new ViewHolder(this.mContext, convertView, parent, groupPosition);
                    convertView.setTag(this.footerLayout, (Object)footerHolder);
                }
            }
        } else {
            switch (type) {
                case 0: {
                    headerHolder = (ViewHolder)((Object)convertView.getTag(this.headerLayout));
                    break;
                }
                case 1: {
                    childHolder = (ViewHolder)((Object)convertView.getTag(this.childLayout));
                    break;
                }
                case 2: {
                    footerHolder = (ViewHolder)((Object)convertView.getTag(this.footerLayout));
                }
            }
        }
        HF hf = this.groupDatas.get(groupPosition);
        switch (type) {
            case 0: {
                this.convertHeader(headerHolder, groupPosition, hf);
                break;
            }
            case 1: {
                this.convertChild(childHolder, groupPosition, childPosition, this.getChild(hf, childPosition), this.getChildCount(hf, groupPosition) == childPosition + 1);
                break;
            }
            case 2: {
                this.convertFooter(footerHolder, groupPosition, hf);
            }
        }
        return convertView;
    }

    public void removeChild(int groupPosition, int childPosition) {
        List<C> mChilds = this.getChilds(this.groupDatas.get(groupPosition), groupPosition);
        if (mChilds != null && !mChilds.isEmpty()) {
            mChilds.remove(childPosition);
            this.forceNotifyDataSetChanged();
        }
    }

    public void removeGroup(int groupPosition) {
        this.groupDatas.remove(groupPosition);
        this.forceNotifyDataSetChanged();
    }

    protected void onPreCreateChild(ViewHolder childHolder, View convertView, int position) {
    }

    protected abstract void convertChild(ViewHolder var1, int var2, int var3, C var4, boolean var5);

    protected abstract void convertFooter(ViewHolder var1, int var2, HF var3);

    protected abstract void convertHeader(ViewHolder var1, int var2, HF var3);

    protected abstract C getChild(HF var1, int var2);

    public abstract List<C> getChilds(HF var1, int var2);

    public int getChildCount(HF hf, int groupPosition) {
        List<C> mChilds = this.getChilds(hf, groupPosition);
        return mChilds == null ? 0 : mChilds.size();
    }

    public Context getContext() {
        return this.mContext;
    }

    public C getChild(int groupPosition, int childPosition) {
        return this.getChild(this.groupDatas.get(groupPosition), childPosition);
    }

    public int getChildPositionAtListView(String sortKey, String s) {
        if (TextUtils.isEmpty((CharSequence)sortKey) || TextUtils.isEmpty((CharSequence)s)) {
            return -1;
        }
        int position = this.getHeaderPositionAtListView(sortKey);
        for (int i = 0; i < this.groupDatas.size(); ++i) {
            HF hf = this.groupDatas.get(i);
            if (!sortKey.equals(this.getGroupSortKey(i, hf))) continue;
            for (int j = 0; j < this.getChildCount(hf, i); ++j) {
                C c = this.getChild(hf, j);
                String childName = this.getChildName(j, c);
                if (!childName.toLowerCase().contains(s.toLowerCase())) continue;
                return position + j + 1;
            }
        }
        return position;
    }

    public String getSortKeyAtPosition(int position) {
        PositionInfo positionInfo = (PositionInfo)this.positions.get(position);
        return this.getGroupSortKey(position, this.groupDatas.get(positionInfo.getGroupPosition()));
    }

    private class PositionInfo {
        private int type;
        private int groupPosition;
        private int childPosition = -1;

        public PositionInfo(int i, int headerLayout) {
            this.groupPosition = i;
            this.type = headerLayout;
        }

        public PositionInfo(int i, int headerLayout, int childPosition) {
            this.groupPosition = i;
            this.type = headerLayout;
            this.childPosition = childPosition;
        }

        public int getChildPosition() {
            return this.childPosition;
        }

        public int getType() {
            return this.type;
        }

        public int getGroupPosition() {
            return this.groupPosition;
        }
    }
}

