/*
 * Decompiled with CFR 0.152.
 */
package com.magnify.basea_dapter_library.abslistview;

import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Filter;
import android.widget.Filterable;
import com.magnify.basea_dapter_library.ViewHolder;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseAutoCompleteAdapter<T>
extends BaseAdapter
implements Filterable {
    private ArrayFilter mFilter;
    private ArrayList<T> mOriginalValues;
    private ArrayList<T> newValues;
    private List<T> mObjects;
    private final Object mLock = new Object();
    private int maxMatch = 20;
    private int layoutid;
    private String prefixStrings;

    public BaseAutoCompleteAdapter(int layoutid, ArrayList<T> mOriginalValues, int maxMatch) {
        this.mOriginalValues = mOriginalValues;
        this.layoutid = layoutid;
        this.maxMatch = maxMatch;
    }

    public Filter getFilter() {
        if (this.mFilter == null) {
            this.mFilter = new ArrayFilter();
        }
        return this.mFilter;
    }

    protected boolean judgeCondition(String prefixString, String valueText) {
        return valueText.contains(prefixString);
    }

    protected abstract String getFiltString(T var1);

    public int getCount() {
        return this.mObjects == null ? 0 : this.mObjects.size();
    }

    public String getItem(int position) {
        return this.getFiltString(this.mObjects.get(position));
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder = ViewHolder.get(parent.getContext(), convertView, parent, this.layoutid, position);
        this.setData2View(holder, this.mObjects.get(position), position, this.prefixStrings);
        return holder.getConvertView();
    }

    protected abstract void setData2View(ViewHolder var1, T var2, int var3, String var4);

    public ArrayList<T> getAllItems() {
        return this.mOriginalValues;
    }

    private class ArrayFilter
    extends Filter {
        private ArrayFilter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Filter.FilterResults performFiltering(CharSequence prefix) {
            Filter.FilterResults results = new Filter.FilterResults();
            if (prefix == null || prefix.length() == 0) {
                Object object = BaseAutoCompleteAdapter.this.mLock;
                synchronized (object) {
                    ArrayList list;
                    Log.i((String)"tag", (String)("mOriginalValues.size=" + BaseAutoCompleteAdapter.this.mOriginalValues.size()));
                    results.values = list = new ArrayList(BaseAutoCompleteAdapter.this.mOriginalValues);
                    results.count = list.size();
                    return results;
                }
            }
            String prefixString = prefix.toString().toLowerCase();
            BaseAutoCompleteAdapter.this.prefixStrings = prefix.toString();
            int count = BaseAutoCompleteAdapter.this.mOriginalValues.size();
            BaseAutoCompleteAdapter.this.newValues = new ArrayList();
            for (int i = 0; i < count; ++i) {
                String value = BaseAutoCompleteAdapter.this.getFiltString(BaseAutoCompleteAdapter.this.mOriginalValues.get(i));
                String valueText = value.toLowerCase();
                if (BaseAutoCompleteAdapter.this.judgeCondition(prefixString, valueText)) {
                    BaseAutoCompleteAdapter.this.newValues.add(BaseAutoCompleteAdapter.this.mOriginalValues.get(i));
                }
                if (BaseAutoCompleteAdapter.this.maxMatch > 0 && BaseAutoCompleteAdapter.this.newValues.size() > BaseAutoCompleteAdapter.this.maxMatch - 1) break;
            }
            results.values = BaseAutoCompleteAdapter.this.newValues;
            results.count = BaseAutoCompleteAdapter.this.newValues.size();
            return results;
        }

        protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
            BaseAutoCompleteAdapter.this.mObjects = (List)results.values;
            if (results.count > 0) {
                BaseAutoCompleteAdapter.this.notifyDataSetChanged();
            } else {
                BaseAutoCompleteAdapter.this.notifyDataSetInvalidated();
            }
        }
    }
}

