/*
 * Decompiled with CFR 0.152.
 */
package com.magnify.basea_dapter_library;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.DrawableRes;
import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import android.support.v7.widget.RecyclerView;
import android.text.Spanned;
import android.text.util.Linkify;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.Checkable;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RatingBar;
import android.widget.TextView;
import com.magnify.basea_dapter_library.ImageLoaderInterface;

public class ViewHolder
extends RecyclerView.ViewHolder {
    private SparseArray<View> mViews;
    private int mPosition;
    private View mConvertView;
    private Context mContext;
    private int mLayoutId;
    private static ImageLoaderInterface imageLoaderInterface;
    private int type;

    public static void setImageLoaderInterface(ImageLoaderInterface imageLoaderInterface) {
        ViewHolder.imageLoaderInterface = imageLoaderInterface;
    }

    public ViewHolder(Context context, View itemView, ViewGroup parent, int position) {
        super(itemView);
        this.mContext = context;
        this.mConvertView = itemView;
        this.mPosition = position;
        this.mViews = new SparseArray();
        this.mConvertView.setTag((Object)this);
    }

    public static ViewHolder get(Context context, View convertView, ViewGroup parent, @LayoutRes int layoutId, int position) {
        if (convertView == null) {
            View itemView = LayoutInflater.from((Context)context).inflate(layoutId, parent, false);
            ViewHolder holder = new ViewHolder(context, itemView, parent, position);
            holder.mLayoutId = layoutId;
            return holder;
        }
        ViewHolder holder = (ViewHolder)((Object)convertView.getTag());
        holder.mPosition = position;
        return holder;
    }

    public static ImageLoaderInterface getImageLoaderInterface() {
        return imageLoaderInterface;
    }

    public <T extends View> T getView(@IdRes int viewId) {
        View view = (View)this.mViews.get(viewId);
        if (view == null) {
            view = this.mConvertView.findViewById(viewId);
            this.mViews.put(viewId, (Object)view);
        }
        return (T)view;
    }

    public View getConvertView() {
        return this.mConvertView;
    }

    public ViewHolder setText(@IdRes int viewId, String text) {
        TextView tv = (TextView)this.getView(viewId);
        tv.setText((CharSequence)text);
        return this;
    }

    public ViewHolder setText(@IdRes int viewId, Spanned text) {
        TextView tv = (TextView)this.getView(viewId);
        tv.setText((CharSequence)text);
        return this;
    }

    public ViewHolder displayImage(String url, ImageView imageView, @DrawableRes int defaultDrawable) {
        if (imageLoaderInterface != null && defaultDrawable > 0) {
            imageLoaderInterface.displayImage(url, imageView, defaultDrawable);
        } else if (imageLoaderInterface != null && defaultDrawable < 0) {
            imageLoaderInterface.displayImage(url, imageView);
        } else {
            Log.e((String)"ViewHolder", (String)"\u8bf7\u5728\u5168\u5c40\u4e2d\u521d\u59cb\u5316ImageLoaderInterface");
        }
        return this;
    }

    public ViewHolder displayImage(@DrawableRes int drawableId, ImageView imageView) {
        if (imageLoaderInterface != null) {
            imageLoaderInterface.displayImage(drawableId, imageView);
        } else if (imageLoaderInterface != null) {
            imageLoaderInterface.displayImage(drawableId, imageView);
        } else {
            Log.e((String)"ViewHolder", (String)"\u8bf7\u5728\u5168\u5c40\u4e2d\u521d\u59cb\u5316ImageLoaderInterface");
        }
        return this;
    }

    public ViewHolder displayImage(String url, @IdRes int viewId) {
        return this.displayImage(url, (ImageView)this.getView(viewId), -1);
    }

    public ViewHolder displayImage(@DrawableRes int drawableId, @IdRes int viewId) {
        return this.displayImage(drawableId, (ImageView)this.getView(viewId));
    }

    public ViewHolder displayImage(String url, @IdRes int viewId, int defaultDrawable) {
        return this.displayImage(url, (ImageView)this.getView(viewId), defaultDrawable);
    }

    public ViewHolder displayRoundImage(String url, @IdRes int viewID, @DrawableRes int defaultDrawable) {
        return this.displayRoundImage(url, (ImageView)this.getView(viewID), defaultDrawable);
    }

    public ViewHolder displayRoundImage(String url, @IdRes int viewID, @DrawableRes int defaultDrawable, int roundRadius) {
        return this.displayRoundImage(url, (ImageView)this.getView(viewID), defaultDrawable, roundRadius);
    }

    public ViewHolder displayRoundImage(int url, int viewID) {
        return this.displayRoundImage(url, (ImageView)this.getView(viewID));
    }

    public ViewHolder displayRoundImage(String url, ImageView imageView, @DrawableRes int defaultDrawable) {
        if (imageLoaderInterface != null && defaultDrawable > 0) {
            imageLoaderInterface.displayRoundImage(url, imageView, defaultDrawable);
        } else if (imageLoaderInterface != null && defaultDrawable < 0) {
            imageLoaderInterface.displayRoundImage(url, imageView);
        } else {
            Log.e((String)"ViewHolder", (String)"\u8bf7\u5728\u5168\u5c40\u4e2d\u521d\u59cb\u5316ImageLoaderInterface");
        }
        return this;
    }

    public ViewHolder displayRoundImage(String url, ImageView imageView, @DrawableRes int defaultDrawable, int roundRaidus) {
        if (imageLoaderInterface != null && defaultDrawable > 0) {
            imageLoaderInterface.displayRoundImage(url, imageView, defaultDrawable, roundRaidus);
        } else if (imageLoaderInterface != null && defaultDrawable < 0) {
            imageLoaderInterface.displayRoundImage(url, imageView);
        } else {
            Log.e((String)"ViewHolder", (String)"\u8bf7\u5728\u5168\u5c40\u4e2d\u521d\u59cb\u5316ImageLoaderInterface");
        }
        return this;
    }

    public ViewHolder displayRoundImage(@DrawableRes int drawableID, ImageView imageView) {
        if (imageLoaderInterface != null) {
            imageLoaderInterface.displayRoundImage(drawableID, imageView);
        } else if (imageLoaderInterface != null) {
            imageLoaderInterface.displayRoundImage(drawableID, imageView);
        } else {
            Log.e((String)"ViewHolder", (String)"\u8bf7\u5728\u5168\u5c40\u4e2d\u521d\u59cb\u5316ImageLoaderInterface");
        }
        return this;
    }

    public ViewHolder displayRoundImage(String url, @IdRes int viewId) {
        return this.displayRoundImage(url, (ImageView)this.getView(viewId), -1);
    }

    public ViewHolder setImageResource(@IdRes int viewId, @DrawableRes int resId) {
        ImageView view = (ImageView)this.getView(viewId);
        view.setImageResource(resId);
        return this;
    }

    public ViewHolder setImageBitmap(@IdRes int viewId, Bitmap bitmap) {
        ImageView view = (ImageView)this.getView(viewId);
        view.setImageBitmap(bitmap);
        return this;
    }

    public ViewHolder setImageDrawable(@IdRes int viewId, Drawable drawable) {
        ImageView view = (ImageView)this.getView(viewId);
        view.setImageDrawable(drawable);
        return this;
    }

    public ViewHolder setBackgroundColor(@IdRes int viewId, int color) {
        Object view = this.getView(viewId);
        view.setBackgroundColor(color);
        return this;
    }

    public ViewHolder setBackgroundRes(@IdRes int viewId, int backgroundRes) {
        Object view = this.getView(viewId);
        view.setBackgroundResource(backgroundRes);
        return this;
    }

    public ViewHolder setTextColor(@IdRes int viewId, int textColor) {
        TextView view = (TextView)this.getView(viewId);
        view.setTextColor(textColor);
        return this;
    }

    public ViewHolder setTextColorRes(@IdRes int viewId, int textColorRes) {
        TextView view = (TextView)this.getView(viewId);
        view.setTextColor(this.mContext.getResources().getColor(textColorRes));
        return this;
    }

    @SuppressLint(value={"NewApi"})
    public ViewHolder setAlpha(@IdRes int viewId, float value) {
        if (Build.VERSION.SDK_INT >= 11) {
            this.getView(viewId).setAlpha(value);
        } else {
            AlphaAnimation alpha = new AlphaAnimation(value, value);
            alpha.setDuration(0L);
            alpha.setFillAfter(true);
            this.getView(viewId).startAnimation((Animation)alpha);
        }
        return this;
    }

    public ViewHolder setVisible(@IdRes int viewId, boolean visible) {
        Object view = this.getView(viewId);
        view.setVisibility(visible ? 0 : 8);
        return this;
    }

    public ViewHolder setVisible(boolean visible, int ... viewIds) {
        for (int i = 0; i < viewIds.length; ++i) {
            this.getView(viewIds[i]).setVisibility(visible ? 0 : 8);
        }
        return this;
    }

    public ViewHolder linkify(int viewId) {
        TextView view = (TextView)this.getView(viewId);
        Linkify.addLinks((TextView)view, (int)15);
        return this;
    }

    public ViewHolder setTypeface(Typeface typeface, int ... viewIds) {
        for (int viewId : viewIds) {
            TextView view = (TextView)this.getView(viewId);
            view.setTypeface(typeface);
            view.setPaintFlags(view.getPaintFlags() | 0x80);
        }
        return this;
    }

    public ViewHolder setProgress(@IdRes int viewId, int progress) {
        ProgressBar view = (ProgressBar)this.getView(viewId);
        view.setProgress(progress);
        return this;
    }

    public ViewHolder setProgress(@IdRes int viewId, int progress, int max) {
        ProgressBar view = (ProgressBar)this.getView(viewId);
        view.setMax(max);
        view.setProgress(progress);
        return this;
    }

    public ViewHolder setMax(@IdRes int viewId, int max) {
        ProgressBar view = (ProgressBar)this.getView(viewId);
        view.setMax(max);
        return this;
    }

    public ViewHolder setRating(@IdRes int viewId, float rating) {
        RatingBar view = (RatingBar)this.getView(viewId);
        view.setRating(rating);
        return this;
    }

    public ViewHolder setRating(@IdRes int viewId, float rating, int max) {
        RatingBar view = (RatingBar)this.getView(viewId);
        view.setMax(max);
        view.setRating(rating);
        return this;
    }

    public ViewHolder setTag(@IdRes int viewId, Object tag) {
        Object view = this.getView(viewId);
        view.setTag(tag);
        return this;
    }

    public ViewHolder setTag(@IdRes int viewId, int key, Object tag) {
        Object view = this.getView(viewId);
        view.setTag(key, tag);
        return this;
    }

    public ViewHolder setChecked(@IdRes int viewId, boolean checked) {
        Checkable view = (Checkable)this.getView(viewId);
        view.setChecked(checked);
        return this;
    }

    public ViewHolder setOnClickListener(@IdRes int viewId, View.OnClickListener listener) {
        Object view = this.getView(viewId);
        view.setOnClickListener(listener);
        return this;
    }

    public ViewHolder setOnClickListener(View.OnClickListener listener, int ... viewIds) {
        for (int i = 0; i < viewIds.length; ++i) {
            this.getView(viewIds[i]).setOnClickListener(listener);
        }
        return this;
    }

    public ViewHolder setOnTouchListener(@IdRes int viewId, View.OnTouchListener listener) {
        Object view = this.getView(viewId);
        view.setOnTouchListener(listener);
        return this;
    }

    public ViewHolder setOnLongClickListener(int viewId, View.OnLongClickListener listener) {
        Object view = this.getView(viewId);
        view.setOnLongClickListener(listener);
        return this;
    }

    public void updatePosition(int position) {
        this.mPosition = position;
    }

    public int getmPosition() {
        return this.mPosition;
    }

    public int getLayoutId() {
        return this.mLayoutId;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public ViewHolder setOnClickListener(int imageid, int position, View.OnClickListener onClickListener) {
        ImageView imageView = (ImageView)this.getView(imageid);
        imageView.setTag(imageid, (Object)position);
        imageView.setOnClickListener(onClickListener);
        return this;
    }
}

