/*
 * Decompiled with CFR 0.152.
 */
package com.hehuelet.statusbar;

import android.app.Activity;
import android.graphics.Color;
import android.os.Build;
import android.view.Window;
import android.view.WindowManager;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class StatusBarFontUtils {
    public static final int OTHER = 0;
    public static final int MIUI = 1;
    public static final int FLYME = 2;
    public static final int ANDROID_M = 3;

    public static boolean isLightColor(Activity activity, int color) {
        return StatusBarFontUtils.toGrey(color) > 225;
    }

    public static int toGrey(int color) {
        int blue = Color.blue((int)color);
        int green = Color.green((int)color);
        int red = Color.red((int)color);
        return red * 38 + green * 75 + blue * 15 >> 7;
    }

    public static void setLightMode(Activity activity) {
        StatusBarFontUtils.setStatusBarMode(activity, true);
    }

    public static void setDarkMode(Activity activity) {
        StatusBarFontUtils.setStatusBarMode(activity, false);
    }

    public static void setLightMode(Activity activity, int type) {
        StatusBarFontUtils.setStatusBarMode(activity, type, true);
    }

    public static void setDarkMode(Activity activity, int type) {
        StatusBarFontUtils.setStatusBarMode(activity, type, false);
    }

    public static int setStatusBarMode(Activity activity, boolean isFontColorDark) {
        int result = 0;
        if (Build.VERSION.SDK_INT >= 19) {
            if (new MIUIHelper().setStatusBarLightMode(activity, isFontColorDark)) {
                result = 1;
            } else if (new FlymeHelper().setStatusBarLightMode(activity, isFontColorDark)) {
                result = 2;
            } else if (new AndroidMHelper().setStatusBarLightMode(activity, isFontColorDark)) {
                result = 3;
            }
        }
        return result;
    }

    private static void setStatusBarMode(Activity activity, int type, boolean isFontColorDark) {
        if (Build.VERSION.SDK_INT >= 19) {
            if (type == 1) {
                new MIUIHelper().setStatusBarLightMode(activity, isFontColorDark);
            } else if (type == 2) {
                new FlymeHelper().setStatusBarLightMode(activity, isFontColorDark);
            } else if (type == 3) {
                new AndroidMHelper().setStatusBarLightMode(activity, isFontColorDark);
            }
        }
    }

    public static class FlymeHelper
    implements IStatusBarFontHelper {
        @Override
        public boolean setStatusBarLightMode(Activity activity, boolean isFontColorDark) {
            Window window = activity.getWindow();
            boolean result = false;
            if (window != null) {
                try {
                    WindowManager.LayoutParams lp = window.getAttributes();
                    Field darkFlag = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
                    Field meizuFlags = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
                    darkFlag.setAccessible(true);
                    meizuFlags.setAccessible(true);
                    int bit = darkFlag.getInt(null);
                    int value = meizuFlags.getInt(lp);
                    value = isFontColorDark ? (value |= bit) : (value &= ~bit);
                    meizuFlags.setInt(lp, value);
                    window.setAttributes(lp);
                    result = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return result;
        }
    }

    public static class MIUIHelper
    implements IStatusBarFontHelper {
        @Override
        public boolean setStatusBarLightMode(Activity activity, boolean isFontColorDark) {
            Window window = activity.getWindow();
            boolean result = false;
            if (window != null) {
                Class<?> clazz = window.getClass();
                try {
                    int darkModeFlag = 0;
                    Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
                    Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
                    darkModeFlag = field.getInt(layoutParams);
                    Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
                    if (isFontColorDark) {
                        extraFlagField.invoke((Object)window, darkModeFlag, darkModeFlag);
                    } else {
                        extraFlagField.invoke((Object)window, 0, darkModeFlag);
                    }
                    result = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return result;
        }
    }

    public static class AndroidMHelper
    implements IStatusBarFontHelper {
        @Override
        public boolean setStatusBarLightMode(Activity activity, boolean isFontColorDark) {
            if (Build.VERSION.SDK_INT >= 23) {
                if (isFontColorDark) {
                    activity.getWindow().getDecorView().setSystemUiVisibility(9216);
                } else {
                    activity.getWindow().getDecorView().setSystemUiVisibility(0);
                }
                return true;
            }
            return false;
        }
    }

    public static interface IStatusBarFontHelper {
        public boolean setStatusBarLightMode(Activity var1, boolean var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SystemType {
    }
}

