/*
 * Decompiled with CFR 0.152.
 */
package com.hedgehog.ratingbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.hedgehog.ratingbar.R;
import java.math.BigDecimal;

public class RatingBar
extends LinearLayout {
    private boolean mClickable;
    private boolean halfstart;
    private int starCount;
    private OnRatingChangeListener onRatingChangeListener;
    private float starImageSize;
    private float starImageWidth;
    private float starImageHeight;
    private float starImagePadding;
    private Drawable starEmptyDrawable;
    private Drawable starFillDrawable;
    private Drawable starHalfDrawable;
    private int y = 1;

    public void setStarHalfDrawable(Drawable starHalfDrawable) {
        this.starHalfDrawable = starHalfDrawable;
    }

    public void setOnRatingChangeListener(OnRatingChangeListener onRatingChangeListener) {
        this.onRatingChangeListener = onRatingChangeListener;
    }

    public void setmClickable(boolean clickable) {
        this.mClickable = clickable;
    }

    public void halfStar(boolean halfstart) {
        this.halfstart = halfstart;
    }

    public void setStarFillDrawable(Drawable starFillDrawable) {
        this.starFillDrawable = starFillDrawable;
    }

    public void setStarEmptyDrawable(Drawable starEmptyDrawable) {
        this.starEmptyDrawable = starEmptyDrawable;
    }

    public void setStarImageSize(float starImageSize) {
        this.starImageSize = starImageSize;
    }

    public void setStarImageWidth(float starImageWidth) {
        this.starImageWidth = starImageWidth;
    }

    public void setStarImageHeight(float starImageHeight) {
        this.starImageHeight = starImageHeight;
    }

    public void setStarCount(int starCount) {
        this.starCount = starCount;
    }

    public void setImagePadding(float starImagePadding) {
        this.starImagePadding = starImagePadding;
    }

    public RatingBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setOrientation(0);
        TypedArray mTypedArray = context.obtainStyledAttributes(attrs, R.styleable.RatingBar);
        this.starHalfDrawable = mTypedArray.getDrawable(R.styleable.RatingBar_starHalf);
        this.starImageSize = mTypedArray.getDimension(R.styleable.RatingBar_starImageSize, 120.0f);
        this.starImageWidth = mTypedArray.getDimension(R.styleable.RatingBar_starImageWidth, 60.0f);
        this.starImageHeight = mTypedArray.getDimension(R.styleable.RatingBar_starImageHeight, 120.0f);
        this.starImagePadding = mTypedArray.getDimension(R.styleable.RatingBar_starImagePadding, 15.0f);
        this.starCount = mTypedArray.getInteger(R.styleable.RatingBar_starCount, 5);
        this.starEmptyDrawable = mTypedArray.getDrawable(R.styleable.RatingBar_starEmpty);
        this.starFillDrawable = mTypedArray.getDrawable(R.styleable.RatingBar_starFill);
        this.mClickable = mTypedArray.getBoolean(R.styleable.RatingBar_clickable, true);
        this.halfstart = mTypedArray.getBoolean(R.styleable.RatingBar_halfstart, false);
        for (int i = 0; i < this.starCount; ++i) {
            ImageView imageView = this.getStarImageView(context);
            imageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (RatingBar.this.mClickable && RatingBar.this.halfstart) {
                        if (RatingBar.this.y % 2 == 0) {
                            RatingBar.this.setStar((float)RatingBar.this.indexOfChild(v) + 1.0f);
                        } else {
                            RatingBar.this.setStar((float)RatingBar.this.indexOfChild(v) + 0.5f);
                        }
                        if (RatingBar.this.onRatingChangeListener != null) {
                            if (RatingBar.this.y % 2 == 0) {
                                RatingBar.this.onRatingChangeListener.onRatingChange((float)RatingBar.this.indexOfChild(v) + 1.0f);
                                RatingBar.this.y++;
                            } else {
                                RatingBar.this.onRatingChangeListener.onRatingChange((float)RatingBar.this.indexOfChild(v) + 0.5f);
                                RatingBar.this.y++;
                            }
                        }
                    } else {
                        RatingBar.this.setStar((float)RatingBar.this.indexOfChild(v) + 1.0f);
                        if (RatingBar.this.onRatingChangeListener != null) {
                            RatingBar.this.onRatingChangeListener.onRatingChange((float)RatingBar.this.indexOfChild(v) + 1.0f);
                        }
                    }
                }
            });
            this.addView((View)imageView);
        }
    }

    private ImageView getStarImageView(Context context) {
        ImageView imageView = new ImageView(context);
        ViewGroup.LayoutParams para = new ViewGroup.LayoutParams(Math.round(this.starImageWidth), Math.round(this.starImageHeight));
        imageView.setLayoutParams(para);
        imageView.setPadding(0, 0, Math.round(this.starImagePadding), 0);
        imageView.setImageDrawable(this.starEmptyDrawable);
        return imageView;
    }

    public void setStar(float starCount) {
        int fint = (int)starCount;
        BigDecimal b1 = new BigDecimal(Float.toString(starCount));
        BigDecimal b2 = new BigDecimal(Integer.toString(fint));
        float fPoint = b1.subtract(b2).floatValue();
        starCount = fint > this.starCount ? (float)this.starCount : (float)fint;
        starCount = starCount < 0.0f ? 0.0f : starCount;
        int i = 0;
        while ((float)i < starCount) {
            ((ImageView)this.getChildAt(i)).setImageDrawable(this.starFillDrawable);
            ++i;
        }
        if (fPoint > 0.0f) {
            ((ImageView)this.getChildAt(fint)).setImageDrawable(this.starHalfDrawable);
            i = this.starCount - 1;
            while ((float)i >= starCount + 1.0f) {
                ((ImageView)this.getChildAt(i)).setImageDrawable(this.starEmptyDrawable);
                --i;
            }
        } else {
            i = this.starCount - 1;
            while ((float)i >= starCount) {
                ((ImageView)this.getChildAt(i)).setImageDrawable(this.starEmptyDrawable);
                --i;
            }
        }
    }

    public static interface OnRatingChangeListener {
        public void onRatingChange(float var1);
    }
}

