/*
 * Decompiled with CFR 0.152.
 */
package com.hedgehog.ratingbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.hedgehog.ratingbar.R;
import java.math.BigDecimal;

public class RatingBar
extends LinearLayout {
    private boolean mClickable;
    private int starCount;
    private OnRatingChangeListener onRatingChangeListener;
    private float starImageSize;
    private Drawable starEmptyDrawable;
    private Drawable starFillDrawable;
    private Drawable starHalfDrawable;

    public void setStarHalfDrawable(Drawable starHalfDrawable) {
        this.starHalfDrawable = starHalfDrawable;
    }

    public void setOnRatingChangeListener(OnRatingChangeListener onRatingChangeListener) {
        this.onRatingChangeListener = onRatingChangeListener;
    }

    public void setmClickable(boolean clickable) {
        this.mClickable = clickable;
    }

    public void setStarFillDrawable(Drawable starFillDrawable) {
        this.starFillDrawable = starFillDrawable;
    }

    public void setStarEmptyDrawable(Drawable starEmptyDrawable) {
        this.starEmptyDrawable = starEmptyDrawable;
    }

    public void setStarImageSize(float starImageSize) {
        this.starImageSize = starImageSize;
    }

    public RatingBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setOrientation(0);
        TypedArray mTypedArray = context.obtainStyledAttributes(attrs, R.styleable.RatingBar);
        this.starImageSize = mTypedArray.getDimension(R.styleable.RatingBar_starImageSize, 20.0f);
        this.starCount = mTypedArray.getInteger(R.styleable.RatingBar_starCount, 5);
        this.starEmptyDrawable = mTypedArray.getDrawable(R.styleable.RatingBar_starEmpty);
        this.starFillDrawable = mTypedArray.getDrawable(R.styleable.RatingBar_starFill);
        this.mClickable = mTypedArray.getBoolean(R.styleable.RatingBar_clickable, true);
        for (int i = 0; i < this.starCount; ++i) {
            ImageView imageView = this.getStarImageView(context, attrs);
            imageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (RatingBar.this.mClickable) {
                        RatingBar.this.setStar(RatingBar.this.indexOfChild(v) + 1);
                        if (RatingBar.this.onRatingChangeListener != null) {
                            RatingBar.this.onRatingChangeListener.onRatingChange(RatingBar.this.indexOfChild(v) + 1);
                        }
                    }
                }
            });
            this.addView((View)imageView);
        }
    }

    private ImageView getStarImageView(Context context, AttributeSet attrs) {
        ImageView imageView = new ImageView(context);
        ViewGroup.LayoutParams para = new ViewGroup.LayoutParams(Math.round(this.starImageSize), Math.round(this.starImageSize));
        imageView.setLayoutParams(para);
        imageView.setPadding(0, 0, 5, 0);
        imageView.setImageDrawable(this.starEmptyDrawable);
        imageView.setMaxWidth(10);
        imageView.setMaxHeight(10);
        return imageView;
    }

    public void setStar(float starCount) {
        int fint = (int)starCount;
        BigDecimal b1 = new BigDecimal(Float.toString(starCount));
        BigDecimal b2 = new BigDecimal(Integer.toString(fint));
        float fPoint = b1.subtract(b2).floatValue();
        starCount = fint > this.starCount ? (float)this.starCount : (float)fint;
        starCount = starCount < 0.0f ? 0.0f : starCount;
        int i = 0;
        while ((float)i < starCount) {
            ((ImageView)this.getChildAt(i)).setImageDrawable(this.starFillDrawable);
            ++i;
        }
        if (fPoint > 0.0f) {
            ((ImageView)this.getChildAt(fint)).setImageDrawable(this.starHalfDrawable);
            i = this.starCount - 1;
            while ((float)i >= starCount + 1.0f) {
                ((ImageView)this.getChildAt(i)).setImageDrawable(this.starEmptyDrawable);
                --i;
            }
        } else {
            i = this.starCount - 1;
            while ((float)i >= starCount) {
                ((ImageView)this.getChildAt(i)).setImageDrawable(this.starEmptyDrawable);
                --i;
            }
        }
    }

    public static interface OnRatingChangeListener {
        public void onRatingChange(int var1);
    }
}

