/*
 * Decompiled with CFR 0.152.
 */
package com.hedgehog.ratingbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.hedgehog.ratingbar.R;

public class RatingBar
extends LinearLayout {
    private boolean mClickable;
    private int starCount;
    private OnRatingChangeListener onRatingChangeListener;
    private float starImageSize;
    private Drawable starEmptyDrawable;
    private Drawable starFillDrawable;

    public void setOnRatingChangeListener(OnRatingChangeListener onRatingChangeListener) {
        this.onRatingChangeListener = onRatingChangeListener;
    }

    public void setmClickable(boolean clickable) {
        this.mClickable = clickable;
    }

    public void setStarFillDrawable(Drawable starFillDrawable) {
        this.starFillDrawable = starFillDrawable;
    }

    public void setStarEmptyDrawable(Drawable starEmptyDrawable) {
        this.starEmptyDrawable = starEmptyDrawable;
    }

    public void setStarImageSize(float starImageSize) {
        this.starImageSize = starImageSize;
    }

    public RatingBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setOrientation(0);
        TypedArray mTypedArray = context.obtainStyledAttributes(attrs, R.styleable.RatingBar);
        this.starImageSize = mTypedArray.getDimension(R.styleable.RatingBar_starImageSize, 20.0f);
        this.starCount = mTypedArray.getInteger(R.styleable.RatingBar_starCount, 5);
        this.starEmptyDrawable = mTypedArray.getDrawable(R.styleable.RatingBar_starEmpty);
        this.starFillDrawable = mTypedArray.getDrawable(R.styleable.RatingBar_starFill);
        this.mClickable = mTypedArray.getBoolean(1, false);
        for (int i = 0; i < this.starCount; ++i) {
            ImageView imageView = this.getStarImageView(context, attrs);
            imageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (RatingBar.this.mClickable) {
                        RatingBar.this.setStar(RatingBar.this.indexOfChild(v) + 1);
                        if (RatingBar.this.onRatingChangeListener != null) {
                            RatingBar.this.onRatingChangeListener.onRatingChange(RatingBar.this.indexOfChild(v) + 1);
                        }
                    }
                }
            });
            this.addView((View)imageView);
        }
    }

    private ImageView getStarImageView(Context context, AttributeSet attrs) {
        ImageView imageView = new ImageView(context);
        ViewGroup.LayoutParams para = new ViewGroup.LayoutParams(Math.round(this.starImageSize), Math.round(this.starImageSize));
        imageView.setLayoutParams(para);
        imageView.setPadding(0, 0, 5, 0);
        imageView.setImageDrawable(this.starEmptyDrawable);
        imageView.setMaxWidth(10);
        imageView.setMaxHeight(10);
        return imageView;
    }

    public void setStar(int starCount) {
        int i;
        starCount = starCount > this.starCount ? this.starCount : starCount;
        starCount = starCount < 0 ? 0 : starCount;
        for (i = 0; i < starCount; ++i) {
            ((ImageView)this.getChildAt(i)).setImageDrawable(this.starFillDrawable);
        }
        for (i = this.starCount - 1; i >= starCount; --i) {
            ((ImageView)this.getChildAt(i)).setImageDrawable(this.starEmptyDrawable);
        }
    }

    public static interface OnRatingChangeListener {
        public void onRatingChange(int var1);
    }
}

