/*
 * Decompiled with CFR 0.152.
 */
package com.hector.recyclerview;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.hector.recyclerview.R;
import java.util.Date;

public class RecyclerViewHeader
extends LinearLayout {
    private LinearLayout mContainer;
    private TextView mViewStateTv;
    private TextView mUpdateTimeTv;
    private ImageView mIndicatorIv;
    private ProgressBar mHeaderProgressBar;
    private int mState;
    private int mMeasureHeight;
    private Animation arrowUpAnimation;

    public RecyclerViewHeader(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    public RecyclerViewHeader(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public RecyclerViewHeader(Context context) {
        super(context);
        this.init(context);
    }

    private void init(Context context) {
        this.mContainer = (LinearLayout)LayoutInflater.from((Context)context).inflate(R.layout.header_recycler_view, null);
        this.mViewStateTv = (TextView)this.mContainer.findViewById(R.id.header_tv_state);
        this.mUpdateTimeTv = (TextView)this.mContainer.findViewById(R.id.header_tv_time);
        this.mIndicatorIv = (ImageView)this.mContainer.findViewById(R.id.header_iv_indicator);
        this.mHeaderProgressBar = (ProgressBar)this.mContainer.findViewById(R.id.header_pb);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -2);
        lp.setMargins(0, 0, 0, 0);
        this.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.setPadding(0, 0, 0, 0);
        this.addView((View)this.mContainer, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 0));
        this.setGravity(80);
        this.measure(-1, -1);
        this.mMeasureHeight = this.getMeasuredHeight();
        this.arrowUpAnimation = new RotateAnimation(0.0f, -180.0f, 1, 0.5f, 1, 0.5f);
        this.arrowUpAnimation.setDuration(200L);
        this.arrowUpAnimation.setFillAfter(true);
    }

    private void setState(int state) {
        switch (state) {
            case 0: {
                this.mIndicatorIv.setImageResource(R.drawable.arrow);
                this.mViewStateTv.setText((CharSequence)this.getResources().getString(R.string.state_normal));
                break;
            }
            case 1: {
                if (this.mState == 0) {
                    this.mIndicatorIv.startAnimation(this.arrowUpAnimation);
                }
                this.mViewStateTv.setText((CharSequence)this.getResources().getString(R.string.state_on_move));
                break;
            }
            case 2: {
                this.mIndicatorIv.clearAnimation();
                this.mIndicatorIv.setVisibility(4);
                this.mHeaderProgressBar.setVisibility(0);
                this.mViewStateTv.setText((CharSequence)this.getResources().getString(R.string.state_refreshing));
                break;
            }
            case 3: {
                this.mHeaderProgressBar.setVisibility(8);
                this.mIndicatorIv.setVisibility(0);
                this.mIndicatorIv.setImageResource(R.drawable.complete);
                this.mViewStateTv.setText((CharSequence)this.getResources().getString(R.string.state_complete));
            }
        }
        this.mState = state;
    }

    public void setVisibleHeight(int height) {
        if (height < 0) {
            height = 0;
        }
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.mContainer.getLayoutParams();
        lp.height = height;
        this.mContainer.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    public int getVisibleHeight() {
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.mContainer.getLayoutParams();
        return lp.height;
    }

    public long getLastUpdateTime() {
        SharedPreferences sharedPreferences = this.getContext().getSharedPreferences("recycler_view", 0);
        return sharedPreferences.getLong("lastUpdateTime", System.currentTimeMillis());
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        SharedPreferences sharedPreferences = this.getContext().getSharedPreferences("recycler_view", 0);
        sharedPreferences.edit().putLong("lastUpdateTime", lastUpdateTime.getTime()).commit();
    }

    public void smoothScrollTo(int destHeight) {
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{this.getVisibleHeight(), destHeight});
        valueAnimator.setDuration(300L);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                RecyclerViewHeader.this.setVisibleHeight((Integer)animation.getAnimatedValue());
            }
        });
        valueAnimator.start();
    }

    public void autoDisplay() {
        this.smoothScrollTo(this.mMeasureHeight);
    }

    public void resetHeader() {
        this.smoothScrollTo(0);
        this.setState(0);
    }

    public boolean onMove(float delta) {
        this.mUpdateTimeTv.setText((CharSequence)this.friendlyTime(this.getLastUpdateTime()));
        if (this.getVisibleHeight() >= 0 || delta > 0.0f) {
            this.setVisibleHeight((int)delta + this.getVisibleHeight());
            if (this.mState <= 1) {
                if (this.getVisibleHeight() > this.mMeasureHeight) {
                    this.setState(1);
                    return true;
                }
                this.setState(0);
                return false;
            }
        }
        return true;
    }

    public void release() {
        this.smoothScrollTo(this.mMeasureHeight);
        this.setState(2);
    }

    public void complete() {
        this.setState(3);
        this.setLastUpdateTime(new Date());
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                RecyclerViewHeader.this.resetHeader();
            }
        }, 1000L);
    }

    public String friendlyTime(long time) {
        int ct = (int)((System.currentTimeMillis() - time) / 1000L);
        if (ct == 0) {
            return this.getResources().getString(R.string.time_just_now);
        }
        if (ct > 0 && ct < 60) {
            return ct + this.getResources().getString(R.string.time_seconds_ago);
        }
        if (ct >= 60 && ct < 3600) {
            return Math.max(ct / 60, 1) + this.getResources().getString(R.string.time_minutes_ago);
        }
        if (ct >= 3600 && ct < 86400) {
            return ct / 3600 + this.getResources().getString(R.string.time_hours_ago);
        }
        if (ct >= 86400 && ct < 2592000) {
            int day = ct / 86400;
            return day + this.getResources().getString(R.string.time_days_ago);
        }
        if (ct >= 2592000 && ct < 31104000) {
            return ct / 2592000 + this.getResources().getString(R.string.time_months_ago);
        }
        return ct / 31104000 + this.getResources().getString(R.string.time_years_ago);
    }
}

