/*
 * Decompiled with CFR 0.152.
 */
package com.hector.recyclerview;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.hector.recyclerview.R;

public class RecyclerViewFooter
extends LinearLayout {
    private View mContainer;
    private TextView mFooterTv;
    private ProgressBar mProgressBar;

    public RecyclerViewFooter(Context context) {
        super(context);
        this.init(context);
    }

    public RecyclerViewFooter(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public RecyclerViewFooter(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.mContainer = LayoutInflater.from((Context)context).inflate(R.layout.footer_recycler_view, null, false);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -2);
        lp.setMargins(0, 0, 0, 0);
        this.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.setPadding(0, 0, 0, 0);
        this.addView(this.mContainer, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.mFooterTv = (TextView)this.mContainer.findViewById(R.id.footer_text);
        this.mProgressBar = (ProgressBar)this.mContainer.findViewById(R.id.footer_pb);
    }

    private void setState(int state) {
        switch (state) {
            case 0: {
                this.mFooterTv.setText((CharSequence)this.getResources().getString(R.string.footer_state_normal));
                break;
            }
            case 1: {
                this.mFooterTv.setText((CharSequence)this.getResources().getString(R.string.footer_state_loading));
                break;
            }
            case 2: {
                this.mFooterTv.setText((CharSequence)this.getResources().getString(R.string.footer_state_normal));
                break;
            }
            case 3: {
                this.mFooterTv.setText((CharSequence)this.getResources().getString(R.string.footer_state_no_more));
            }
        }
    }

    public void complete() {
        this.mProgressBar.setVisibility(8);
        this.setState(2);
    }

    public void loading() {
        this.mProgressBar.setVisibility(0);
        this.setState(1);
    }

    public void noMore() {
        this.mProgressBar.setVisibility(8);
        this.setState(3);
    }
}

