/*
 * Decompiled with CFR 0.152.
 */
package com.hector.recyclerview;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.hector.recyclerview.RecyclerViewFooter;
import com.hector.recyclerview.RecyclerViewHeader;

public class HectorRecyclerView
extends RecyclerView {
    private static final int TYPE_NORMAL = 0;
    private static final int TYPE_HEADER = 1;
    private static final int TYPE_FOOTER = 2;
    private RecyclerViewHeader mHeader;
    private RecyclerViewFooter mFooter;
    private float mLastY;
    private boolean mCanRefresh = false;
    private boolean mLoadMoreEnabled = true;
    private boolean mRefreshEnabled = true;
    private RecyclerView.Adapter mWrapperAdapter;
    private RefreshListener listener;
    private RecyclerView.AdapterDataObserver mDataObserver = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            HectorRecyclerView.this.mWrapperAdapter.notifyDataSetChanged();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            HectorRecyclerView.this.mWrapperAdapter.notifyItemRangeChanged(positionStart, itemCount);
        }

        public void onItemRangeChanged(int positionStart, int itemCount, Object payload) {
            HectorRecyclerView.this.mWrapperAdapter.notifyItemRangeChanged(positionStart, itemCount, payload);
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            HectorRecyclerView.this.mWrapperAdapter.notifyItemRangeInserted(positionStart, itemCount);
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            HectorRecyclerView.this.mWrapperAdapter.notifyItemRangeRemoved(positionStart, itemCount);
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            HectorRecyclerView.this.mWrapperAdapter.notifyItemMoved(fromPosition, toPosition);
        }
    };

    public HectorRecyclerView(Context context) {
        super(context);
        this.init(context);
    }

    public HectorRecyclerView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public HectorRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        this.mHeader = new RecyclerViewHeader(context);
        this.mFooter = new RecyclerViewFooter(context);
        this.mFooter.setVisibility(8);
    }

    public void setListener(RefreshListener listener) {
        this.listener = listener;
    }

    public void setRefreshEnabled(boolean mRefreshEnabled) {
        this.mRefreshEnabled = mRefreshEnabled;
    }

    public void setLoadMoreEnabled(boolean mLoadMoreEnabled) {
        this.mLoadMoreEnabled = mLoadMoreEnabled;
    }

    public void autoRefresh() {
        this.mHeader.autoDisplay();
        this.mHeader.release();
        if (this.listener != null) {
            this.listener.refresh();
        }
    }

    public void refreshComplete() {
        if (this.mRefreshEnabled) {
            this.mHeader.complete();
        }
    }

    public void loadComplete() {
        if (this.mLoadMoreEnabled) {
            this.mFooter.complete();
        }
    }

    public void noMoreData() {
        if (!this.mLoadMoreEnabled) {
            return;
        }
        if (this.getLayoutManager().getItemCount() <= this.getLayoutManager().getChildCount()) {
            this.mFooter.setVisibility(8);
        } else {
            this.mFooter.setVisibility(0);
            this.mFooter.noMore();
        }
    }

    private int findMaxPos(int[] pos) {
        int max = -1;
        for (int item : pos) {
            if (item <= max) continue;
            max = item;
        }
        return max;
    }

    public void onScrollStateChanged(int state) {
        super.onScrollStateChanged(state);
        if (state == 0 && this.listener != null && this.mLoadMoreEnabled) {
            RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
            int lastVisiblePos = 0;
            if (layoutManager instanceof GridLayoutManager) {
                lastVisiblePos = ((GridLayoutManager)layoutManager).findLastVisibleItemPosition();
            } else if (layoutManager instanceof LinearLayoutManager) {
                lastVisiblePos = ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition();
            } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                int[] pos = new int[((StaggeredGridLayoutManager)layoutManager).getSpanCount()];
                ((StaggeredGridLayoutManager)layoutManager).findLastVisibleItemPositions(pos);
                lastVisiblePos = this.findMaxPos(pos);
            }
            if (lastVisiblePos >= layoutManager.getItemCount() - 1 && layoutManager.getItemCount() > layoutManager.getChildCount() && layoutManager.getChildCount() > 0 && this.mLoadMoreEnabled) {
                this.mFooter.setVisibility(0);
                this.mFooter.loading();
                this.listener.loadMore();
            }
        }
    }

    public boolean onTouchEvent(MotionEvent e) {
        if (this.mLastY == -1.0f) {
            this.mLastY = e.getRawY();
        }
        int action = e.getAction();
        if (this.mRefreshEnabled) {
            switch (action) {
                case 0: {
                    this.mLastY = e.getRawY();
                    break;
                }
                case 2: {
                    float deltaY = e.getRawY() - this.mLastY;
                    this.mLastY = e.getRawY();
                    this.mCanRefresh = this.mHeader.onMove(deltaY / 3.0f);
                    break;
                }
                default: {
                    this.mLastY = -1.0f;
                    if (this.mCanRefresh) {
                        if (this.listener == null) break;
                        this.mHeader.release();
                        this.listener.refresh();
                        break;
                    }
                    this.mHeader.resetHeader();
                }
            }
        }
        return super.onTouchEvent(e);
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        this.mWrapperAdapter = new WrapperAdapter(adapter, this.mHeader, this.mFooter);
        super.setAdapter(this.mWrapperAdapter);
        adapter.registerAdapterDataObserver(this.mDataObserver);
    }

    public static interface RefreshListener {
        public void refresh();

        public void loadMore();
    }

    protected class WrapperAdapter
    extends RecyclerView.Adapter {
        private RecyclerView.Adapter mMainAdapter;
        private RecyclerViewHeader mHeaderView;
        private RecyclerViewFooter mFooterView;

        public WrapperAdapter(RecyclerView.Adapter mMainAdapter, RecyclerViewHeader mHeaderView, RecyclerViewFooter mFooterView) {
            this.mMainAdapter = mMainAdapter;
            this.mHeaderView = mHeaderView;
            this.mFooterView = mFooterView;
        }

        public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            if (viewType == 1) {
                return new SimpleViewHolder((View)this.mHeaderView);
            }
            if (viewType == 2) {
                return new SimpleViewHolder((View)this.mFooterView);
            }
            return this.mMainAdapter.onCreateViewHolder(parent, viewType);
        }

        public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
            if (position == 0) {
                return;
            }
            int realPos = position - 1;
            if (this.mMainAdapter != null && realPos < this.mMainAdapter.getItemCount()) {
                this.mMainAdapter.onBindViewHolder(holder, realPos);
                return;
            }
        }

        public int getItemCount() {
            if (this.mMainAdapter == null) {
                return 1;
            }
            return 1 + this.mMainAdapter.getItemCount() + 1;
        }

        public int getItemViewType(int position) {
            int realPos;
            if (position == 0) {
                return 1;
            }
            if (position == this.getItemCount() - 1) {
                return 2;
            }
            if (this.mMainAdapter != null && (realPos = position - 1) < this.mMainAdapter.getItemCount()) {
                return this.mMainAdapter.getItemViewType(realPos);
            }
            return 0;
        }

        private class SimpleViewHolder
        extends RecyclerView.ViewHolder {
            public SimpleViewHolder(View itemView) {
                super(itemView);
            }
        }
    }
}

