/*
 * Decompiled with CFR 0.152.
 */
package com.heaven7.java.xml;

import com.heaven7.java.reflecty.MemberProxy;
import com.heaven7.java.reflecty.ReflectyContext;
import com.heaven7.java.reflectyio.ObjectWriteMonitor;
import com.heaven7.java.reflectyio.ReflectyWriter;
import com.heaven7.java.xml.ArrayTypeWriter;
import com.heaven7.java.xml.IXmlWriter;
import com.heaven7.java.xml.ObjectTypeWriter;
import com.heaven7.java.xml.ParentTypeWriter;
import com.heaven7.java.xml.XmlElement;
import com.heaven7.java.xml.XmlException;
import com.heaven7.java.xml.XmlMemberProxy;
import com.heaven7.java.xml.XmlWriterImpl;
import java.io.IOException;
import java.io.Writer;
import java.util.Stack;

public final class XmlWriter
implements ReflectyWriter,
IXmlWriter,
ObjectWriteMonitor {
    private static final byte TYPE_OBJECT = 1;
    private static final byte TYPE_ARRAY = 2;
    private static final byte TYPE_MAP = 3;
    private final ArrayTypeWriter mArrayWriter = new ArrayTypeWriter();
    private final ObjectTypeWriter mObjWriter = new ObjectTypeWriter();
    private final Stack<StackNode> parentTypeStack = new Stack();
    private final XmlWriterImpl impl;
    private ParentTypeWriter pWriter;
    private String name;
    private String mElementName;
    private final Stack<XmlMemberProxy> mProxyStack = new Stack();

    public XmlWriter(Writer writer) {
        this.impl = new XmlWriterImpl(writer);
    }

    public void begin(Object obj) throws IOException {
    }

    public void end(Object obj) throws IOException {
        this.parentTypeStack.clear();
        this.mProxyStack.clear();
        this.mElementName = null;
        this.name = null;
    }

    public void name(String s) throws IOException {
        this.name = s;
    }

    public void nullValue() throws IOException {
        this.pWriter.nullValue(this.impl, this.name);
    }

    public void value(Number obj) throws IOException {
        this.pWriter.value(this.impl, this.name, obj);
    }

    public void value(Boolean obj) throws IOException {
        this.pWriter.value(this.impl, this.name, obj);
    }

    public void value(Character obj) throws IOException {
        this.pWriter.value(this.impl, this.name, obj);
    }

    public void value(String obj) throws IOException {
        this.pWriter.value(this.impl, this.name, obj);
    }

    public void beginArray() throws IOException {
        this.parentTypeStack.push(new StackNode(2));
        this.setParentWriter();
    }

    public void endArray() throws IOException {
        this.pWriter.endArray(this.impl, this.name);
        this.name = null;
        StackNode node = this.parentTypeStack.pop();
        while (node.elementCount > 0) {
            this.impl.pop();
            node.elementCount = (byte)(node.elementCount - 1);
        }
    }

    public void beginObject(ReflectyContext context, Class<?> clazz) throws IOException {
        boolean isMap = context.isMap(clazz);
        int lastType = -1;
        if (!this.parentTypeStack.isEmpty()) {
            lastType = this.parentTypeStack.peek().type;
        }
        XmlMemberProxy xmp = !this.mProxyStack.isEmpty() ? this.mProxyStack.peek() : null;
        StackNode node = new StackNode(isMap ? (byte)3 : 1);
        if (lastType == 2) {
            this.makeLastNameAsElement();
            this.doMakeElementName(xmp, node, false);
        } else if (isMap) {
            this.makeLastNameAsElement();
        } else {
            this.doMakeElementName(xmp, node, lastType == 3);
        }
        this.parentTypeStack.push(node);
        this.setParentWriter();
    }

    private void doMakeElementName(XmlMemberProxy xmp, StackNode node, boolean lastIsMap) throws IOException {
        String name = lastIsMap ? this.name : null;
        if (name == null && xmp != null) {
            name = xmp.elementName();
        }
        if (name == null && this.mElementName != null) {
            name = this.mElementName;
        }
        if (name == null) {
            throw new XmlException("you must config the xml element name by @XmlElement. it can often used for Class, field, and method.");
        }
        this.impl.element(name);
        node.elementCount = (byte)(node.elementCount + 1);
    }

    private void makeLastNameAsElement() throws IOException {
        if (this.name != null) {
            this.impl.element(this.name);
            this.name = null;
            this.parentTypeStack.peek().elementCount = (byte)(this.parentTypeStack.peek().elementCount + 1);
        }
    }

    public void endObject() throws IOException {
        this.name = null;
        this.impl.pop();
        this.parentTypeStack.pop();
    }

    public void flush() throws IOException {
        this.impl.flush();
    }

    @Override
    public void bodyText(Object value) throws IOException {
        this.impl.text(value);
    }

    @Override
    public void attribute(String name, Object value) throws IOException {
        this.impl.attribute(name, value);
    }

    @Override
    public void element(String name) throws IOException {
        this.impl.element(name);
        this.parentTypeStack.push(new StackNode(1));
        this.setParentWriter();
    }

    @Override
    public void pop() throws IOException {
        this.impl.pop();
    }

    private void setParentWriter() {
        if (this.parentTypeStack.isEmpty()) {
            return;
        }
        switch (this.parentTypeStack.peek().type) {
            case 2: {
                this.pWriter = this.mArrayWriter;
                break;
            }
            case 1: 
            case 3: {
                this.pWriter = this.mObjWriter;
            }
        }
    }

    public void beginWriteObject(ReflectyContext context, Class<?> defineClass, Object obj) {
        XmlElement xe = defineClass.getAnnotation(XmlElement.class);
        if (xe == null && obj != null) {
            xe = obj.getClass().getAnnotation(XmlElement.class);
        }
        this.mElementName = xe != null ? xe.value() : defineClass.getSimpleName();
    }

    public void endWriteObject() {
        this.mElementName = null;
    }

    public void beginWriteMemberProxy(ReflectyContext context, MemberProxy proxy) {
        System.out.println(proxy.getPropertyName());
        try {
            XmlMemberProxy mProxy = (XmlMemberProxy)proxy;
            mProxy.beginElement(this);
            this.mProxyStack.push(mProxy);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("for xml, member proxy should impl XmlMemberProxy.");
        }
    }

    public void endWriteMemberProxy() {
        this.mProxyStack.pop().endElement();
    }

    static class StackNode {
        final byte type;
        byte elementCount;

        public StackNode(byte type) {
            this.type = type;
        }
    }
}

