/*
 * Decompiled with CFR 0.152.
 */
package com.heaven7.java.xml;

import com.heaven7.java.reflecty.ReflectyContext;
import com.heaven7.java.reflectyio.ReflectyReader;
import com.heaven7.java.xml.Tree;
import com.heaven7.java.xml.XmlReaderImpl;
import com.heaven7.java.xml.XmlTree;
import java.io.IOException;
import java.io.Reader;

public final class XmlReader
implements ReflectyReader {
    private final XmlTree mRoot;
    private Tree mParent;
    private Tree mCurrent;

    public XmlReader(Reader reader) {
        XmlReaderImpl.Element element = new XmlReaderImpl().parse(reader);
        XmlTree xmlTree = new XmlTree(element);
        this.travel(xmlTree);
        this.mRoot = xmlTree;
        this.mCurrent = this.mRoot;
    }

    private void travel(XmlTree parent) {
        int size = parent.element.getChildCount();
        for (int i = 0; i < size; ++i) {
            XmlReaderImpl.Element ele = parent.element.getChild(i);
            XmlTree childTree = new XmlTree(ele);
            parent.addChild(childTree);
            this.travel(childTree);
        }
    }

    public void begin() {
    }

    public void end() {
        this.mRoot.reset();
        this.mCurrent = this.mRoot;
        this.mParent = null;
    }

    public String nextString() throws IOException {
        String value = this.mCurrent.getValue();
        this.mCurrent = null;
        return value;
    }

    public String nextName() throws IOException {
        return this.mCurrent.getName();
    }

    public void skipValue() throws IOException {
        this.mCurrent = null;
    }

    public boolean hasNext() throws IOException {
        if (this.mCurrent == null) {
            this.mCurrent = this.mParent.nextChild();
        }
        return this.mCurrent != null;
    }

    public void beginArray() throws IOException {
        this.mParent = this.mCurrent;
        this.mCurrent = null;
    }

    public void endArray() throws IOException {
        this.mParent = this.mParent.getParent();
        this.mCurrent = null;
    }

    public void beginObject(ReflectyContext context, Class<?> clazz) throws IOException {
        this.mParent = this.mCurrent;
        this.mCurrent = null;
    }

    public void endObject() throws IOException {
        this.mParent = this.mParent.getParent();
        this.mCurrent = null;
    }

    public String readBodyText() throws IOException {
        return this.mCurrent.getBodyText();
    }
}

