/*
 * Decompiled with CFR 0.152.
 */
package com.heaven7.java.xml;

import com.heaven7.java.xml.XmlElement;

class XmlMemberProxyHelper {
    private final ThreadLocal<Integer> mLocalIndex = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return -1;
        }
    };
    private String elementPath;
    private String[] elementNames;
    private final Callback mCallback;

    public XmlMemberProxyHelper(Callback mCallback) {
        this.mCallback = mCallback;
    }

    public String elementName(boolean next) {
        if (!this.init()) {
            return null;
        }
        Integer index = this.mLocalIndex.get();
        if (next) {
            if (index >= this.elementNames.length - 1) {
                return null;
            }
            this.mLocalIndex.set(index + 1);
            index = index + 1;
            return this.elementNames[index];
        }
        return this.elementNames[index];
    }

    public boolean hasNextName() {
        if (!this.init()) {
            return false;
        }
        return this.mLocalIndex.get() < this.elementNames.length - 1;
    }

    public void reset() {
        this.mLocalIndex.set(-1);
    }

    private boolean init() {
        if (this.elementPath == null) {
            XmlElement element = this.mCallback.getXmlElement();
            if (element == null) {
                return false;
            }
            this.elementPath = element.value();
            this.elementNames = this.elementPath.split("/");
        }
        return true;
    }

    public static interface Callback {
        public XmlElement getXmlElement();
    }
}

