/*
 * Decompiled with CFR 0.152.
 */
package com.heaven7.java.reflectyio.adapter;

import com.heaven7.java.reflecty.iota.TypeAdapter;
import com.heaven7.java.reflectyio.ReflectyEvaluator;
import com.heaven7.java.reflectyio.ReflectyReader;
import com.heaven7.java.reflectyio.ReflectyWriter;
import com.heaven7.java.reflectyio.adapter.AbstractBasicTypeAdapter;
import com.heaven7.java.reflectyio.adapter.AbstractTypeAdapter;
import java.io.IOException;
import java.lang.reflect.Constructor;

public class CommonTypeAdapter<T>
extends AbstractBasicTypeAdapter {
    private final Constructor<T> constructor;

    public CommonTypeAdapter(ReflectyEvaluator evaluator, Class<T> clazz) {
        super(evaluator);
        try {
            this.constructor = clazz.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    protected TypeAdapter<ReflectyWriter, ReflectyReader> onCreateNameTypeAdapter() {
        return new NameTypeAdapter(this.getEvaluator(), this.constructor);
    }

    public int write(ReflectyWriter sink, Object obj) throws IOException {
        if (obj == null) {
            sink.nullValue();
            return this.getEvaluator().evaluateNullSize();
        }
        if (obj instanceof Number) {
            sink.value((Number)obj);
            return this.getEvaluator().evaluateNumber((Number)obj);
        }
        if (obj instanceof Boolean) {
            sink.value((Boolean)obj);
            return this.getEvaluator().evaluateBoolean((Boolean)obj);
        }
        throw new UnsupportedOperationException("maybe your type is not matched with actual type.");
    }

    public Object read(ReflectyReader source) throws IOException {
        String str = source.nextString();
        if (str != null) {
            try {
                return this.constructor.newInstance(str);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private static class NameTypeAdapter
    extends AbstractTypeAdapter {
        final Constructor<?> constructor;

        NameTypeAdapter(ReflectyEvaluator evaluator, Constructor<?> constructor) {
            super(evaluator);
            this.constructor = constructor;
        }

        public int write(ReflectyWriter sink, Object obj) throws IOException {
            if (obj != null) {
                sink.name(obj.toString());
                return this.getEvaluator().evaluateString(obj.toString());
            }
            return 0;
        }

        public Object read(ReflectyReader source) throws IOException {
            String str = source.nextName();
            try {
                return this.constructor.newInstance(str);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

