/*
 * Decompiled with CFR 0.152.
 */
package com.heaven7.java.reflectyio.adapter;

import com.heaven7.java.reflecty.iota.TypeAdapter;
import com.heaven7.java.reflectyio.ReflectyEvaluator;
import com.heaven7.java.reflectyio.ReflectyReader;
import com.heaven7.java.reflectyio.ReflectyWriter;
import com.heaven7.java.reflectyio.adapter.AbstractBasicTypeAdapter;
import com.heaven7.java.reflectyio.adapter.AbstractTypeAdapter;
import java.io.IOException;

public class CharAdapter
extends AbstractBasicTypeAdapter {
    public CharAdapter(ReflectyEvaluator evaluator) {
        super(evaluator);
    }

    public int write(ReflectyWriter sink, Object obj) throws IOException {
        if (obj != null) {
            sink.value((Character)obj);
            return this.getEvaluator().evaluateCharacter((Character)obj);
        }
        sink.nullValue();
        return this.getEvaluator().evaluateNullSize();
    }

    public Object read(ReflectyReader source) throws IOException {
        String str = source.nextString();
        if (str != null) {
            return Character.valueOf((char)Integer.parseInt(str));
        }
        return null;
    }

    protected TypeAdapter<ReflectyWriter, ReflectyReader> onCreateNameTypeAdapter() {
        return new NameTypeAdapter(this.getEvaluator());
    }

    private static class NameTypeAdapter
    extends AbstractTypeAdapter {
        public NameTypeAdapter(ReflectyEvaluator evaluator) {
            super(evaluator);
        }

        public int write(ReflectyWriter sink, Object obj) throws IOException {
            if (obj != null) {
                sink.name(obj.toString());
                return this.getEvaluator().evaluateString(obj.toString());
            }
            return 0;
        }

        public Object read(ReflectyReader source) throws IOException {
            String str = source.nextName();
            return Character.valueOf((char)Integer.parseInt(str));
        }
    }
}

