/*
 * Decompiled with CFR 0.152.
 */
package com.heaven7.java.reflectyio.adapter;

import com.heaven7.java.reflecty.iota.TypeAdapter;
import com.heaven7.java.reflectyio.ReflectyEvaluator;
import com.heaven7.java.reflectyio.ReflectyReader;
import com.heaven7.java.reflectyio.ReflectyWriter;
import com.heaven7.java.reflectyio.adapter.AbstractTypeAdapter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;

public final class ArrayTypeAdapter
extends AbstractTypeAdapter {
    private final TypeAdapter<ReflectyWriter, ReflectyReader> mComponentAdapter;
    private final Class<?> mComponentClass;

    public ArrayTypeAdapter(ReflectyEvaluator evaluator, Class<?> componentClass, TypeAdapter<ReflectyWriter, ReflectyReader> mComponentAdapter) {
        super(evaluator);
        this.mComponentClass = componentClass;
        this.mComponentAdapter = mComponentAdapter;
    }

    public int write(ReflectyWriter sink, Object obj) throws IOException {
        sink.beginArray();
        if (obj != null) {
            int length = Array.getLength(obj);
            for (int i = 0; i < length; ++i) {
                Object o = Array.get(obj, i);
                this.mComponentAdapter.write((Object)sink, o);
            }
        }
        sink.endArray();
        return 0;
    }

    public Object read(ReflectyReader source) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        source.beginArray();
        while (source.hasNext()) {
            Object ele = this.mComponentAdapter.read((Object)source);
            list.add(ele);
        }
        source.endArray();
        return list.toArray((Object[])Array.newInstance(this.mComponentClass, list.size()));
    }
}

