/*
 * Decompiled with CFR 0.152.
 */
package com.heaven7.java.reflectyio;

import com.heaven7.java.reflecty.Reflecty;
import com.heaven7.java.reflecty.ReflectyBuilder;
import com.heaven7.java.reflecty.ReflectyContext;
import com.heaven7.java.reflecty.ReflectyDelegate;
import com.heaven7.java.reflecty.SimpleReflectyContext;
import com.heaven7.java.reflecty.TypeToken;
import com.heaven7.java.reflecty.iota.ITypeAdapterManager;
import com.heaven7.java.reflecty.iota.TypeAdapter;
import com.heaven7.java.reflectyio.ReflectyEvaluator;
import com.heaven7.java.reflectyio.ReflectyReader;
import com.heaven7.java.reflectyio.ReflectyTypeAdapterManager;
import com.heaven7.java.reflectyio.ReflectyWriter;
import com.heaven7.java.reflectyio.SimpleReflectyEvaluator;
import com.heaven7.java.reflectyio.anno.ReflectyClass;
import com.heaven7.java.reflectyio.anno.ReflectyField;
import com.heaven7.java.reflectyio.anno.ReflectyInherit;
import com.heaven7.java.reflectyio.anno.ReflectyMethod;
import com.heaven7.java.reflectyio.plugin.ReflectyPlugin;
import com.heaven7.java.reflectyio.plugin.ReflectyPluginManager;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;

public final class ReflectyIo {
    public static final int PLUGIN_TYPE_XML = 1;
    public static final int PLUGIN_TYPE_YAML = 2;
    public static final int PLUGIN_TYPE_JSON = 3;
    private ReflectyEvaluator evaluator;
    private ReflectyContext context;
    private Reflecty<TypeAdapter<ReflectyWriter, ReflectyReader>, ReflectyClass, ReflectyField, ReflectyMethod, ReflectyInherit> reflecty;
    private ITypeAdapterManager<ReflectyWriter, ReflectyReader> tam;
    private Type type;
    private float version = 1.0f;
    private TypeAdapter<ReflectyWriter, ReflectyReader> adapter;
    private ReflectyPlugin plugin;

    public ReflectyIo evaluator(ReflectyEvaluator evaluator) {
        this.evaluator = evaluator;
        return this;
    }

    public ReflectyIo context(ReflectyContext context) {
        this.context = context;
        return this;
    }

    public ReflectyIo reflecty(Reflecty<TypeAdapter<ReflectyWriter, ReflectyReader>, ReflectyClass, ReflectyField, ReflectyMethod, ReflectyInherit> reflecty) {
        this.reflecty = reflecty;
        return this;
    }

    public ReflectyIo delegate(ReflectyDelegate<TypeAdapter<ReflectyWriter, ReflectyReader>, ReflectyClass, ReflectyField, ReflectyMethod, ReflectyInherit> delegate) {
        this.reflecty = new ReflectyBuilder().classAnnotation(ReflectyClass.class).fieldAnnotation(ReflectyField.class).methodAnnotation(ReflectyMethod.class).inheritAnnotation(ReflectyInherit.class).delegate(delegate).build();
        return this;
    }

    public ReflectyIo tam(ITypeAdapterManager<ReflectyWriter, ReflectyReader> tam) {
        this.tam = tam;
        return this;
    }

    public ReflectyIo pluginType(int type) {
        try {
            this.plugin = ReflectyPluginManager.getDefault().getReflectyPlugin(type);
            this.tam = this.plugin.createTypeAdapterManager();
        }
        catch (NullPointerException e) {
            throw new RuntimeException("you should register reflecty plugin for type = " + type + " first. see @ReflectyPluginManager.");
        }
        return this;
    }

    public ReflectyIo xml() {
        return this.pluginType(1);
    }

    public ReflectyIo yaml() {
        return this.pluginType(2);
    }

    public ReflectyIo json() {
        return this.pluginType(3);
    }

    public ReflectyIo type(Type type) {
        this.type = type;
        return this;
    }

    public ReflectyIo typeToken(TypeToken<?> tt) {
        this.type = tt.getType();
        return this;
    }

    public ReflectyIo version(float version) {
        this.version = version;
        if (version <= 0.0f) {
            throw new IllegalArgumentException();
        }
        return this;
    }

    public ReflectyIo build() {
        this.buildTamInternal();
        if (this.type != null) {
            this.adapter = TypeAdapter.ofType((Type)this.type, this.tam, (float)this.version);
        }
        return this;
    }

    public void write(ReflectyWriter writer, Object obj) throws IOException {
        if (this.tam == null) {
            throw new IllegalStateException("you must call method '#build()' first.");
        }
        if (this.adapter == null) {
            ReflectyContext context = this.tam.getReflectyContext();
            if ((context.isCollection(obj.getClass()) || context.isMap(obj.getClass())) && this.type == null) {
                throw new IllegalStateException("for collection/map , type can't be null");
            }
            this.adapter = this.tam.createObjectTypeAdapter(obj.getClass(), this.version);
        }
        writer.begin(obj);
        this.adapter.write((Object)writer, obj);
        writer.end(obj);
        writer.flush();
    }

    public void write(Writer writer1, Object obj) throws IOException {
        if (this.plugin == null) {
            throw new IllegalStateException("you must call #pluginType() first.");
        }
        this.write(this.plugin.createReflectyWriter(writer1), obj);
    }

    public void write2(Writer writer, Object obj) {
        try {
            this.write(writer, obj);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void write2(ReflectyWriter writer, Object obj) {
        try {
            this.write(writer, obj);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T read(ReflectyReader reader) throws IOException {
        if (this.tam == null) {
            throw new IllegalStateException("you must call method '#build()' first.");
        }
        if (this.type == null) {
            throw new IllegalStateException("for read. type can't be null");
        }
        reader.begin();
        Object result = this.adapter.read((Object)reader);
        reader.end();
        return (T)result;
    }

    public <T> T read(Reader reader) throws IOException {
        if (this.plugin == null) {
            throw new IllegalStateException("you must call #pluginType() first.");
        }
        return this.read(this.plugin.createReflectyReader(reader));
    }

    public <T> T read2(ReflectyReader reader) {
        try {
            return this.read(reader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T read2(Reader reader) {
        try {
            return this.read(reader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void buildTamInternal() {
        if (this.tam == null) {
            if (this.reflecty == null) {
                throw new IllegalStateException("reflecty can't be null.");
            }
            if (this.context == null) {
                this.context = new SimpleReflectyContext();
            }
            if (this.evaluator == null) {
                this.evaluator = SimpleReflectyEvaluator.INSTANCE;
            }
            this.tam = new ReflectyTypeAdapterManager(this.context, this.evaluator, this.reflecty);
        }
    }
}

