/*
 * Decompiled with CFR 0.152.
 */
package com.heaven7.java.reflecty.utils;

import com.heaven7.java.base.util.Predicates;
import com.heaven7.java.reflecty.ReflectyContext;
import com.heaven7.java.reflecty.TypeNode;
import com.heaven7.java.reflecty.iota.ITypeAdapterManager;
import com.heaven7.java.reflecty.iota.TypeAdapter;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class IotaUtils {
    public static <Out, In> TypeAdapter<Out, In> getTypeAdapter(TypeNode node, ITypeAdapterManager<Out, In> delegate, float applyVersion) {
        if (node.isArray()) {
            TypeNode subNode = node.getSubNode(0);
            return delegate.createArrayTypeAdapter(subNode.getTypeClass(0), IotaUtils.getTypeAdapter(subNode, delegate, applyVersion));
        }
        ReflectyContext context = delegate.getReflectyContext();
        Class<?> type = node.getRawClass();
        if (type != null) {
            TypeAdapter<Out, In> typeAdapter = delegate.getTypeAdapter(node, applyVersion);
            if (typeAdapter != null) {
                return typeAdapter;
            }
            TypeAdapter<Out, In> adapter = delegate.getBasicTypeAdapter(type);
            if (adapter != null) {
                return adapter;
            }
            if (Collection.class.isAssignableFrom(type) || context.isCollection(type)) {
                TypeAdapter<Out, In> ta = node.getSubNodeCount() == 0 ? delegate.getElementAdapter(type) : IotaUtils.getTypeAdapter(node.getSubNode(0), delegate, applyVersion);
                if (ta == null) {
                    throw new IllegalStateException("can't find target element adapter for collection class = " + type.getName());
                }
                return delegate.createCollectionTypeAdapter(type, ta);
            }
            if (Map.class.isAssignableFrom(type) || context.isMap(type)) {
                TypeAdapter<Out, In> value;
                TypeAdapter<Out, In> key;
                int count = node.getSubNodeCount();
                switch (count) {
                    case 0: {
                        key = delegate.getKeyAdapter(type);
                        value = delegate.getValueAdapter(type);
                        break;
                    }
                    case 1: {
                        key = delegate.getKeyAdapter(type);
                        value = IotaUtils.getTypeAdapter(node.getSubNode(0), delegate, applyVersion);
                        break;
                    }
                    case 2: {
                        key = IotaUtils.getTypeAdapter(node.getSubNode(0), delegate, applyVersion);
                        value = IotaUtils.getTypeAdapter(node.getSubNode(1), delegate, applyVersion);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("sub node count for map must <= 2. but is " + count);
                    }
                }
                if (key == null) {
                    throw new IllegalStateException("can't find target key adapter for map class = " + type.getName());
                }
                if (value == null) {
                    throw new IllegalStateException("can't find target value adapter for map class = " + type.getName());
                }
                return delegate.createMapTypeAdapter(type, key, value);
            }
            return delegate.createObjectTypeAdapter(type, applyVersion);
        }
        List<TypeNode> nodes = node.getVariableNodes();
        if (!Predicates.isEmpty(nodes)) {
            return IotaUtils.getTypeAdapter(nodes.get(0), delegate, applyVersion);
        }
        throw new UnsupportedOperationException("un-reach here");
    }
}

