/*
 * Decompiled with CFR 0.152.
 */
package com.heaven7.java.reflecty;

import com.heaven7.java.base.util.SparseArrayDelegate;
import com.heaven7.java.base.util.SparseFactory;
import com.heaven7.java.reflecty.ReflectyContext;
import com.heaven7.java.reflecty.Wrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;

public class SimpleReflectyContext
implements ReflectyContext {
    @Override
    public Object newInstance(Class<?> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map createMap(Class<?> clazz) {
        if (SparseArrayDelegate.class.isAssignableFrom(clazz)) {
            return new SparseArrayMap(SparseFactory.newSparseArray((int)10));
        }
        if (ConcurrentHashMap.class.isAssignableFrom(clazz)) {
            return new ConcurrentHashMap();
        }
        if (WeakHashMap.class.isAssignableFrom(clazz)) {
            return new WeakHashMap();
        }
        if (LinkedHashMap.class.isAssignableFrom(clazz)) {
            return new LinkedHashMap();
        }
        if (SortedMap.class.isAssignableFrom(clazz)) {
            return new TreeMap();
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return new HashMap();
        }
        return null;
    }

    @Override
    public Map getMap(Object obj) {
        if (obj instanceof Map) {
            return (Map)obj;
        }
        if (obj instanceof SparseArrayDelegate) {
            return new SparseArrayMap((SparseArrayDelegate)obj);
        }
        return null;
    }

    @Override
    public Collection createCollection(Class<?> clazz) {
        if (LinkedList.class.isAssignableFrom(clazz)) {
            return new LinkedList();
        }
        if (Vector.class.isAssignableFrom(clazz)) {
            return new Vector();
        }
        if (CopyOnWriteArrayList.class.isAssignableFrom(clazz)) {
            return new CopyOnWriteArrayList();
        }
        if (List.class.isAssignableFrom(clazz)) {
            return new ArrayList();
        }
        if (CopyOnWriteArraySet.class.isAssignableFrom(clazz)) {
            return new CopyOnWriteArraySet();
        }
        if (SortedSet.class.isAssignableFrom(clazz)) {
            return new TreeSet();
        }
        if (Set.class.isAssignableFrom(clazz)) {
            return new HashSet();
        }
        return null;
    }

    @Override
    public Collection getCollection(Object obj) {
        if (obj instanceof Collection) {
            return (Collection)obj;
        }
        return null;
    }

    @Override
    public boolean isCollection(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz);
    }

    @Override
    public boolean isMap(Class<?> rawType) {
        return Map.class.isAssignableFrom(rawType) || SparseArrayDelegate.class.isAssignableFrom(rawType);
    }

    private static class SparseArrayMap<V>
    implements Map<Integer, V>,
    Wrapper<SparseArrayDelegate<V>> {
        private final SparseArrayDelegate<V> sad;

        public SparseArrayMap(SparseArrayDelegate<V> sad) {
            this.sad = sad;
        }

        @Override
        public int size() {
            return this.sad.size();
        }

        @Override
        public boolean isEmpty() {
            return this.sad.size() == 0;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.sad.indexOfKey(((Integer)key).intValue()) >= 0;
        }

        @Override
        public boolean containsValue(Object value) {
            return this.sad.indexOfValue(value) >= 0;
        }

        @Override
        public V get(Object key) {
            return (V)this.sad.get(((Integer)key).intValue());
        }

        @Override
        public V put(Integer key, V value) {
            return (V)this.sad.put(key.intValue(), value);
        }

        @Override
        public V remove(Object key) {
            return (V)this.sad.getAndRemove(((Integer)key).intValue());
        }

        @Override
        public void putAll(Map<? extends Integer, ? extends V> m) {
            for (Map.Entry<Integer, V> en : m.entrySet()) {
                this.sad.put(en.getKey().intValue(), en.getValue());
            }
        }

        @Override
        public void clear() {
            this.sad.clear();
        }

        @Override
        public Set<Integer> keySet() {
            int size = this.sad.size();
            HashSet<Integer> set = new HashSet<Integer>();
            for (int i = 0; i < size; ++i) {
                set.add(this.sad.keyAt(i));
            }
            return set;
        }

        @Override
        public Collection<V> values() {
            return this.sad.getValues();
        }

        @Override
        public Set<Map.Entry<Integer, V>> entrySet() {
            int size = this.sad.size();
            HashSet<Map.Entry<Integer, V>> set = new HashSet<Map.Entry<Integer, V>>();
            for (int i = 0; i < size; ++i) {
                set.add(new Entry0<Object>(this.sad, this.sad.keyAt(i), this.sad.valueAt(i)));
            }
            return set;
        }

        @Override
        public SparseArrayDelegate<V> unwrap() {
            return this.sad;
        }

        private static class Entry0<V>
        implements Map.Entry<Integer, V> {
            final SparseArrayDelegate<V> sad;
            Integer key;
            V value;

            public Entry0(SparseArrayDelegate<V> sad, Integer key, V value) {
                this.sad = sad;
                this.key = key;
                this.value = value;
            }

            @Override
            public Integer getKey() {
                return this.key;
            }

            @Override
            public V getValue() {
                return this.value;
            }

            @Override
            public V setValue(V value) {
                Object old = this.sad.put(this.key.intValue(), value);
                this.value = value;
                return (V)old;
            }

            @Override
            public boolean equals(Object obj) {
                if (obj == null || !(obj instanceof Entry0)) {
                    return false;
                }
                Entry0 e2 = (Entry0)obj;
                return (this.getKey() == null ? e2.getKey() == null : this.getKey().equals(e2.getKey())) && (this.getValue() == null ? e2.getValue() == null : this.getValue().equals(e2.getValue()));
            }

            @Override
            public int hashCode() {
                return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
            }
        }
    }
}

