/*
 * Decompiled with CFR 0.152.
 */
package com.heaven7.java.base.util.threadpool;

import com.heaven7.java.base.util.Throwables;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolExecutor2
extends ThreadPoolExecutor {
    private boolean exceptionStrictly;

    public ThreadPoolExecutor2(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public ThreadPoolExecutor2(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    public ThreadPoolExecutor2(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
    }

    public ThreadPoolExecutor2(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    public boolean isExceptionStrictly() {
        return this.exceptionStrictly;
    }

    public void setExceptionStrictly(boolean exceptionStrictly) {
        this.exceptionStrictly = exceptionStrictly;
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        Throwables.handleExceptionSmartly(t, this.exceptionStrictly);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new FutureTask2<T>(callable, this.exceptionStrictly);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return new FutureTask2<T>(runnable, value, this.exceptionStrictly);
    }

    public static class Builder {
        private int corePoolSize;
        private int maximumPoolSize;
        private long keepAliveTime;
        private TimeUnit timeUnit;
        private BlockingQueue<Runnable> workQueue;
        private ThreadFactory threadFactory;
        private RejectedExecutionHandler rejectedExecutionHandler;
        private boolean exceptionStrictly;

        public Builder setCorePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
            return this;
        }

        public Builder setMaximumPoolSize(int maximumPoolSize) {
            this.maximumPoolSize = maximumPoolSize;
            return this;
        }

        public Builder setKeepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            this.keepAliveTime = keepAliveTime;
            assert (timeUnit != null);
            return this;
        }

        public Builder setWorkQueue(BlockingQueue<Runnable> workQueue) {
            this.workQueue = workQueue;
            return this;
        }

        public Builder setThreadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
            this.rejectedExecutionHandler = rejectedExecutionHandler;
            return this;
        }

        public Builder setExceptionStrictly(boolean exceptionStrictly) {
            this.exceptionStrictly = exceptionStrictly;
            return this;
        }

        public ThreadPoolExecutor build() {
            if (this.maximumPoolSize <= 0 || this.keepAliveTime < 0L || this.corePoolSize < 0) {
                throw new IllegalStateException("param error");
            }
            if (this.workQueue == null) {
                throw new NullPointerException();
            }
            ThreadPoolExecutor2 instance = this.rejectedExecutionHandler == null ? (this.threadFactory != null ? new ThreadPoolExecutor2(this.corePoolSize, this.maximumPoolSize, this.keepAliveTime, this.timeUnit, this.workQueue, this.threadFactory) : new ThreadPoolExecutor2(this.corePoolSize, this.maximumPoolSize, this.keepAliveTime, this.timeUnit, this.workQueue)) : (this.threadFactory == null ? new ThreadPoolExecutor2(this.corePoolSize, this.maximumPoolSize, this.keepAliveTime, this.timeUnit, this.workQueue, this.rejectedExecutionHandler) : new ThreadPoolExecutor2(this.corePoolSize, this.maximumPoolSize, this.keepAliveTime, this.timeUnit, this.workQueue, this.threadFactory, this.rejectedExecutionHandler));
            instance.setExceptionStrictly(this.exceptionStrictly);
            return instance;
        }
    }

    static class FutureTask2<V>
    extends FutureTask<V> {
        private boolean exceptionStrictly;

        public FutureTask2(Callable<V> callable, boolean exceptionStrictly) {
            super(callable);
            this.exceptionStrictly = exceptionStrictly;
        }

        public FutureTask2(Runnable runnable, V result, boolean exceptionStrictly) {
            super(runnable, result);
            this.exceptionStrictly = exceptionStrictly;
        }

        @Override
        protected void done() {
            try {
                if (!this.isCancelled()) {
                    this.get();
                }
            }
            catch (ExecutionException e) {
                Throwables.handleExceptionSmartly(e, this.exceptionStrictly);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

