/*
 * Decompiled with CFR 0.152.
 */
package com.heaven7.java.base.util;

import com.heaven7.java.base.anno.Nullable;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class Throwables {
    private Throwables() {
    }

    public static void checkArgument(boolean expr, String msg) {
        if (!expr) {
            throw new IllegalStateException(msg);
        }
    }

    public static void handleExceptionSmartly(Throwable t, boolean exceptionStrictly) {
        if (t == null) {
            return;
        }
        if (t instanceof Error || exceptionStrictly) {
            throw new RuntimeException(t);
        }
        t.printStackTrace();
    }

    public static <X extends Throwable> void propagateIfInstanceOf(@Nullable Throwable throwable, Class<X> declaredType) throws X {
        if (throwable != null && declaredType.isInstance(throwable)) {
            throw (Throwable)declaredType.cast(throwable);
        }
    }

    public static void propagateIfPossible(@Nullable Throwable throwable) {
        Throwables.propagateIfInstanceOf(throwable, Error.class);
        Throwables.propagateIfInstanceOf(throwable, RuntimeException.class);
    }

    public static <X extends Throwable> void propagateIfPossible(@Nullable Throwable throwable, Class<X> declaredType) throws X {
        Throwables.propagateIfInstanceOf(throwable, declaredType);
        Throwables.propagateIfPossible(throwable);
    }

    public static <X1 extends Throwable, X2 extends Throwable> void propagateIfPossible(@Nullable Throwable throwable, Class<X1> declaredType1, Class<X2> declaredType2) throws X1, X2 {
        Throwables.propagateIfInstanceOf(throwable, declaredType1);
        Throwables.propagateIfPossible(throwable, declaredType2);
    }

    public static RuntimeException propagate(Throwable throwable) {
        Throwables.propagateIfPossible(throwable);
        throw new RuntimeException(throwable);
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable cause;
        while ((cause = throwable.getCause()) != null) {
            throwable = cause;
        }
        return throwable;
    }

    public static List<Throwable> getCausalChain(Throwable throwable) {
        ArrayList<Throwable> causes = new ArrayList<Throwable>(4);
        while (throwable != null) {
            causes.add(throwable);
            throwable = throwable.getCause();
        }
        return Collections.unmodifiableList(causes);
    }

    public static String getStackTraceAsString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static void checkNull(Object obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
    }

    public static void checkFileExist(String path) {
        File file = new File(path);
        if (!file.exists()) {
            throw new IllegalStateException("must be dir");
        }
    }

    public static <T> void checkEmpty(T[] ts) {
        if (ts == null) {
            throw new NullPointerException();
        }
        if (ts.length == 0) {
            throw new IllegalArgumentException();
        }
    }

    public static <T> void checkEmpty(Collection<T> coll) {
        if (coll == null) {
            throw new NullPointerException();
        }
        if (coll.size() == 0) {
            throw new IllegalArgumentException();
        }
    }

    public static <K, V> void checkEmpty(Map<K, V> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        if (map.size() == 0) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkEmpty(int[] arr) {
        if (arr == null) {
            throw new NullPointerException();
        }
        if (arr.length == 0) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkNonPositiveValue(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkNegativeValue(int value) {
        if (value < 0) {
            throw new IllegalArgumentException();
        }
    }
}

