/*
 * Decompiled with CFR 0.152.
 */
package com.heaven7.java.base.util;

import com.heaven7.java.base.util.IOUtils;
import com.heaven7.java.base.util.ResourceLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public final class TextReadHelper<Line> {
    private final Callback<Line> mCallback;

    public TextReadHelper(Callback<Line> mCallback) {
        this.mCallback = mCallback;
    }

    public List<Line> read(Object context, String url) throws LoadException {
        ArrayList<Line> results = new ArrayList<Line>();
        BufferedReader reader = null;
        try {
            String line;
            reader = this.mCallback.open(context, url);
            while ((line = reader.readLine()) != null) {
                Line l1 = this.mCallback.parse(line);
                if (l1 == null) continue;
                results.add(l1);
            }
        }
        catch (IOException e) {
            try {
                throw new LoadException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(reader);
        return results;
    }

    public static class LoadException
    extends RuntimeException {
        public LoadException() {
        }

        public LoadException(String message) {
            super(message);
        }

        public LoadException(String message, Throwable cause) {
            super(message, cause);
        }

        public LoadException(Throwable cause) {
            super(cause);
        }
    }

    public static abstract class Callback<Line> {
        public BufferedReader open(Object context, String link) throws IOException {
            return new BufferedReader(new InputStreamReader(ResourceLoader.getDefault().loadFileAsStream(context, link)));
        }

        public abstract Line parse(String var1);
    }
}

