/*
 * Decompiled with CFR 0.152.
 */
package com.heaven7.java.base.util;

import com.heaven7.java.base.anno.ThreadNotSafe;
import com.heaven7.java.base.util.SearchUtils;
import com.heaven7.java.base.util.SparseArrayDelegate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@com.heaven7.java.base.anno.Deprecated(value={"use SparseFactory instead."})
@ThreadNotSafe
public class SparseArray<E>
implements SparseArrayDelegate<E> {
    private static final Object DELETED = new Object();
    private boolean mGarbage = false;
    private int[] mKeys;
    private Object[] mValues;
    private int mSize;

    @Deprecated
    public SparseArray() {
        this(10);
    }

    @Deprecated
    public SparseArray(int initialCapacity) {
        this.mKeys = new int[initialCapacity];
        this.mValues = new Object[initialCapacity];
        this.mSize = 0;
    }

    @Override
    public E get(int key) {
        return this.get(key, null);
    }

    @Override
    public E get(int key, E valueIfKeyNotFound) {
        int i = SearchUtils.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i < 0 || this.mValues[i] == DELETED) {
            return valueIfKeyNotFound;
        }
        return (E)this.mValues[i];
    }

    @Override
    public void delete(int key) {
        int i = SearchUtils.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i >= 0 && this.mValues[i] != DELETED) {
            this.mValues[i] = DELETED;
            this.mGarbage = true;
        }
    }

    @Override
    public void remove(int key) {
        this.delete(key);
    }

    @Override
    public E getAndRemove(int key) {
        int i = SearchUtils.binarySearch(this.mKeys, 0, this.mSize, key);
        Object val = null;
        if (i >= 0 && this.mValues[i] != DELETED) {
            val = this.mValues[i];
            this.mValues[i] = DELETED;
            this.mGarbage = true;
        }
        return (E)val;
    }

    @Override
    public void removeAt(int index) {
        if (this.mValues[index] != DELETED) {
            this.mValues[index] = DELETED;
            this.mGarbage = true;
        }
    }

    @Override
    public void removeAtRange(int index, int size) {
        int end = Math.min(this.mSize, index + size);
        for (int i = index; i < end; ++i) {
            this.removeAt(i);
        }
    }

    private void gc() {
        int n = this.mSize;
        int o = 0;
        int[] keys = this.mKeys;
        Object[] values = this.mValues;
        for (int i = 0; i < n; ++i) {
            Object val = values[i];
            if (val == DELETED) continue;
            if (i != o) {
                keys[o] = keys[i];
                values[o] = val;
            }
            ++o;
        }
        this.mGarbage = false;
        this.mSize = o;
    }

    @Override
    public E put(int key, E value) {
        int i = SearchUtils.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i >= 0) {
            Object old = this.mValues[i];
            this.mValues[i] = value;
            if (old == DELETED) {
                return null;
            }
            return (E)old;
        }
        if ((i ^= 0xFFFFFFFF) < this.mSize && this.mValues[i] == DELETED) {
            this.mKeys[i] = key;
            this.mValues[i] = value;
            return null;
        }
        if (this.mGarbage && this.mSize >= this.mKeys.length) {
            this.gc();
            i = ~SearchUtils.binarySearch(this.mKeys, 0, this.mSize, key);
        }
        if (this.mSize >= this.mKeys.length) {
            int n = Math.max(this.mSize + 1, this.mKeys.length * 2);
            int[] nkeys = new int[n];
            Object[] nvalues = new Object[n];
            System.arraycopy(this.mKeys, 0, nkeys, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, nvalues, 0, this.mValues.length);
            this.mKeys = nkeys;
            this.mValues = nvalues;
        }
        if (this.mSize - i != 0) {
            System.arraycopy(this.mKeys, i, this.mKeys, i + 1, this.mSize - i);
            System.arraycopy(this.mValues, i, this.mValues, i + 1, this.mSize - i);
        }
        this.mKeys[i] = key;
        this.mValues[i] = value;
        ++this.mSize;
        return null;
    }

    @Override
    public int size() {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mSize;
    }

    @Override
    public int keyAt(int index) {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mKeys[index];
    }

    @Override
    public E valueAt(int index) {
        if (this.mGarbage) {
            this.gc();
        }
        return (E)this.mValues[index];
    }

    @Override
    public void setValueAt(int index, E value) {
        if (this.mGarbage) {
            this.gc();
        }
        this.mValues[index] = value;
    }

    @Override
    public int indexOfKey(int key) {
        if (this.mGarbage) {
            this.gc();
        }
        return SearchUtils.binarySearch(this.mKeys, 0, this.mSize, key);
    }

    @Override
    public int indexOfValue(E value) {
        return this.indexOfValue(value, true);
    }

    @Override
    public int indexOfValue(E value, boolean identity) {
        if (this.mGarbage) {
            this.gc();
        }
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mValues[i] == value) {
                return i;
            }
            if (identity || !this.mValues[i].equals(value)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void clear() {
        int n = this.mSize;
        Object[] values = this.mValues;
        for (int i = 0; i < n; ++i) {
            values[i] = null;
        }
        this.mSize = 0;
        this.mGarbage = false;
    }

    public void append(int key, E value) {
        int pos;
        if (this.mSize != 0 && key <= this.mKeys[this.mSize - 1]) {
            this.put(key, value);
            return;
        }
        if (this.mGarbage && this.mSize >= this.mKeys.length) {
            this.gc();
        }
        if ((pos = this.mSize) >= this.mKeys.length) {
            int n = Math.max(pos + 1, this.mKeys.length * 2);
            int[] nkeys = new int[n];
            Object[] nvalues = new Object[n];
            System.arraycopy(this.mKeys, 0, nkeys, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, nvalues, 0, this.mValues.length);
            this.mKeys = nkeys;
            this.mValues = nvalues;
        }
        this.mKeys[pos] = key;
        this.mValues[pos] = value;
        this.mSize = pos + 1;
    }

    @Override
    public void ensureCapacity(int capacity) {
        if (this.mGarbage && this.mSize >= this.mKeys.length) {
            this.gc();
        }
        if (this.mKeys.length < capacity) {
            int[] nkeys = new int[capacity];
            Object[] nvalues = new Object[capacity];
            System.arraycopy(this.mKeys, 0, nkeys, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, nvalues, 0, this.mValues.length);
            this.mKeys = nkeys;
            this.mValues = nvalues;
        }
    }

    @Override
    public List<E> getValues() {
        return Collections.unmodifiableList(Arrays.asList(this.mValues));
    }

    public int hashCode() {
        int result = 0;
        int s = this.size();
        for (int i = 0; i < s; ++i) {
            E value = this.valueAt(i);
            Integer key = this.keyAt(i);
            result += key.hashCode() ^ (value == null ? 0 : value.hashCode());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SparseArray)) {
            return false;
        }
        SparseArray sa = (SparseArray)obj;
        if (this.size() != sa.size()) {
            return false;
        }
        int s = this.size();
        for (int i = 0; i < s; ++i) {
            E mine = this.valueAt(i);
            int key = this.keyAt(i);
            E theirs = sa.get(key);
            if (!(mine == null ? theirs != null : !mine.equals(theirs))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.size() <= 0) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(this.mSize * 28);
        buffer.append('{');
        for (int i = 0; i < this.mSize; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            int key = this.keyAt(i);
            buffer.append(key);
            buffer.append('=');
            E value = this.valueAt(i);
            if (value != this) {
                buffer.append(value);
                continue;
            }
            buffer.append("(this Map)");
        }
        buffer.append('}');
        return buffer.toString();
    }
}

