/*
 * Decompiled with CFR 0.152.
 */
package com.heaven7.java.base.util;

import com.heaven7.java.base.util.Throwables;
import java.util.Comparator;
import java.util.List;

public final class SearchUtils {
    public static <T> int binarySearch(List<T> list, T key, Comparator<T> comparator) {
        return SearchUtils.binarySearch(list, 0, list.size(), key, comparator);
    }

    public static <T> int binarySearch(List<T> list, int start, int len, T key, Comparator<T> comparator) {
        Throwables.checkNull(comparator);
        int high = start + len;
        int low = start - 1;
        while (high - low > 1) {
            int guess = (high + low) / 2;
            if (comparator.compare(list.get(guess), key) < 0) {
                low = guess;
                continue;
            }
            high = guess;
        }
        if (high == start + len) {
            return ~(start + len);
        }
        if (comparator.compare(list.get(high), key) == 0) {
            return high;
        }
        return ~high;
    }

    public static int binarySearch(int[] a, int key) {
        return SearchUtils.binarySearch(a, 0, a.length, key);
    }

    public static int binarySearch(int[] a, int start, int len, int key) {
        int high = start + len;
        int low = start - 1;
        while (high - low > 1) {
            int guess = (high + low) / 2;
            if (a[guess] < key) {
                low = guess;
                continue;
            }
            high = guess;
        }
        if (high == start + len) {
            return ~(start + len);
        }
        if (a[high] == key) {
            return high;
        }
        return ~high;
    }
}

