/*
 * Decompiled with CFR 0.152.
 */
package com.heaven7.java.base.util;

import com.heaven7.java.base.anno.NeedAndroidImpl;
import com.heaven7.java.base.anno.Platform;
import com.heaven7.java.base.util.IOUtils;
import com.heaven7.java.base.util.Platforms;
import com.heaven7.java.base.util.TextReadHelper;
import com.heaven7.java.base.util.TextUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Properties;

@NeedAndroidImpl(value="org.heaven7.android.base.impl.ResourceLoaderImpl")
public abstract class ResourceLoader {
    static final String ANDROID_NAME = "org.heaven7.android.base.impl.ResourceLoaderImpl";
    private static final ResourceLoader sInstance;

    public static ResourceLoader getDefault() {
        if (sInstance == null) {
            throw new IllegalStateException("platform not support now.");
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] loadBytes(Object context, String path) throws IOException {
        InputStream in = this.loadFileAsStream(context, path);
        try {
            byte[] byArray = IOUtils.readBytes(in);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    public abstract InputStream loadFileAsStream(Object var1, String var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isFileExists(Object context, String path) {
        boolean bl;
        InputStream in = null;
        try {
            in = this.loadFileAsStream(context, path);
            bl = in != null;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly(in);
            return bl2;
        }
        IOUtils.closeQuietly(in);
        return bl;
    }

    public String loadFileAsString(Object context, String path) {
        String string;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(this.loadFileAsStream(context, path));
            string = IOUtils.readString(reader);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(reader);
        return string;
    }

    public <Line> List<Line> readLines(Object context, String path, TextReadHelper.Callback<Line> callback) {
        return new TextReadHelper<Line>(callback).read(context, path);
    }

    public List<String> loadFileAsStringLines(Object context, String path) {
        List<String> list;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(this.loadFileAsStream(context, path));
            list = IOUtils.readStringLines(reader);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(reader);
        return list;
    }

    public InputStream loadUrl(String path) {
        try {
            URL url = new URL(path);
            return url.openStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Properties loadFileAsProperties(Object context, String path) {
        InputStream in = null;
        try {
            in = this.loadFileAsStream(context, path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ResourceLoader.loadProperties(in, "load file failed. path = " + path);
    }

    public static Properties loadProperties(InputStream in, String exceptionMsg) {
        Properties prop = new Properties();
        try {
            prop.load(in);
            for (Map.Entry<Object, Object> en : prop.entrySet()) {
                Object value = en.getValue();
                if (!(value instanceof String)) continue;
                en.setValue(((String)value).trim());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(exceptionMsg);
        }
        finally {
            IOUtils.closeQuietly(in);
        }
        return prop;
    }

    static {
        String className;
        switch (Platforms.getSystemType()) {
            case 1: 
            case 2: 
            case 3: {
                className = PcResourceLoader.class.getName();
                break;
            }
            case 4: {
                className = ANDROID_NAME;
                break;
            }
            default: {
                throw new UnsupportedOperationException("system type = " + Platforms.getSystemType());
            }
        }
        try {
            sInstance = (ResourceLoader)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Platform
    static class PcResourceLoader
    extends ResourceLoader {
        PcResourceLoader() {
        }

        @Override
        public InputStream loadFileAsStream(Object context, String path) throws IOException {
            if (TextUtils.isRelativePath(path)) {
                return ResourceLoader.class.getClassLoader().getResourceAsStream(path);
            }
            return new FileInputStream(path);
        }
    }
}

