/*
 * Decompiled with CFR 0.152.
 */
package com.heaven7.java.base.util;

import com.heaven7.java.base.util.IOUtils;
import com.heaven7.java.base.util.Logger;
import com.heaven7.java.base.util.Predicates;
import com.heaven7.java.base.util.Throwables;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

public class FileUtils {
    public static final FileFilter TRUE_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return true;
        }
    };

    public static String getMD5Three(String path) {
        BigInteger bi = null;
        try {
            int len;
            byte[] buffer = new byte[8192];
            MessageDigest md = MessageDigest.getInstance("MD5");
            File f = new File(path);
            FileInputStream fis = new FileInputStream(f);
            while ((len = fis.read(buffer)) != -1) {
                md.update(buffer, 0, len);
            }
            fis.close();
            byte[] b = md.digest();
            bi = new BigInteger(1, b);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return bi.toString(16);
    }

    public static String createFilePath(String baseDir, String simpleFileName, String ... subDirs) {
        StringBuilder sb = new StringBuilder();
        sb.append(baseDir);
        if (subDirs != null) {
            for (String dir : subDirs) {
                sb.append(File.separator).append(dir);
            }
        }
        return sb.append(File.separator).append(simpleFileName).toString();
    }

    public static String getFileName(String path) {
        int index = path.lastIndexOf("/");
        if (index == -1) {
            index = path.lastIndexOf("\\");
        }
        return path.substring(index + 1, path.lastIndexOf("."));
    }

    public static String getSimpleFileName(String path) {
        String extension = FileUtils.getFileExtension(path);
        if (extension != null) {
            return FileUtils.getFileName(path) + "." + extension;
        }
        return FileUtils.getFileName(path);
    }

    public static String getLastPath(String path) {
        int index = path.lastIndexOf("/");
        if (index == -1) {
            index = path.lastIndexOf("\\");
        }
        return path.substring(0, index);
    }

    public static String getFileDir(String filepath, int depth, boolean fullPath) {
        if (depth < 1) {
            throw new IllegalArgumentException("depth must > 0");
        }
        File file = new File(filepath);
        if (file.exists()) {
            File parent = file;
            while (depth > 0) {
                --depth;
                if ((parent = parent.getParentFile()) != null) continue;
                return null;
            }
            return fullPath ? parent.getAbsolutePath() : parent.getName();
        }
        Logger.d("FileUtils", "getFileDir", "file not exist. filepath = " + filepath);
        return null;
    }

    public static String encodeChinesePath(String path) {
        return FileUtils.transformPath(path, new FilenameTransformer(){

            @Override
            public String transform(String name) {
                try {
                    return URLEncoder.encode(name, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    return name;
                }
            }
        });
    }

    public static String decodeChinesePath(String path) {
        return FileUtils.transformPath(path, new FilenameTransformer(){

            @Override
            public String transform(String name) {
                try {
                    return URLDecoder.decode(name, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    return name;
                }
            }
        });
    }

    public static String transformPath(String path, FilenameTransformer transformer) {
        String s;
        ArrayList<String> names = new ArrayList<String>();
        String tmpPath = path.contains(".") ? path.substring(0, path.lastIndexOf(".")) : path;
        File file = new File(tmpPath);
        if (!file.exists()) {
            Logger.d("", "transformPath", "path not exists. path = " + path);
        }
        File parent = file;
        do {
            names.add(parent.getName());
        } while ((parent = parent.getParentFile()) != null);
        StringBuilder sb = new StringBuilder();
        int index = path.indexOf(File.separator);
        if (index == -1) {
            throw new IllegalArgumentException();
        }
        sb.append(path.substring(0, index));
        for (String s2 : names) {
            sb.append(File.separator).append(transformer.transform(s2));
        }
        if (path.contains(".")) {
            sb.append(".").append(FileUtils.getFileExtension(path));
        }
        if ((s = sb.toString()).contains(":\\\\")) {
            s = s.replace(":\\\\", ":\\");
        }
        return s;
    }

    public static void writeTo(String file, String content) {
        FileUtils.writeTo(new File(file), content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTo(File dst, String content) {
        if (dst.isDirectory()) {
            throw new IllegalStateException();
        }
        if (!dst.getParentFile().exists()) {
            dst.getParentFile().mkdirs();
        }
        if (dst.exists()) {
            dst.delete();
        }
        if (content == null || content.length() == 0) {
            System.out.println("no content for: " + dst.getAbsolutePath());
            return;
        }
        FileWriter fw = null;
        try {
            fw = new FileWriter(dst);
            fw.write(content);
            fw.flush();
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fw);
                throw throwable;
            }
            IOUtils.closeQuietly(fw);
        }
        IOUtils.closeQuietly(fw);
    }

    public static boolean createFile(String path, boolean deleteIfExist) {
        File file = new File(path);
        if (file.exists()) {
            if (deleteIfExist) {
                file.delete();
            } else {
                return true;
            }
        }
        try {
            file.createNewFile();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static List<String> getFiles(File dir, String extension, FileFilter filter) {
        ArrayList<String> paths = new ArrayList<String>();
        FileUtils.getFiles(dir, extension, filter, paths);
        return paths;
    }

    public static List<String> getFiles(File dir, String extension) {
        ArrayList<String> paths = new ArrayList<String>();
        FileUtils.getFiles(dir, extension, TRUE_FILE_FILTER, paths);
        return paths;
    }

    public static void getFiles(File dir, String extension, List<String> outFiles) {
        FileUtils.getFiles(dir, extension, TRUE_FILE_FILTER, outFiles);
    }

    public static void getFiles(File dir, final String extension, final FileFilter filter, List<String> outFiles) {
        File[] dirs;
        File[] videoFiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (!pathname.isFile()) {
                    return false;
                }
                if (!filter.accept(pathname)) {
                    return false;
                }
                String extension2 = FileUtils.getFileExtension(pathname);
                return extension.equalsIgnoreCase(extension2);
            }
        });
        if (!Predicates.isEmpty(videoFiles)) {
            for (File file : videoFiles) {
                outFiles.add(file.getAbsolutePath());
            }
        }
        if (!Predicates.isEmpty(dirs = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        }))) {
            for (File dir1 : dirs) {
                FileUtils.getFiles(dir1, extension, filter, outFiles);
            }
        }
    }

    public static void getFiles(File dir, FileFilter filter, List<String> outFiles) {
        File[] dirs;
        File[] videoFiles = dir.listFiles(filter);
        if (!Predicates.isEmpty(videoFiles)) {
            for (File file : videoFiles) {
                outFiles.add(file.getAbsolutePath());
            }
        }
        if (!Predicates.isEmpty(dirs = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        }))) {
            for (File dir1 : dirs) {
                FileUtils.getFiles(dir1, filter, outFiles);
            }
        }
    }

    public static List<String> getFiles(File dir, FileFilter filter) {
        ArrayList<String> files = new ArrayList<String>();
        FileUtils.getFiles(dir, filter, files);
        return files;
    }

    public static boolean deleteDir(File dir) {
        String[] children;
        if (dir.isDirectory() && (children = dir.list()) != null) {
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtils.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static String getFileExtension(String filename) {
        try {
            return filename.substring(filename.lastIndexOf(".") + 1);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getFileExtension(File file) {
        return FileUtils.getFileExtension(file.getAbsolutePath());
    }

    public static boolean copyFilesFromDir(File srcDir, File dstDir, FileFilter filter) {
        if (!srcDir.exists()) {
            return false;
        }
        if (!dstDir.exists()) {
            dstDir.mkdirs();
        }
        String srcPath = srcDir.getAbsolutePath();
        List<String> files = FileUtils.getFiles(srcDir, filter);
        for (String s : files) {
            int index = s.indexOf(srcPath);
            String target = dstDir.getAbsolutePath() + s.substring(index + srcPath.length());
            FileUtils.copyFile(new File(s), new File(target));
        }
        return true;
    }

    public static boolean copyFile(File src, File dst) {
        if (!src.exists()) {
            return false;
        }
        if (!dst.getParentFile().exists()) {
            dst.getParentFile().mkdirs();
        } else if (dst.exists()) {
            dst.delete();
        }
        try {
            dst.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            int len;
            in = new BufferedInputStream(new FileInputStream(src));
            out = new BufferedOutputStream(new FileOutputStream(dst));
            byte[] buffer = new byte[4096];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            out.flush();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(in);
        IOUtils.closeQuietly(out);
        return true;
    }

    public static FileFilter createLastDirFileFilter(String dir) {
        Throwables.checkNull(dir);
        return new DirFileFilter(dir);
    }

    private static final class DirFileFilter
    implements FileFilter {
        private final String dir;

        DirFileFilter(String dir) {
            this.dir = dir;
        }

        @Override
        public boolean accept(File pathname) {
            return this.dir.equals(FileUtils.getFileDir(pathname.getAbsolutePath(), 1, false));
        }
    }

    public static interface FilenameTransformer {
        public String transform(String var1);
    }
}

