/*
 * Decompiled with CFR 0.152.
 */
package com.heaven7.android.StickyLayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.NestedScrollingChildHelper;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.heaven7.android.StickyLayout.R;
import com.heaven7.android.scroll.IScrollHelper;
import com.heaven7.android.scroll.NestedScrollFactory;
import com.heaven7.android.scroll.NestedScrollHelper;
import java.util.ArrayList;

public class StickyNavigationLayout
extends LinearLayout
implements NestedScrollingParent,
NestedScrollingChild {
    private static final String TAG = "StickyNavLayout";
    private static final boolean DEBUG = false;
    private final NestedScrollHelper mNestedHelper;
    private View mTop;
    private View mIndicator;
    private View mContentView;
    private int mTopViewId;
    private int mIndicatorId;
    private int mContentId;
    private int mTopViewHeight;
    private GroupCallbacks mGroupCallback;
    private final boolean mAutoFitScroll;
    private float mAutoFitPercent = 0.5f;
    private final NestedScrollingParentHelper mNestedScrollingParentHelper;
    private final NestedScrollingChildHelper mNestedScrollingChildHelper;
    private final int[] mParentScrollConsumed = new int[2];
    private final int[] mParentOffsetInWindow = new int[2];
    private boolean mEnableStickyTouch = true;

    public StickyNavigationLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mGroupCallback = new GroupCallbacks();
        this.mNestedScrollingParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        this.mNestedScrollingChildHelper = new NestedScrollingChildHelper((View)this);
        this.mNestedHelper = NestedScrollFactory.create((View)this, (NestedScrollHelper.NestedScrollCallback)new NestedScrollHelper.NestedScrollCallback(){

            public boolean canScrollHorizontally(View target) {
                return false;
            }

            public boolean canScrollVertically(View target) {
                return true;
            }

            public int getMaximumYScrollDistance(View target) {
                return StickyNavigationLayout.this.mTopViewHeight;
            }
        });
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.StickyNavigationLayout);
        this.mTopViewId = a.getResourceId(R.styleable.StickyNavigationLayout_stickyLayout_top_id, 0);
        this.mIndicatorId = a.getResourceId(R.styleable.StickyNavigationLayout_stickyLayout_indicator_id, 0);
        this.mContentId = a.getResourceId(R.styleable.StickyNavigationLayout_stickyLayout_content_id, 0);
        this.mAutoFitScroll = a.getBoolean(R.styleable.StickyNavigationLayout_stickyLayout_auto_fit_scroll, false);
        this.mAutoFitPercent = a.getFloat(R.styleable.StickyNavigationLayout_stickyLayout_threshold_percent, 0.5f);
        a.recycle();
        this.setNestedScrollingEnabled(true);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mTop = this.findViewById(this.mTopViewId);
        this.mIndicator = this.findViewById(this.mIndicatorId);
        this.mContentView = this.findViewById(this.mContentId);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mGroupCallback.afterOnMeasure(this, this.mTop, this.mIndicator, this.mContentView);
        if (this.mEnableStickyTouch && this.mContentView != null && this.mIndicator != null) {
            ViewGroup.LayoutParams params = this.mContentView.getLayoutParams();
            params.height = this.getMeasuredHeight() - this.mIndicator.getMeasuredHeight();
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.mEnableStickyTouch && this.mTop != null) {
            this.mTopViewHeight = this.mTop.getMeasuredHeight();
            ViewGroup.LayoutParams lp = this.mTop.getLayoutParams();
            if (lp instanceof ViewGroup.MarginLayoutParams) {
                this.mTopViewHeight += ((ViewGroup.MarginLayoutParams)lp).topMargin + ((ViewGroup.MarginLayoutParams)lp).bottomMargin;
            }
        }
    }

    public void addOnScrollChangeListener(IScrollHelper.OnScrollChangeListener l) {
        this.mNestedHelper.addOnScrollChangeListener(l);
    }

    public void removeOnScrollChangeListener(IScrollHelper.OnScrollChangeListener l) {
        this.mNestedHelper.removeOnScrollChangeListener(l);
    }

    public boolean hasOnScrollChangeListener(IScrollHelper.OnScrollChangeListener l) {
        return this.mNestedHelper.hasOnScrollChangeListener(l);
    }

    public int getScrollState() {
        return this.mNestedHelper.getScrollState();
    }

    public void setEnableStickyTouch(boolean enable) {
        if (this.mEnableStickyTouch != enable) {
            this.mEnableStickyTouch = enable;
            this.requestLayout();
        }
    }

    public boolean isStickyTouchEnabled() {
        return this.mEnableStickyTouch;
    }

    public void addStickyDelegate(IStickyCallback delegate) {
        this.mGroupCallback.addStickyDelegate(delegate);
    }

    public void removeStickyDelegate(IStickyCallback delegate) {
        this.mGroupCallback.removeStickyDelegate(delegate);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mEnableStickyTouch) {
            return super.onTouchEvent(event);
        }
        return this.mNestedHelper.onTouchEvent(event);
    }

    public boolean fling(int velocityX, int velocityY) {
        return this.mNestedHelper.fling((float)velocityX, (float)velocityY);
    }

    public final void smoothScrollTo(int x, int y) {
        this.mNestedHelper.smoothScrollBy(x - this.getScrollX(), y - this.getScrollY());
    }

    public final void smoothScrollBy(int dx, int dy) {
        this.mNestedHelper.smoothScrollBy(dx, dy);
    }

    public void computeScroll() {
        this.mNestedHelper.computeScroll();
    }

    protected Parcelable onSaveInstanceState() {
        SaveState saveState = new SaveState(super.onSaveInstanceState());
        saveState.mEnableStickyTouch = this.mEnableStickyTouch;
        return saveState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        super.onRestoreInstanceState(state);
        if (state != null) {
            SaveState ss = (SaveState)state;
            this.mEnableStickyTouch = ss.mEnableStickyTouch;
        }
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return this.isEnabled() && this.mEnableStickyTouch && (nestedScrollAxes & 2) != 0;
    }

    public void onNestedScrollAccepted(View child, View target, int nestedScrollAxes) {
        this.mNestedScrollingParentHelper.onNestedScrollAccepted(child, target, nestedScrollAxes);
        this.startNestedScroll(nestedScrollAxes & 2);
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        this.mNestedHelper.nestedScroll(dx, dy, consumed, true);
        int[] parentConsumed = this.mParentScrollConsumed;
        if (this.dispatchNestedPreScroll(dx - consumed[0], dy - consumed[1], parentConsumed, null)) {
            consumed[0] = consumed[0] + parentConsumed[0];
            consumed[1] = consumed[1] + parentConsumed[1];
        }
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        this.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, this.mParentOffsetInWindow);
    }

    public void onStopNestedScroll(View target) {
        this.checkAutoFitScroll();
        this.mNestedScrollingParentHelper.onStopNestedScroll(target);
        this.stopNestedScroll();
    }

    private void checkAutoFitScroll() {
        if (this.mAutoFitScroll) {
            float scrollY = this.getScrollY();
            if (scrollY >= (float)this.mTopViewHeight * this.mAutoFitPercent) {
                this.smoothScrollTo(0, this.mTopViewHeight);
            } else {
                this.smoothScrollTo(0, 0);
            }
        }
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        return this.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        return this.dispatchNestedPreFling(velocityX, velocityY);
    }

    public int getNestedScrollAxes() {
        return this.mNestedScrollingParentHelper.getNestedScrollAxes();
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.mNestedScrollingChildHelper.setNestedScrollingEnabled(enabled);
    }

    public boolean isNestedScrollingEnabled() {
        return this.mNestedScrollingChildHelper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int axes) {
        return this.mNestedScrollingChildHelper.startNestedScroll(axes);
    }

    public void stopNestedScroll() {
        this.mNestedScrollingChildHelper.stopNestedScroll();
    }

    public boolean hasNestedScrollingParent() {
        return this.mNestedScrollingChildHelper.hasNestedScrollingParent();
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow) {
        return this.mNestedScrollingChildHelper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow) {
        return this.mNestedScrollingChildHelper.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow);
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return this.mNestedScrollingChildHelper.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        return this.mNestedScrollingChildHelper.dispatchNestedPreFling(velocityX, velocityY);
    }

    public static interface IStickyCallback {
        public void afterOnMeasure(StickyNavigationLayout var1, View var2, View var3, View var4);
    }

    private class GroupCallbacks
    implements IStickyCallback {
        private final ArrayList<IStickyCallback> mDelegates = new ArrayList(5);

        private GroupCallbacks() {
        }

        public void addStickyDelegate(IStickyCallback delegate) {
            if (!this.mDelegates.contains(delegate)) {
                this.mDelegates.add(delegate);
            }
        }

        public void removeStickyDelegate(IStickyCallback delegate) {
            this.mDelegates.remove(delegate);
        }

        public void clear() {
            this.mDelegates.clear();
        }

        @Override
        public void afterOnMeasure(StickyNavigationLayout snv, View top, View indicator, View content) {
            for (IStickyCallback delegate : this.mDelegates) {
                delegate.afterOnMeasure(snv, top, indicator, content);
            }
        }
    }

    protected static class SaveState
    extends View.BaseSavedState {
        boolean mEnableStickyTouch;
        public static final Parcelable.Creator<SaveState> CREATOR = new Parcelable.Creator<SaveState>(){

            public SaveState createFromParcel(Parcel in) {
                return new SaveState(in);
            }

            public SaveState[] newArray(int size) {
                return new SaveState[size];
            }
        };

        public SaveState(Parcel source) {
            super(source);
            this.mEnableStickyTouch = source.readByte() == 1;
        }

        public SaveState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeByte((byte)(this.mEnableStickyTouch ? 1 : 0));
        }
    }
}

