/*
 * Decompiled with CFR 0.152.
 */
package com.heaven7.android.StickyLayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.NestedScrollingChildHelper;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.heaven7.android.StickyLayout.R;
import com.heaven7.android.scroll.IScrollHelper;
import com.heaven7.android.scroll.NestedScrollFactory;
import com.heaven7.android.scroll.NestedScrollHelper;

public class NestedScrollFrameLayout
extends FrameLayout
implements NestedScrollingChild,
NestedScrollingParent {
    private static final String TAG = NestedScrollFrameLayout.class.getSimpleName();
    private NestedScrollingParentHelper mNestedScrollingParentHelper;
    private NestedScrollingChildHelper mNestedScrollingChildHelper;
    private NestedScrollHelper mNestedHelper;
    private int[] mParentScrollConsumed = new int[2];
    private final int[] mParentOffsetInWindow = new int[2];
    private float mMaxYPercent = 1.0f;

    public NestedScrollFrameLayout(Context context) {
        this(context, null);
    }

    public NestedScrollFrameLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NestedScrollFrameLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.NestedScrollFrameLayout);
        this.mMaxYPercent = a.getFloat(R.styleable.NestedScrollFrameLayout_nsfl_max_y_percent, 1.0f);
        a.recycle();
        this.mNestedScrollingParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        this.mNestedScrollingChildHelper = new NestedScrollingChildHelper((View)this);
        this.mNestedHelper = NestedScrollFactory.create((View)this, (NestedScrollHelper.NestedScrollCallback)new NestedScrollHelper.NestedScrollCallback(){

            public boolean canScrollHorizontally(View target) {
                return false;
            }

            public boolean canScrollVertically(View target) {
                return true;
            }

            public int getMaximumYScrollDistance(View target) {
                return (int)((float)target.getHeight() * NestedScrollFrameLayout.this.mMaxYPercent);
            }
        });
        this.setNestedScrollingEnabled(true);
    }

    public void setMaximumYPercent(float maxYPercent) {
        this.mMaxYPercent = maxYPercent;
    }

    public float getMaximumYPercent() {
        return this.mMaxYPercent;
    }

    public int getScrollState() {
        return this.mNestedHelper.getScrollState();
    }

    public void addOnScrollChangeListener(IScrollHelper.OnScrollChangeListener l) {
        this.mNestedHelper.addOnScrollChangeListener(l);
    }

    public void removeOnScrollChangeListener(IScrollHelper.OnScrollChangeListener l) {
        this.mNestedHelper.removeOnScrollChangeListener(l);
    }

    public boolean hasOnScrollChangeListener(IScrollHelper.OnScrollChangeListener l) {
        return this.mNestedHelper.hasOnScrollChangeListener(l);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.isNestedScrollingEnabled()) {
            return super.onInterceptTouchEvent(ev);
        }
        return this.mNestedHelper.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isNestedScrollingEnabled()) {
            return super.onTouchEvent(event);
        }
        return this.mNestedHelper.onTouchEvent(event);
    }

    public void computeScroll() {
        this.mNestedHelper.computeScroll();
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return this.isEnabled() && (nestedScrollAxes & 2) != 0;
    }

    public void onNestedScrollAccepted(View child, View target, int nestedScrollAxes) {
        this.mNestedScrollingParentHelper.onNestedScrollAccepted(child, target, nestedScrollAxes);
        this.startNestedScroll(nestedScrollAxes & 2);
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        this.mNestedHelper.nestedScroll(dx, dy, consumed, true);
        int[] parentConsumed = this.mParentScrollConsumed;
        if (this.dispatchNestedPreScroll(dx - consumed[0], dy - consumed[1], parentConsumed, null)) {
            consumed[0] = consumed[0] + parentConsumed[0];
            consumed[1] = consumed[1] + parentConsumed[1];
        }
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        this.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, this.mParentOffsetInWindow);
    }

    public void onStopNestedScroll(View target) {
        this.mNestedScrollingParentHelper.onStopNestedScroll(target);
        this.stopNestedScroll();
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        return this.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        return this.dispatchNestedPreFling(velocityX, velocityY);
    }

    public int getNestedScrollAxes() {
        return this.mNestedScrollingParentHelper.getNestedScrollAxes();
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.mNestedScrollingChildHelper.setNestedScrollingEnabled(enabled);
    }

    public boolean isNestedScrollingEnabled() {
        return this.mNestedScrollingChildHelper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int axes) {
        return this.mNestedScrollingChildHelper.startNestedScroll(axes);
    }

    public void stopNestedScroll() {
        this.mNestedScrollingChildHelper.stopNestedScroll();
    }

    public boolean hasNestedScrollingParent() {
        return this.mNestedScrollingChildHelper.hasNestedScrollingParent();
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow) {
        return this.mNestedScrollingChildHelper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow) {
        return this.mNestedScrollingChildHelper.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow);
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return this.mNestedScrollingChildHelper.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        return this.mNestedScrollingChildHelper.dispatchNestedPreFling(velocityX, velocityY);
    }
}

