/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.office;

import com.healthmarketscience.jackcess.OfficeCryptCodecHandler;
import com.healthmarketscience.jackcess.PageChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.paddings.ZeroBytePadding;

public abstract class BlockCipherProvider
extends OfficeCryptCodecHandler {
    private BufferedBlockCipher _cipher;

    public BlockCipherProvider(PageChannel channel, byte[] encodingKey) {
        super(channel, encodingKey);
    }

    protected BufferedBlockCipher getBlockCipher() {
        if (this._cipher == null) {
            this._cipher = new PaddedBufferedBlockCipher(this.initCipher(), (BlockCipherPadding)new ZeroBytePadding());
        }
        return this._cipher;
    }

    public final boolean canEncodePartialPage() {
        return false;
    }

    protected BlockCipher initCipher() {
        switch (this.getPhase()) {
            case PWD_VERIFY: {
                return this.initPwdCipher();
            }
            case CRYPT: {
                return this.initCryptCipher();
            }
        }
        throw new RuntimeException("unknown phase " + (Object)((Object)this.getPhase()));
    }

    protected BlockCipher initPwdCipher() {
        throw new UnsupportedOperationException();
    }

    protected BlockCipher initCryptCipher() {
        throw new UnsupportedOperationException();
    }

    protected void decodePageImpl(ByteBuffer buffer, int pageNumber) {
        this.blockDecrypt(buffer, pageNumber);
    }

    public ByteBuffer encodePageImpl(ByteBuffer buffer, int pageNumber, int pageOffset) throws IOException {
        return this.blockEncrypt(buffer, pageNumber);
    }

    protected void reset() {
        super.reset();
        this._cipher = null;
    }
}

